/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.docsInfo.CMakeDocsInfoProvider;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeArgumentImplMixin;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import icons.CMakeIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeTargetUtils {
    public static final Map<String, ITargetArgumentPattern[]> TargetDefinitionCommandPatterns = new HashMap<String, ITargetArgumentPattern[]>();
    public static final Map<String, ITargetArgumentPattern[]> TargetReferenceCommandPatterns;

    @Nullable
    public static Icon getTargetDefinitionIcon(@NotNull CMakeArgument argument) {
        if (argument == null) {
            CMakeTargetUtils.$$$reportNull$$$0(0);
        }
        return CMakeTargetUtils.getTargetDefinitionIcon(argument.getParentCommandArguments().getCommand());
    }

    @Nullable
    public static Icon getTargetDefinitionIcon(@NotNull CMakeCommand cmd) {
        if (cmd == null) {
            CMakeTargetUtils.$$$reportNull$$$0(1);
        }
        if (CMakeTargetUtils.isTargetDefinitionCommand(cmd)) {
            String cmdName = StringUtil.notNullize((String)StringUtil.toLowerCase((String)CMakePsiUtils.findCommandName(cmd)));
            if (cmdName.contains("library")) {
                return CMakeIcons.AddLibrary;
            }
            if (cmdName.contains("executable")) {
                return CMakeIcons.AddExecutable;
            }
        }
        return null;
    }

    public static boolean isTargetDefinitionCommand(@NotNull CMakeCommand cmd) {
        if (cmd == null) {
            CMakeTargetUtils.$$$reportNull$$$0(2);
        }
        String cmdName = StringUtil.notNullize((String)CMakePsiUtils.findCommandName(cmd));
        return TargetDefinitionCommandPatterns.containsKey(StringUtil.toLowerCase((String)cmdName));
    }

    public static boolean isTargetAlias(@NotNull CMakeCommand cmd) {
        if (cmd == null) {
            CMakeTargetUtils.$$$reportNull$$$0(3);
        }
        if (CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_EXECUTABLE_COMMAND_NAME, CMakePsiUtils.findCommandName(cmd)) || CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_LIBRARY_COMMAND_NAME, CMakePsiUtils.findCommandName(cmd))) {
            return cmd.getCMakeArgumentList() != null && cmd.getCMakeArgumentList().size() >= 2 && Objects.equals(cmd.getCMakeArgumentList().get(1).getText(), "ALIAS");
        }
        return false;
    }

    @Nullable
    public static String getCMakeTargetName(@Nullable CMakeArgument argument) {
        if (argument == null) {
            return null;
        }
        if (argument.isCMakeTargetDefinitionName()) {
            CMakeCommand cmd = argument.getParentCommandArguments().getCommand();
            String cmdName = StringUtil.notNullize((String)CMakePsiUtils.findCommandName(cmd));
            if (cmdName.equalsIgnoreCase("externalproject_add_steptargets")) {
                CMakeCommandArguments args = cmd.getCMakeCommandArguments();
                if (args != null) {
                    return CMakeTargetUtils.getName(cmd.getCMakeCommandArguments().getFirstArgument()) + "-" + CMakeTargetUtils.getName(argument);
                }
                return null;
            }
            return CMakeTargetUtils.getName(argument);
        }
        if (argument.isCMakeTargetReferenceName()) {
            return CMakeTargetUtils.getName(argument);
        }
        return null;
    }

    @Nullable
    private static String getName(@Nullable CMakeArgument argument) {
        if (argument == null) {
            return null;
        }
        CMakeLiteral literal = argument.getCMakeLiteral();
        if (literal != null) {
            return literal.getText();
        }
        return null;
    }

    @NotNull
    public static @NotNull List<@NotNull CMakeArgument> getTargetDefinitionArguments(@NotNull CMakeCommand command) {
        String cmdName;
        if (command == null) {
            CMakeTargetUtils.$$$reportNull$$$0(4);
        }
        if (TargetDefinitionCommandPatterns.containsKey(cmdName = StringUtil.toLowerCase((String)CMakePsiUtils.findCommandName(command)))) {
            if (StringUtil.equals((CharSequence)cmdName, (CharSequence)"externalproject_add_steptargets")) {
                CMakeCommandArguments cmdArgs = command.getCMakeCommandArguments();
                if (cmdArgs == null) {
                    List<CMakeArgument> list = Collections.emptyList();
                    if (list == null) {
                        CMakeTargetUtils.$$$reportNull$$$0(5);
                    }
                    return list;
                }
                List<CMakeArgument> argumentList = command.getCMakeCommandArguments().getCMakeArgumentList();
                List list = argumentList.size() > 1 ? ContainerUtil.subList(argumentList, (int)1) : Collections.emptyList();
                if (list == null) {
                    CMakeTargetUtils.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<CMakeArgument> list = command.getFirstArgument() == null ? Collections.emptyList() : List.of(command.getFirstArgument());
            if (list == null) {
                CMakeTargetUtils.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<CMakeArgument> list = Collections.emptyList();
        if (list == null) {
            CMakeTargetUtils.$$$reportNull$$$0(8);
        }
        return list;
    }

    static {
        TargetDefinitionCommandPatterns.put("add_executable", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetDefinitionCommandPatterns.put("add_library", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetDefinitionCommandPatterns.put("add_custom_target", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetDefinitionCommandPatterns.put("cuda_add_executable", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetDefinitionCommandPatterns.put("cuda_add_library", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetDefinitionCommandPatterns.put("externalproject_add_steptargets", new ITargetArgumentPattern[]{CustomPattern.EXTERNALPROJECT_ADD_STEPTARGETS});
        TargetReferenceCommandPatterns = new HashMap<String, ITargetArgumentPattern[]>();
        TargetReferenceCommandPatterns.put("add_custom_command", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("add_dependencies", new ITargetArgumentPattern[]{PositionalPattern.MULTI_FIRST});
        TargetReferenceCommandPatterns.put("add_executable", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_ALIAS});
        TargetReferenceCommandPatterns.put("add_library", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_ALIAS});
        TargetReferenceCommandPatterns.put("build_command", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("ctest_build", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("else", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("elseif", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("endif", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("endwhile", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("export", new ITargetArgumentPattern[]{PrefixPattern.MULTI_TARGETS});
        TargetReferenceCommandPatterns.put("file", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("get_property", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("get_source_file_property", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET_DIRECTORY});
        TargetReferenceCommandPatterns.put("get_target_property", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_SECOND});
        TargetReferenceCommandPatterns.put("if", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("install", new ITargetArgumentPattern[]{PrefixPattern.MULTI_TARGETS, PrefixPattern.MULTI_IMPORTED_RUNTIME_ARTIFACTS});
        TargetReferenceCommandPatterns.put("install_targets", new ITargetArgumentPattern[]{CustomPattern.INSTALL_TARGETS});
        TargetReferenceCommandPatterns.put("set_property", new ITargetArgumentPattern[]{PrefixPattern.MULTI_TARGET, PrefixPattern.MULTI_TARGET_DIRECTORY});
        TargetReferenceCommandPatterns.put("set_source_files_properties", new ITargetArgumentPattern[]{PrefixPattern.MULTI_TARGET_DIRECTORY});
        TargetReferenceCommandPatterns.put("set_target_properties", new ITargetArgumentPattern[]{CustomPattern.SET_TARGET_PROPERTIES});
        TargetReferenceCommandPatterns.put("target_compile_definitions", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("target_compile_features", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("target_compile_options", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("target_include_directories", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("target_link_directories", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("target_link_libraries", new ITargetArgumentPattern[]{PrefixPattern.MULTI_NOTHING});
        TargetReferenceCommandPatterns.put("target_link_options", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("target_precompile_headers", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST, PrefixPattern.SINGLE_REUSE_FROM});
        TargetReferenceCommandPatterns.put("target_sources", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("try_compile", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET, PositionalPattern.SINGLE_FIFTH});
        TargetReferenceCommandPatterns.put("while", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("cmake_print_properties", new ITargetArgumentPattern[]{PrefixPattern.MULTI_TARGETS});
        TargetReferenceCommandPatterns.put("externaldata_add_target", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("externalproject_add", new ITargetArgumentPattern[]{PrefixPattern.MULTI_DEPENDS, PrefixPattern.MULTI_STEP_TARGETS, PrefixPattern.MULTI_INDEPENDENT_STEP_TARGETS});
        TargetReferenceCommandPatterns.put("externalproject_add_stepdependencies", new ITargetArgumentPattern[]{PositionalPattern.MULTI_THIRD});
        TargetReferenceCommandPatterns.put("cuda_add_cufft_to_target", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("cuda_add_cublas_to_target", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("cuda_compute_separable_compilation_object_file_name", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_SECOND});
        TargetReferenceCommandPatterns.put("cuda_link_separable_compilation_objects", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_SECOND});
        TargetReferenceCommandPatterns.put("cuda_wrap_srcs", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("doxygen_add_docs", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("matlab_add_mex", new ITargetArgumentPattern[]{PrefixPattern.LINK_TO});
        TargetReferenceCommandPatterns.put("squish_add_test", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_AUT});
        TargetReferenceCommandPatterns.put("xctest_add_bundle", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("gtest_add_tests", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("qtest_discover_tests", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("add_jar", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST, PrefixPattern.SINGLE_GENERATE_NATIVE_HEADERS});
        TargetReferenceCommandPatterns.put("install_jar", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("install_jni_symlink", new ITargetArgumentPattern[]{PositionalPattern.SINGLE_FIRST});
        TargetReferenceCommandPatterns.put("create_javah", new ITargetArgumentPattern[]{PrefixPattern.SINGLE_TARGET});
        TargetReferenceCommandPatterns.put("install_jar_exports", new ITargetArgumentPattern[]{PrefixPattern.MULTI_TARGETS});
        TargetReferenceCommandPatterns.put("export_jars", new ITargetArgumentPattern[]{PrefixPattern.MULTI_TARGETS});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/psi/util/CMakeTargetUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/psi/util/CMakeTargetUtils";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDefinitionArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTargetDefinitionIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTargetDefinitionCommand";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTargetAlias";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTargetDefinitionArguments";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static interface ITargetArgumentPattern {
        public boolean isTargetReference(@NotNull CMakeArgumentImplMixin var1);
    }

    static enum PositionalPattern implements ITargetArgumentPattern
    {
        SINGLE_FIRST(0, false),
        SINGLE_SECOND(1, false),
        SINGLE_FIFTH(5, false),
        MULTI_FIRST(0, true),
        MULTI_THIRD(2, true);

        public final int position;
        public final boolean isMulti;

        private PositionalPattern(int position, boolean isMulti) {
            this.position = position;
            this.isMulti = isMulti;
        }

        @Override
        public boolean isTargetReference(@NotNull CMakeArgumentImplMixin argument) {
            if (argument == null) {
                PositionalPattern.$$$reportNull$$$0(0);
            }
            int argIndex = argument.getParentCommandArguments().getCMakeArgumentList().indexOf(argument);
            return this.isMulti ? argIndex >= this.position : argIndex == this.position;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/jetbrains/cmake/psi/util/CMakeTargetUtils$PositionalPattern", "isTargetReference"));
        }
    }

    static enum CustomPattern implements ITargetArgumentPattern
    {
        INSTALL_TARGETS("install_targets"),
        EXTERNALPROJECT_ADD_STEPTARGETS("ExternalProject_Add_StepTargets"),
        SET_TARGET_PROPERTIES("set_target_properties");

        @NotNull
        public final String name;

        private CustomPattern(String name) {
            if (name == null) {
                CustomPattern.$$$reportNull$$$0(0);
            }
            this.name = name;
        }

        @Override
        public boolean isTargetReference(@NotNull CMakeArgumentImplMixin argument) {
            if (argument == null) {
                CustomPattern.$$$reportNull$$$0(1);
            }
            if (this.equals(INSTALL_TARGETS)) {
                CMakeArgument prevArg = argument.getPreviousArgument();
                return prevArg != null && !prevArg.textMatches("RUNTIME_DIRECTORY");
            }
            if (this.equals(EXTERNALPROJECT_ADD_STEPTARGETS)) {
                return argument.getPreviousArgument() != null;
            }
            if (this.equals(SET_TARGET_PROPERTIES)) {
                for (CMakeArgument prevArg = argument; prevArg != null; prevArg = prevArg.getPreviousArgument()) {
                    if (!prevArg.textMatches("PROPERTIES")) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cmake/psi/util/CMakeTargetUtils$CustomPattern";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTargetReference";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum PrefixPattern implements ITargetArgumentPattern
    {
        SINGLE_TARGET("TARGET", false),
        SINGLE_ALIAS("ALIAS", false),
        SINGLE_TARGET_DIRECTORY("TARGET_DIRECTORY", false),
        SINGLE_REUSE_FROM("REUSE_FROM", false),
        SINGLE_GENERATE_NATIVE_HEADERS("GENERATE_NATIVE_HEADERS", false),
        SINGLE_AUT("AUT", false),
        MULTI_TARGETS("TARGETS", true),
        MULTI_IMPORTED_RUNTIME_ARTIFACTS("IMPORTED_RUNTIME_ARTIFACTS", true),
        MULTI_TARGET("TARGET", true),
        MULTI_TARGET_DIRECTORY("TARGET_DIRECTORY", true),
        MULTI_DEPENDS("DEPENDS", true),
        MULTI_STEP_TARGETS("STEP_TARGETS", true),
        MULTI_INDEPENDENT_STEP_TARGETS("INDEPENDENT_STEP_TARGETS", true),
        LINK_TO("LINK_TO", true),
        MULTI_NOTHING("", true);

        @NotNull
        public final String prefix;
        public final Boolean isMulti;

        private PrefixPattern(String prefix, Boolean isMulti) {
            if (prefix == null) {
                PrefixPattern.$$$reportNull$$$0(0);
            }
            this.prefix = prefix;
            this.isMulti = isMulti;
        }

        @Override
        public boolean isTargetReference(@NotNull CMakeArgumentImplMixin argument) {
            if (argument == null) {
                PrefixPattern.$$$reportNull$$$0(1);
            }
            if (this.isMulti.booleanValue()) {
                CMakeCommand cmd = argument.getParentCommandArguments().getCommand();
                if (cmd == null) {
                    return false;
                }
                String cmdName = StringUtil.toLowerCase((String)CMakePsiUtils.findCommandName(argument.getParentCommandArguments().getCommand()));
                if (cmdName == null) {
                    return false;
                }
                List<String> commandKeywords = PrefixPattern.getCommandKeywords(cmdName).stream().filter(x -> !x.equals(this.prefix)).toList();
                if (this.prefix.isEmpty()) {
                    return !commandKeywords.contains(argument.getText());
                }
                for (CMakeArgument prevArg = argument; prevArg != null; prevArg = prevArg.getPreviousArgument()) {
                    if (commandKeywords.contains(prevArg.getText())) {
                        return false;
                    }
                    if (!this.prefix.equals(prevArg.getText())) continue;
                    return true;
                }
                return false;
            }
            CMakeArgument prevArg = argument.getPreviousArgument();
            return prevArg != null && prevArg.textMatches(this.prefix);
        }

        @NotNull
        private static List<String> getCommandKeywords(@NotNull String cmdName) {
            if (cmdName == null) {
                PrefixPattern.$$$reportNull$$$0(2);
            }
            Map<String, List<String>> keywordsForCommands = CMakeDocsInfoProvider.Companion.getInstance().getKeywordsForBuiltInCommands();
            List<String> keywords = keywordsForCommands.get(cmdName);
            List list = ContainerUtil.notNullize(keywords);
            if (list == null) {
                PrefixPattern.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmdName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cmake/psi/util/CMakeTargetUtils$PrefixPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cmake/psi/util/CMakeTargetUtils$PrefixPattern";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandKeywords";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isTargetReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommandKeywords";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

