/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cmake.formatting.CMakeFormattingUtils;
import com.jetbrains.cmake.formatting.CMakeSpacingProcessor;
import com.jetbrains.cmake.psi.CMakeElementTypes;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeCodeBlock
extends AbstractBlock {
    @NotNull
    private static final TokenSet INDENT_SET = TokenSet.create((IElementType[])new IElementType[]{CMakeTokenTypes.C_MAKE_MACRO_COMMAND, CMakeTokenTypes.C_MAKE_FUNCTION_COMMAND, CMakeTokenTypes.C_MAKE_WHILE_COMMAND, CMakeTokenTypes.C_MAKE_FOREACH_COMMAND, CMakeTokenTypes.C_MAKE_IF_COMMAND, CMakeTokenTypes.C_MAKE_ELSE_COMMAND, CMakeTokenTypes.C_MAKE_ELSE_IF_COMMAND, CMakeTokenTypes.C_MAKE_BLOCK_COMMAND});
    @NotNull
    private static final TokenSet INDENT_RESET = TokenSet.create((IElementType[])new IElementType[]{CMakeTokenTypes.C_MAKE_END_MACRO_COMMAND, CMakeTokenTypes.C_MAKE_END_FUNCTION_COMMAND, CMakeTokenTypes.C_MAKE_END_WHILE_COMMAND, CMakeTokenTypes.C_MAKE_END_FOREACH_COMMAND, CMakeTokenTypes.C_MAKE_END_IF_COMMAND, CMakeTokenTypes.C_MAKE_END_BLOCK_COMMAND});
    @Nullable
    CMakeCodeBlock myParentBlock;
    @NotNull
    private final CMakeSpacingProcessor myGlobalCMakeSpacingProcessor;
    @NotNull
    private final CommonCodeStyleSettings mySettings;
    @Nullable
    private final Indent myIndent;

    public CMakeCodeBlock(@Nullable CMakeCodeBlock parentNode, @NotNull CMakeSpacingProcessor cMakeSpacingProcessor, @NotNull CommonCodeStyleSettings settings, @NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Wrap wrap, @Nullable Indent indent) {
        if (cMakeSpacingProcessor == null) {
            CMakeCodeBlock.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            CMakeCodeBlock.$$$reportNull$$$0(1);
        }
        if (node == null) {
            CMakeCodeBlock.$$$reportNull$$$0(2);
        }
        super(node, wrap, alignment);
        this.myParentBlock = parentNode;
        this.myGlobalCMakeSpacingProcessor = cMakeSpacingProcessor;
        this.mySettings = settings;
        this.myIndent = indent;
    }

    public CMakeCodeBlock(@NotNull PsiFile file, @NotNull CommonCodeStyleSettings settings) {
        if (file == null) {
            CMakeCodeBlock.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            CMakeCodeBlock.$$$reportNull$$$0(4);
        }
        this(null, new CMakeSpacingProcessor(settings), settings, (ASTNode)file.getNode(), null, null, Indent.getNoneIndent());
    }

    @NotNull
    protected List<Block> buildChildren() {
        if (this.isLeaf()) {
            List list = EMPTY;
            if (list == null) {
                CMakeCodeBlock.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (ASTNode childNode = this.myNode.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            if (childNode.getElementType() == CMakeTokenTypes.EOL || childNode instanceof PsiWhiteSpace || childNode.getText().trim().isEmpty()) continue;
            Indent indent = CMakeCodeBlock.calculateChildIndent(this, childNode);
            Alignment alignment = this.calculateChildAlignment(this, childNode, blocks);
            CMakeCodeBlock childBlock = new CMakeCodeBlock(this, this.myGlobalCMakeSpacingProcessor, this.mySettings, childNode, alignment, this.myWrap, indent);
            blocks.add((Block)childBlock);
        }
        ArrayList<Block> arrayList = blocks;
        if (arrayList == null) {
            CMakeCodeBlock.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public TextRange getTextRange() {
        boolean isEndOfFile;
        TextRange range = this.myNode.getTextRange();
        ASTNode lastChildNode = this.myNode.getLastChildNode();
        boolean myNodeEndsWithEol = lastChildNode != null && lastChildNode.getElementType() == CMakeTokenTypes.EOL;
        boolean bl = isEndOfFile = this.myNode.getTreeNext() == null;
        if (myNodeEndsWithEol && !isEndOfFile) {
            return new TextRange(range.getStartOffset(), range.getEndOffset() - lastChildNode.getTextLength());
        }
        TextRange textRange = range;
        if (textRange == null) {
            CMakeCodeBlock.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    private static boolean isCommandArgument(@NotNull ASTNode parentNode, @NotNull ASTNode node) {
        if (parentNode == null) {
            CMakeCodeBlock.$$$reportNull$$$0(8);
        }
        if (node == null) {
            CMakeCodeBlock.$$$reportNull$$$0(9);
        }
        return parentNode.getElementType() == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS && (node.getElementType() == CMakeTokenTypes.C_MAKE_ARGUMENT || node.getElementType() == CMakeTokenTypes.COMMENT || node.getElementType() == CMakeTokenTypes.QUOTE || node.getElementType() == CMakeTokenTypes.BRACKET_ARG_START || node.getElementType() == CMakeTokenTypes.BRACKET_ARG_END);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        int previousChildIndex;
        if (newChildIndex == 0) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        List subBlocks = this.getSubBlocks();
        CMakeCodeBlock previousChild = (CMakeCodeBlock)((Object)subBlocks.get(previousChildIndex));
        IElementType currentElementType = this.getNode().getElementType();
        Indent indent = INDENT_SET.contains(currentElementType) ? Indent.getNormalIndent() : (currentElementType == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS ? Indent.getContinuationIndent() : (currentElementType == CMakeTokenTypes.C_MAKE_BODY_BLOCK ? Indent.getNoneIndent() : this.getIndent()));
        for (previousChildIndex = newChildIndex - 1; previousChildIndex >= 0 && (previousChild.getNode().getElementType() == CMakeTokenTypes.COMMENT || previousChild.getNode().getElementType() == CMakeTokenTypes.SEMI); --previousChildIndex) {
            previousChild = (CMakeCodeBlock)((Object)subBlocks.get(previousChildIndex));
        }
        Alignment alignment = previousChild.getAlignment();
        if (currentElementType == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS || currentElementType == CMakeTokenTypes.RPAR || previousChild.getNode().getElementType() == CMakeTokenTypes.C_MAKE_COMMAND && currentElementType == CMakeElementTypes.CMAKE_FILE && previousChild.getNode().getLastChildNode().findChildByType(TokenType.ERROR_ELEMENT) != null) {
            indent = Indent.getContinuationIndent();
        }
        return new ChildAttributes(indent, alignment);
    }

    @NotNull
    private static Indent calculateChildIndent(@NotNull CMakeCodeBlock parentNode, @NotNull ASTNode node) {
        Indent indent;
        if (parentNode == null) {
            CMakeCodeBlock.$$$reportNull$$$0(10);
        }
        if (node == null) {
            CMakeCodeBlock.$$$reportNull$$$0(11);
        }
        ASTNode parentAstNode = parentNode.getNode();
        IElementType parentType = parentAstNode.getElementType();
        IElementType nodeType = node.getElementType();
        if (nodeType == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS) {
            Indent indent2 = Indent.getContinuationWithoutFirstIndent();
            if (indent2 == null) {
                CMakeCodeBlock.$$$reportNull$$$0(12);
            }
            return indent2;
        }
        if (CMakeCodeBlock.isCommandArgument(parentAstNode, node)) {
            Indent indent3 = Indent.getContinuationWithoutFirstIndent();
            if (indent3 == null) {
                CMakeCodeBlock.$$$reportNull$$$0(13);
            }
            return indent3;
        }
        if (node.getElementType() == CMakeTokenTypes.RPAR && (indent = CMakeFormattingUtils.rparShouldBeIndented(parentNode, node, Indent.getContinuationIndent(), Indent.getNoneIndent())) != null) {
            Indent indent4 = indent;
            if (indent4 == null) {
                CMakeCodeBlock.$$$reportNull$$$0(14);
            }
            return indent4;
        }
        if (INDENT_RESET.contains(nodeType)) {
            Indent indent5 = Indent.getNoneIndent();
            if (indent5 == null) {
                CMakeCodeBlock.$$$reportNull$$$0(15);
            }
            return indent5;
        }
        if (nodeType == CMakeTokenTypes.C_MAKE_BODY_BLOCK && INDENT_SET.contains(parentType)) {
            Indent indent6 = Indent.getNormalIndent();
            if (indent6 == null) {
                CMakeCodeBlock.$$$reportNull$$$0(16);
            }
            return indent6;
        }
        Indent indent7 = Indent.getNoneIndent();
        if (indent7 == null) {
            CMakeCodeBlock.$$$reportNull$$$0(17);
        }
        return indent7;
    }

    @Nullable
    private Alignment calculateChildAlignment(@NotNull CMakeCodeBlock parentNode, @NotNull ASTNode node, List<Block> previousBlocks) {
        if (parentNode == null) {
            CMakeCodeBlock.$$$reportNull$$$0(18);
        }
        if (node == null) {
            CMakeCodeBlock.$$$reportNull$$$0(19);
        }
        if (!this.mySettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS) {
            return null;
        }
        if ((node.getElementType() == CMakeTokenTypes.C_MAKE_ARGUMENT || node.getElementType() == CMakeTokenTypes.RPAR || node.getElementType() == CMakeTokenTypes.COMMENT) && parentNode.getNode().getElementType() == CMakeTokenTypes.C_MAKE_COMMAND_ARGUMENTS) {
            int previousArgumentBlockIndex = CMakeCodeBlock.findLastArgumentBlock(previousBlocks);
            if (previousArgumentBlockIndex >= 0) {
                Alignment alignment;
                CMakeCodeBlock previousArgumentBlock = (CMakeCodeBlock)previousBlocks.get(previousArgumentBlockIndex);
                if (node.getElementType() == CMakeTokenTypes.RPAR && (alignment = CMakeFormattingUtils.rparShouldBeIndented(parentNode, node, previousArgumentBlock.getAlignment(), Alignment.createAlignment())) != null) {
                    return alignment;
                }
                if (previousArgumentBlock.getAlignment() != null && node.getElementType() != CMakeTokenTypes.RPAR) {
                    return previousArgumentBlock.getAlignment();
                }
                return Alignment.createAlignment();
            }
            if (node.getElementType() == CMakeTokenTypes.C_MAKE_ARGUMENT || node.getElementType() == CMakeTokenTypes.COMMENT) {
                for (ASTNode possibleLeftParenthesis = node; possibleLeftParenthesis != null && possibleLeftParenthesis.getElementType() != CMakeTokenTypes.LPAR; possibleLeftParenthesis = possibleLeftParenthesis.getTreePrev()) {
                }
                return Alignment.createAlignment();
            }
        }
        return null;
    }

    private static int findLastArgumentBlock(List<Block> blocks) {
        for (int currentBlockIndex = blocks.size() - 1; currentBlockIndex >= 0; --currentBlockIndex) {
            CMakeCodeBlock block = (CMakeCodeBlock)blocks.get(currentBlockIndex);
            if (block.getNode().getElementType() != CMakeTokenTypes.C_MAKE_ARGUMENT) continue;
            return currentBlockIndex;
        }
        return -1;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            CMakeCodeBlock.$$$reportNull$$$0(20);
        }
        return this.myGlobalCMakeSpacingProcessor.getSpacing(this, child1, child2);
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    public boolean isLeaf() {
        return this.myNode instanceof LeafElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cMakeSpacingProcessor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/formatting/CMakeCodeBlock";
                break;
            }
            case 8: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/formatting/CMakeCodeBlock";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateChildIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCommandArgument";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calculateChildIndent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calculateChildAlignment";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

