/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.settings;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import com.jetbrains.clangFormat.ClangFormatUtils;
import com.jetbrains.clangFormat.fus.ClangFormatUsageCollector;
import com.jetbrains.clangFormat.messages.ClangFormatBundle;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangFormatProcessor
implements ExternalFormatProcessor {
    public boolean activeForFile(@NotNull PsiFile source) {
        ClangFormatSettings clangFormatSettings;
        if (source == null) {
            ClangFormatProcessor.$$$reportNull$$$0(0);
        }
        if ((clangFormatSettings = (ClangFormatSettings)CodeStyle.getSettings((PsiFile)source).getCustomSettingsIfCreated(ClangFormatSettings.class)) == null || !clangFormatSettings.ENABLED) {
            return false;
        }
        return ClangFormatUtils.findActiveClangFormatProvider(source) != null;
    }

    @Nullable
    public TextRange format(@NotNull PsiFile source, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly, boolean keepLineBreaks, boolean enableBulkUpdate, int cursorOffset) {
        ClangFormatChangeSettingsProvider provider;
        if (source == null) {
            ClangFormatProcessor.$$$reportNull$$$0(1);
        }
        if (range == null) {
            ClangFormatProcessor.$$$reportNull$$$0(2);
        }
        if ((provider = ClangFormatUtils.findActiveClangFormatProvider(source)) == null) {
            return null;
        }
        ClangFormatFileUtils.saveAllClangFormatDocuments();
        ClangFormatUsageCollector.clangFormatActionWithCF.log(source.getProject(), (Object)true);
        return (TextRange)OCLongActionUtil.execWithTimeoutProgressInDispatchOrEmptyProgressInBg((String)ClangFormatBundle.message("progressbar.long.clang.format", new Object[0]), (Project)source.getProject(), () -> provider.format(source, range, ClangFormatUtils.getContent(source), canChangeWhiteSpacesOnly, keepLineBreaks, enableBulkUpdate, cursorOffset));
    }

    @Nullable
    public String indent(@NotNull PsiFile source, int lineStartOffset) {
        ClangFormatChangeSettingsProvider provider;
        if (source == null) {
            ClangFormatProcessor.$$$reportNull$$$0(3);
        }
        if ((provider = ClangFormatUtils.findActiveClangFormatProvider(source)) == null) {
            return null;
        }
        ClangFormatFileUtils.saveAllClangFormatDocuments();
        return (String)OCLongActionUtil.execWithTimeoutProgressInDispatchOrEmptyProgressInBg((String)ClangFormatBundle.message("progressbar.long.clang.indent", new Object[0]), (Project)source.getProject(), () -> provider.indent(source, lineStartOffset, ClangFormatUtils.getContent(source)));
    }

    public void createConfiguration(@NotNull Project project) {
        if (project == null) {
            ClangFormatProcessor.$$$reportNull$$$0(4);
        }
        ClangFormatUtils.exportSettingsToClangFormatFileAndUpdateSettingsFromIt(project);
    }

    @NotNull
    public String getId() {
        return "ClangFormat";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/clangFormat/settings/ClangFormatProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "activeForFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "indent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

