/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.settings;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.DetectableIndentOptionsProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.clangFormat.ClangFormatUtils;
import com.jetbrains.clangFormat.components.ClangFormatModificationTracker;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import com.jetbrains.clangFormat.settings.ClangFormatStatusUIContributor;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangFormatCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile source) {
        ClangFormatChangeSettingsProvider formatProvider;
        if (settings == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(0);
        }
        if (source == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(1);
        }
        if ((formatProvider = ClangFormatUtils.findApplicableClangFormatProvider(source)) != null) {
            settings.addDependency((ModificationTracker)ClangFormatModificationTracker.getInstance());
            String clangFormatConfigurationContentAsYaml = ClangFormatUtils.getContent(source);
            return ClangFormatUtils.applySettings(formatProvider, settings, source, clangFormatConfigurationContentAsYaml, source.getName());
        }
        return false;
    }

    public boolean modifySettingsAndUiCustomization(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile file) {
        if (settings == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(3);
        }
        ClangFormatSettings cf = (ClangFormatSettings)settings.getCustomSettings(ClangFormatSettings.class);
        if (cf.ENABLED && ClangFormatUtils.findActiveClangFormatProvider(file) != null) {
            settings.setModifier((CodeStyleSettingsModifier)this);
        }
        return this.modifySettings(settings, file);
    }

    @Contract(value="_ -> new")
    @NotNull
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        if (transientSettings == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(4);
        }
        return new ClangFormatStatusUIContributor(transientSettings);
    }

    public String getName() {
        return "ClangFormat";
    }

    public boolean mayOverrideSettingsOf(@NotNull Project project) {
        ClangFormatSettings clangFormatSettings;
        if (project == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(5);
        }
        return (clangFormatSettings = (ClangFormatSettings)CodeStyle.getSettings((Project)project).getCustomSettingsIfCreated(ClangFormatSettings.class)) != null && clangFormatSettings.ENABLED;
    }

    @Nullable
    public Consumer<CodeStyleSettings> getDisablingFunction(@NotNull Project project) {
        if (project == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(6);
        }
        return ClangFormatChangeSettingsProvider.getCurrentDisablingFunction(project);
    }

    @Nullable
    public AnAction getActivatingAction(@Nullable CodeStyleStatusBarUIContributor activeUiContributor, @NotNull PsiFile file) {
        if (file == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(7);
        }
        if (activeUiContributor == null || DetectableIndentOptionsProvider.isIndentDetectionContributor((CodeStyleStatusBarUIContributor)activeUiContributor)) {
            return ClangFormatChangeSettingsProvider.getCurrentActivatingAction(file);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transientSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/clangFormat/settings/ClangFormatCodeStyleSettingsModifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifySettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "modifySettingsAndUiCustomization";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatusBarUiContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "mayOverrideSettingsOf";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisablingFunction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getActivatingAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

