/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.instantapp.run.InstantAppRunException;
import com.android.instantapp.run.InstantAppSideLoader;
import com.android.instantapp.run.RunListener;
import com.android.instantapp.utils.DeviceUtils;
import com.android.instantapp.utils.LogcatService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class PreOSideLoader
implements InstantAppSideLoader.Installer {
    private static final String TMP_REMOTE_DIR = "/data/local/tmp/aia/";
    private final File myZipFile;
    private final RunListener myListener;
    private long myShellTimeout = 500L;
    private long myLogcatTimeout = 5L;

    PreOSideLoader(File zip, RunListener listener) {
        this.myZipFile = zip;
        this.myListener = listener;
    }

    void increaseShellTimeout() {
        this.myShellTimeout *= 2L;
    }

    void increaseLogcatTimeout() {
        this.myLogcatTimeout *= 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(IDevice device) throws InstantAppRunException {
        this.myListener.logMessage("Checking logged in Google account.", null);
        this.checkLoggedInGoogleAccount(device);
        String osBuildType = DeviceUtils.getOsBuildType(device);
        if (osBuildType != null && osBuildType.compareTo("test-keys") == 0) {
            this.executeShellCommand(device, "am startservice -a com.google.android.gms.instantapps.ACTION_UPDATE_DOMAIN_FILTER");
        }
        if (osBuildType != null && osBuildType.compareTo("release-keys") != 0) {
            this.executeShellCommand(device, "su shell mkdir -p /data/local/tmp/aia/");
        }
        String remotePath = TMP_REMOTE_DIR + this.myZipFile.getName();
        try {
            this.myListener.logMessage("Pushing zip file \"" + this.myZipFile.getAbsolutePath() + "\" to device in location \"" + remotePath + "\"", null);
            device.pushFile(this.myZipFile.getAbsolutePath(), remotePath);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException | IOException e) {
            throw new InstantAppRunException(InstantAppRunException.ErrorType.ADB_FAILURE, "Couldn't push file \"" + this.myZipFile.getAbsolutePath() + "\" to device in location \"" + remotePath + "\".");
        }
        try {
            this.readIapk(device, remotePath, UUID.randomUUID());
        }
        finally {
            this.executeShellCommand(device, "rm -f " + remotePath);
        }
        this.executeShellCommand(device, "am force-stop com.google.android.instantapps.supervisor");
    }

    @VisibleForTesting
    void readIapk(IDevice device, String remotePath, UUID installToken) throws InstantAppRunException {
        block7: {
            String installTokenIdentifier = "token=" + installToken;
            this.myListener.printMessage("Side loading instant app.");
            this.myListener.logMessage("Side loading instant app. Install token: " + installTokenIdentifier, null);
            CountDownLatch latch = new CountDownLatch(1);
            AtomicBoolean succeeded = new AtomicBoolean(false);
            AtomicReference<Object> error = new AtomicReference<Object>(null);
            LogcatService.Listener listener = line -> {
                LogCatHeader header = line.getHeader();
                if (header.getTag().compareTo("IapkLoadService") == 0) {
                    String message;
                    if (header.getLogLevel() == Log.LogLevel.ERROR) {
                        String message2 = line.getMessage();
                        if (message2.contains(installTokenIdentifier)) {
                            error.set((message2.replace(installTokenIdentifier, "") + " - Please see the Logcat for more information."));
                            latch.countDown();
                        }
                    } else if (header.getLogLevel() == Log.LogLevel.INFO && (message = line.getMessage()).contains(installTokenIdentifier) && message.contains("LOAD_SUCCESS")) {
                        succeeded.set(true);
                        latch.countDown();
                    }
                }
            };
            LogcatService logcatService = new LogcatService(device);
            logcatService.startListening(listener);
            this.executeShellCommand(device, "am startservice -a \"com.google.android.instantapps.devman.iapk.LOAD\" --es \"com.google.android.instantapps.devman.iapk.IAPK_PATH\" \"" + remotePath + "\" --es \"com.google.android.instantapps.devman.iapk.INSTALL_TOKEN\" \"" + installToken + "\" --ez \"com.google.android.instantapps.devman.iapk.FORCE\" \"false\" -n com.google.android.instantapps.devman/.iapk.IapkLoadService");
            try {
                if (latch.await(this.myLogcatTimeout, TimeUnit.SECONDS)) {
                    if (!succeeded.get()) {
                        throw new InstantAppRunException(InstantAppRunException.ErrorType.READ_IAPK_FAILED, error.get());
                    }
                    break block7;
                }
                throw new InstantAppRunException(InstantAppRunException.ErrorType.READ_IAPK_TIMEOUT);
            }
            catch (InterruptedException e) {
                throw new InstantAppRunException(InstantAppRunException.ErrorType.READ_IAPK_FAILED, (Throwable)e);
            }
            finally {
                logcatService.stopListening();
            }
        }
    }

    private void checkLoggedInGoogleAccount(IDevice device) throws InstantAppRunException {
        String output = this.executeShellCommand(device, "dumpsys account");
        Iterable lines = Splitter.on((String)"\n").split((CharSequence)output);
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("Account {") || !line.contains("type=com.google")) continue;
            return;
        }
        throw new InstantAppRunException(InstantAppRunException.ErrorType.NO_GOOGLE_ACCOUNT);
    }

    private String executeShellCommand(IDevice device, String command) throws InstantAppRunException {
        return InstantAppSideLoader.executeShellCommand(device, command, false, this.myShellTimeout);
    }
}

