/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.provision;

public class ProvisionException
extends Exception {
    private final ErrorType myErrorType;

    ProvisionException(ErrorType errorType) {
        super(ProvisionException.createMessageForError(errorType));
        this.myErrorType = errorType;
    }

    ProvisionException(ErrorType errorType, Throwable cause) {
        super(ProvisionException.createMessageForError(errorType) + " Caused by: " + cause.getMessage(), cause);
        this.myErrorType = errorType;
    }

    ProvisionException(ErrorType errorType, String message) {
        super(ProvisionException.createMessageForError(errorType) + " " + message);
        this.myErrorType = errorType;
    }

    ProvisionException(ErrorType errorType, String message, Throwable cause) {
        super(ProvisionException.createMessageForError(errorType) + " " + message + " Caused by: " + cause.getMessage(), cause);
        this.myErrorType = errorType;
    }

    private static String createMessageForError(ErrorType errorType) {
        switch (errorType.ordinal()) {
            case 0: {
                return "The device architecture is not supported for Instant Apps.";
            }
            case 1: {
                return "The device used is not enabled for Instant Apps deployment.";
            }
            case 2: {
                return "There is no Google account on the target device. Please log in to a Google account and try again.";
            }
            case 3: {
                return "Shell adb command has timed out.";
            }
            case 4: {
                return "ADB has failed.";
            }
            case 5: {
                return "The provided SDK file is not valid.";
            }
            case 6: {
                return "Installing APK failed.";
            }
            case 7: {
                return "Uninstalling APK failed.";
            }
            case 8: {
                return "Cancelled by the user.";
            }
            case 9: {
                return "Error while provisioning device.";
            }
        }
        return null;
    }

    public ErrorType getErrorType() {
        return this.myErrorType;
    }

    public static enum ErrorType {
        ARCH_NOT_SUPPORTED,
        DEVICE_NOT_SUPPORTED,
        NO_GOOGLE_ACCOUNT,
        SHELL_TIMEOUT,
        ADB_FAILURE,
        INVALID_SDK,
        INSTALL_FAILED,
        UNINSTALL_FAILED,
        CANCELLED,
        UNKNOWN;

    }
}

