/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.automotiveMessagingService.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"messageReplyReceiverJava", "", "packageName", "replyReceiverName", "serviceName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class MessageReplyReceiverJavaKt {
    @NotNull
    public static final String messageReplyReceiverJava(@NotNull String packageName, @NotNull String replyReceiverName, @NotNull String serviceName, boolean useAndroidX) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)replyReceiverName, (String)"replyReceiverName");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        return "\npackage " + packageName + ";\n\nimport android.content.BroadcastReceiver;\nimport android.content.Context;\nimport android.content.Intent;\nimport android.os.Bundle;\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.app.RemoteInput", useAndroidX) + ";\nimport android.util.Log;\n\n/**\n * A receiver that gets called when a reply is sent to a given conversationId\n */\npublic class " + replyReceiverName + " extends BroadcastReceiver {\n\n    private static final String TAG = " + replyReceiverName + ".class.getSimpleName();\n\n    @Override\n    public void onReceive(Context context, Intent intent) {\n        if (" + serviceName + ".REPLY_ACTION.equals(intent.getAction())) {\n            int conversationId = intent.getIntExtra(" + serviceName + ".CONVERSATION_ID, -1);\n            CharSequence reply = getMessageText(intent);\n            Log.d(TAG, \"Got reply (\" + reply + \") for ConversationId \" + conversationId);\n        }\n    }\n\n    /**\n     * Get the message text from the intent.\n     * Note that you should call {@code RemoteInput#getResultsFromIntent(intent)} to process\n     * the RemoteInput.\n     */\n    private CharSequence getMessageText(Intent intent) {\n        Bundle remoteInput = RemoteInput.getResultsFromIntent(intent);\n        if (remoteInput != null) {\n            return remoteInput.getCharSequence(" + serviceName + ".EXTRA_VOICE_REPLY);\n        }\n        return null;\n    }\n}\n";
    }
}

