/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.responsiveActivity.src.ui.transform;

import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.impl.activities.common.ViewBindingUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"transformFragmentJava", "", "packageName", "applicationPackage", "fragmentClassName", "navFragmentPrefix", "navViewModelClass", "isViewBindingSupported", "", "intellij.android.wizardTemplate.impl"})
public final class TransformFragmentJavaKt {
    @NotNull
    public static final String transformFragmentJava(@NotNull String packageName, @Nullable String applicationPackage, @NotNull String fragmentClassName, @NotNull String navFragmentPrefix, @NotNull String navViewModelClass, boolean isViewBindingSupported) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fragmentClassName, (String)"fragmentClassName");
        Intrinsics.checkNotNullParameter((Object)navFragmentPrefix, (String)"navFragmentPrefix");
        Intrinsics.checkNotNullParameter((Object)navViewModelClass, (String)"navViewModelClass");
        String layoutName = "fragment_transform";
        String bindingName = ViewBindingUtilsKt.layoutToViewBindingClass(layoutName);
        return "\npackage " + packageName + ".ui." + navFragmentPrefix + ";\n\nimport android.os.Bundle;\nimport android.view.LayoutInflater;\nimport android.view.View;\nimport android.view.ViewGroup;\nimport android.widget.ImageView;\nimport android.widget.TextView;\n\nimport androidx.annotation.NonNull;\nimport androidx.core.content.res.ResourcesCompat;\nimport androidx.fragment.app.Fragment;\nimport androidx.lifecycle.ViewModelProvider;\nimport androidx.recyclerview.widget.DiffUtil;\nimport androidx.recyclerview.widget.ListAdapter;\nimport androidx.recyclerview.widget.RecyclerView;\n\nimport " + packageName + ".R;\n" + ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, applicationPackage, layoutName, Language.Java) + "\n" + ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, applicationPackage, "item_transform", Language.Java) + "\n\nimport java.util.Arrays;\nimport java.util.List;\n\n/**\n * Fragment that demonstrates a responsive layout pattern where the format of the content\n * transforms depending on the size of the screen. Specifically this Fragment shows items in\n * the [RecyclerView] using LinearLayoutManager in a small screen\n * and shows items using GridLayoutManager in a large screen.\n */\npublic class " + fragmentClassName + " extends Fragment {\n\n    private " + bindingName + " binding;\n\n    public View onCreateView(@NonNull LayoutInflater inflater,\n                             ViewGroup container, Bundle savedInstanceState) {\n        " + navViewModelClass + " " + navFragmentPrefix + "ViewModel =\n                new ViewModelProvider(this).get(" + navViewModelClass + ".class);\n\n        binding = " + bindingName + ".inflate(inflater, container, false);\n        View root = binding.getRoot();\n\n        RecyclerView recyclerView = binding.recyclerviewTransform;\n        ListAdapter<String, TransformViewHolder> adapter = new TransformAdapter();\n        recyclerView.setAdapter(adapter);\n        transformViewModel.getTexts().observe(getViewLifecycleOwner(), adapter::submitList);\n        return root;\n    }\n\n    @Override\n    public void onDestroyView() {\n        super.onDestroyView();\n        binding = null;\n    }\n\n    private static class TransformAdapter extends ListAdapter<String, TransformViewHolder> {\n\n        private final List<Integer> drawables = Arrays.asList(\n                R.drawable.avatar_1,\n                R.drawable.avatar_2,\n                R.drawable.avatar_3,\n                R.drawable.avatar_4,\n                R.drawable.avatar_5,\n                R.drawable.avatar_6,\n                R.drawable.avatar_7,\n                R.drawable.avatar_8,\n                R.drawable.avatar_9,\n                R.drawable.avatar_10,\n                R.drawable.avatar_11,\n                R.drawable.avatar_12,\n                R.drawable.avatar_13,\n                R.drawable.avatar_14,\n                R.drawable.avatar_15,\n                R.drawable.avatar_16);\n\n        protected TransformAdapter() {\n            super(new DiffUtil.ItemCallback<String>() {\n                @Override\n                public boolean areItemsTheSame(@NonNull String oldItem, @NonNull String newItem) {\n                    return oldItem.equals(newItem);\n                }\n\n                @Override\n                public boolean areContentsTheSame(@NonNull String oldItem, @NonNull String newItem) {\n                    return oldItem.equals(newItem);\n                }\n            });\n        }\n\n        @NonNull\n        @Override\n        public TransformViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {\n            ItemTransformBinding binding = ItemTransformBinding.inflate(LayoutInflater.from(parent.getContext()));\n            return new TransformViewHolder(binding);\n        }\n\n        @Override\n        public void onBindViewHolder(@NonNull TransformViewHolder holder, int position) {\n            holder.textView.setText(getItem(position));\n            holder.imageView.setImageDrawable(\n                    ResourcesCompat.getDrawable(holder.imageView.getResources(),\n                    drawables.get(position),\n                            null));\n        }\n    }\n\n    private static class TransformViewHolder extends RecyclerView.ViewHolder {\n\n        private final ImageView imageView;\n        private final TextView textView;\n\n        public TransformViewHolder(ItemTransformBinding binding) {\n            super(binding.getRoot());\n            imageView = binding.imageViewItemTransform;\n            textView = binding.textViewItemTransform;\n        }\n    }\n}\n";
    }
}

