/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.composeNavigationUiActivityMaterial3.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\b"}, d2={"mainActivityKt", "", "activityClass", "defaultPreview", "greeting", "packageName", "themeName", "appComposableName", "intellij.android.wizardTemplate.impl"})
public final class MainActivityKtKt {
    @NotNull
    public static final String mainActivityKt(@NotNull String activityClass, @NotNull String defaultPreview, @NotNull String greeting, @NotNull String packageName, @NotNull String themeName, @NotNull String appComposableName) {
        Intrinsics.checkNotNullParameter((Object)activityClass, (String)"activityClass");
        Intrinsics.checkNotNullParameter((Object)defaultPreview, (String)"defaultPreview");
        Intrinsics.checkNotNullParameter((Object)greeting, (String)"greeting");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)themeName, (String)"themeName");
        Intrinsics.checkNotNullParameter((Object)appComposableName, (String)"appComposableName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport android.os.Bundle\nimport androidx.activity.ComponentActivity\nimport androidx.activity.compose.setContent\nimport androidx.activity.enableEdgeToEdge\nimport androidx.compose.foundation.layout.fillMaxSize\nimport androidx.compose.foundation.layout.padding\nimport androidx.compose.material.icons.Icons\nimport androidx.compose.material.icons.filled.AccountBox\nimport androidx.compose.material.icons.filled.Favorite\nimport androidx.compose.material.icons.filled.Home\nimport androidx.compose.material3.Icon\nimport androidx.compose.material3.Scaffold\nimport androidx.compose.material3.Text\nimport androidx.compose.material3.adaptive.navigationsuite.NavigationSuiteScaffold\nimport androidx.compose.runtime.Composable\nimport androidx.compose.runtime.getValue\nimport androidx.compose.runtime.mutableStateOf\nimport androidx.compose.runtime.saveable.rememberSaveable\nimport androidx.compose.runtime.setValue\nimport androidx.compose.ui.Modifier\nimport androidx.compose.ui.graphics.vector.ImageVector\nimport androidx.compose.ui.tooling.preview.Preview\nimport androidx.compose.ui.tooling.preview.PreviewScreenSizes\nimport " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".ui.theme." + themeName + "\n\nclass " + activityClass + " : ComponentActivity() {\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n        enableEdgeToEdge()\n        setContent {\n            " + themeName + " {\n                " + appComposableName + "()\n            }\n        }\n    }\n}\n\n@PreviewScreenSizes\n@Composable\nfun " + appComposableName + "() {\n    var currentDestination by rememberSaveable { mutableStateOf(AppDestinations.HOME) }\n\n    NavigationSuiteScaffold(\n        navigationSuiteItems = {\n            AppDestinations.entries.forEach {\n                item(\n                    icon = {\n                        Icon(\n                            it.icon,\n                            contentDescription = it.label\n                        )\n                    },\n                    label = { Text(it.label) },\n                    selected = it == currentDestination,\n                    onClick = { currentDestination = it }\n                )\n            }\n        }\n    ) {\n        Scaffold(modifier = Modifier.fillMaxSize()) { innerPadding ->\n            " + greeting + "(\n                name = \"Android\",\n                modifier = Modifier.padding(innerPadding)\n            )\n        }\n    }\n}\n\nenum class AppDestinations(\n    val label: String,\n    val icon: ImageVector,\n) {\n    HOME(\"Home\", Icons.Default.Home),\n    FAVORITES(\"Favorites\", Icons.Default.Favorite),\n    PROFILE(\"Profile\", Icons.Default.AccountBox),\n}\n\n@Composable\nfun " + greeting + "(name: String, modifier: Modifier = Modifier) {\n    Text(\n        text = \"Hello $name!\",\n        modifier = modifier\n    )\n}\n\n@Preview(showBackground = true)\n@Composable\nfun " + defaultPreview + "() {\n    " + themeName + " {\n        " + greeting + "(\"Android\")\n    }\n}\n";
    }
}

