/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeSupportKt;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelModule;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeProject;", "Lcom/android/tools/lint/detector/api/Project;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "referenceDir", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;)V", "initialize", "", "getIdeaProject", "Lcom/intellij/openapi/project/Project;", "Companion", "LintModuleProject", "intellij.lint"})
public class LintIdeProject
extends Project {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected LintIdeProject(@NotNull LintClient client, @NotNull File dir, @NotNull File referenceDir) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
        super(client, dir, referenceDir);
    }

    protected void initialize() {
    }

    @Nullable
    public com.intellij.openapi.project.Project getIdeaProject() {
        if (this.client instanceof LintIdeClient) {
            LintClient lintClient = this.client;
            Intrinsics.checkNotNull((Object)lintClient, (String)"null cannot be cast to non-null type com.android.tools.idea.lint.common.LintIdeClient");
            return ((LintIdeClient)lintClient).myProject;
        }
        return super.getIdeaProject();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00052\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ,\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\rJ^\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\r2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0002J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\r2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u0006J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0007\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\r\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/lint/common/LintIdeProject$Companion;", "", "<init>", "()V", "create", "", "Lcom/android/tools/lint/detector/api/Project;", "client", "Lcom/android/tools/idea/lint/common/LintIdeClient;", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "modules", "", "Lcom/intellij/openapi/module/Module;", "(Lcom/android/tools/idea/lint/common/LintIdeClient;Ljava/util/List;[Lcom/intellij/openapi/module/Module;)Ljava/util/List;", "createForSingleFile", "Lcom/intellij/openapi/util/Pair;", "file", "module", "addProjects", "", "Lcom/android/tools/lint/client/api/LintClient;", "moduleMap", "", "projectMap", "projects", "", "processFileFilter", "", "project", "createModuleProject", "Lcom/android/tools/idea/lint/common/LintIdeProject$LintModuleProject;", "getLintProjectDirectory", "Ljava/io/File;", "intellij.lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Project> create(@NotNull LintIdeClient client, @Nullable List<? extends VirtualFile> files, Module ... modules) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
            ArrayList projects = new ArrayList();
            HashMap projectMap = Maps.newHashMap();
            HashMap moduleMap = Maps.newHashMap();
            Collection collection = files;
            if (!(collection == null || collection.isEmpty())) {
                for (Module module : modules) {
                    LintClient lintClient = client;
                    Intrinsics.checkNotNull((Object)moduleMap);
                    Map map = moduleMap;
                    Intrinsics.checkNotNull((Object)projectMap);
                    this.addProjects(lintClient, module, files, map, projectMap, projects);
                }
            } else {
                for (Module module : modules) {
                    LintClient lintClient = client;
                    Intrinsics.checkNotNull((Object)moduleMap);
                    Map map = moduleMap;
                    Intrinsics.checkNotNull((Object)projectMap);
                    this.addProjects(lintClient, module, null, map, projectMap, projects);
                }
            }
            client.setModuleMap(projectMap);
            if (projects.size() > 1) {
                HashSet roots = new HashSet(projects);
                Iterator iterator = projects.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Project project = (Project)e;
                    List list = project.getAllLibraries();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllLibraries(...)");
                    roots.removeAll(CollectionsKt.toSet((Iterable)list));
                }
                return CollectionsKt.toList((Iterable)roots);
            }
            return projects;
        }

        @NotNull
        public final Pair<Project, Project> createForSingleFile(@NotNull LintIdeClient client, @Nullable VirtualFile file, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            LintModuleProject project = this.createModuleProject(client, module);
            Object main = null;
            HashMap projectMap = Maps.newHashMap();
            if (project != null) {
                project.setDirectLibraries(CollectionsKt.emptyList());
                if (file != null) {
                    project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                }
                Intrinsics.checkNotNull((Object)projectMap);
                ((Map)projectMap).put(project, module);
                project.isGradleRootHolder = true;
            }
            client.setModuleMap(projectMap);
            Pair pair = Pair.create((Object)((Object)project), main);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
            return pair;
        }

        private final void addProjects(LintClient client, Module module, List<? extends VirtualFile> files, Map<Module, Project> moduleMap, Map<Project, Module> projectMap, List<Project> projects) {
            Module depModule;
            if (moduleMap.containsKey(module)) {
                return;
            }
            LintModuleProject lintModuleProject = this.createModuleProject(client, module);
            if (lintModuleProject == null) {
                return;
            }
            LintModuleProject project = lintModuleProject;
            project.setIdeaProject(module.getProject());
            project.isGradleRootHolder = new File(project.dir, "settings.gradle").exists() || new File(project.dir, "settings.gradle.kts").exists() || new File(project.dir, "settings.gradle.dcl").exists();
            projects.add(project);
            moduleMap.put(module, project);
            projectMap.put(project, module);
            if (this.processFileFilter(module, files, project)) {
                return;
            }
            List dependencies = new ArrayList();
            OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"getOrderEntries(...)");
            OrderEntry[] entries = orderEntryArray;
            ArrayList<Module> deps = new ArrayList<Module>();
            int i = entries.length;
            while (--i >= 0) {
                OrderEntry orderEntry = entries[i];
                if (!(orderEntry instanceof ModuleOrderEntry) || ((ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                deps.add(depModule);
            }
            Iterator iterator = deps.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                depModule = (Module)e;
                Project p = moduleMap.get(depModule);
                if (p != null) {
                    dependencies.add(p);
                    continue;
                }
                this.addProjects(client, depModule, files, moduleMap, projectMap, dependencies);
            }
            project.setDirectLibraries(dependencies);
        }

        public final boolean processFileFilter(@NotNull Module module, @Nullable List<? extends VirtualFile> files, @NotNull Project project) {
            Boolean allMatched;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Collection collection = files;
            if (!(collection == null || collection.isEmpty()) && (allMatched = (Boolean)ApplicationManager.getApplication().runReadAction(() -> Companion.processFileFilter$lambda$0(files, module, project))).booleanValue()) {
                project.setDirectLibraries(CollectionsKt.emptyList());
                return true;
            }
            return false;
        }

        private final LintModuleProject createModuleProject(LintClient client, Module module) {
            File file = this.getLintProjectDirectory(module);
            if (file == null) {
                return null;
            }
            File dir = file;
            LintModuleProject project = new LintModuleProject(client, dir, dir, module);
            project.setIdeaProject(module.getProject());
            client.registerProject(dir, (Project)project);
            return project;
        }

        @Nullable
        public final File getLintProjectDirectory(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            VirtualFile[] contentRoots = virtualFileArray;
            return contentRoots.length == 1 ? VfsUtilCore.virtualToIoFile((VirtualFile)contentRoots[0]) : LintIdeSupportKt.getModuleDir(module);
        }

        private static final Boolean processFileFilter$lambda$0(List $files, Module $module, Project $project) {
            boolean matched = true;
            for (VirtualFile file : $files) {
                if ($module.getModuleContentScope().accept(file)) {
                    $project.addFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                    continue;
                }
                matched = false;
            }
            return matched;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeProject$LintModuleProject;", "Lcom/android/tools/idea/lint/common/LintIdeProject;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "referenceDir", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;Lcom/intellij/openapi/module/Module;)V", "isAndroidProject", "", "includeTests", "getJavaSourceFolders", "", "getGeneratedSourceFolders", "getTestSourceFolders", "getJavaClassFolders", "getJavaLibraries", "includeProvided", "intellij.lint"})
    public static class LintModuleProject
    extends LintIdeProject {
        @NotNull
        private final Module module;

        public LintModuleProject(@NotNull LintClient client, @NotNull File dir, @NotNull File referenceDir, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(client, dir, referenceDir);
            this.module = module;
        }

        public boolean isAndroidProject() {
            return false;
        }

        private final boolean includeTests() {
            LintModelModule model = this.getBuildModule();
            if (model != null) {
                return model.getLintOptions().getCheckTestSources();
            }
            return false;
        }

        @NotNull
        public List<File> getJavaSourceFolders() {
            if (this.javaSourceFolders == null) {
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)this.module).getSourceRoots(false);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
                VirtualFile[] sourceRoots = virtualFileArray;
                ArrayList<File> dirs = new ArrayList<File>(sourceRoots.length);
                com.intellij.openapi.project.Project project = this.module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                com.intellij.openapi.project.Project project2 = project;
                for (VirtualFile root : sourceRoots) {
                    Intrinsics.checkNotNull((Object)root);
                    if (GeneratedSourcesFilter.Companion.isGeneratedSourceByAnyFilter(root, project2)) continue;
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
                this.javaSourceFolders = dirs;
            }
            List list = this.javaSourceFolders;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"javaSourceFolders");
            return list;
        }

        @NotNull
        public List<File> getGeneratedSourceFolders() {
            if (this.generatedSourceFolders == null) {
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)this.module).getSourceRoots(this.includeTests());
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
                VirtualFile[] sourceRoots = virtualFileArray;
                ArrayList<File> dirs = new ArrayList<File>(sourceRoots.length);
                com.intellij.openapi.project.Project project = this.module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                com.intellij.openapi.project.Project project2 = project;
                for (VirtualFile root : sourceRoots) {
                    Intrinsics.checkNotNull((Object)root);
                    if (!GeneratedSourcesFilter.Companion.isGeneratedSourceByAnyFilter(root, project2)) continue;
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
                this.generatedSourceFolders = dirs;
            }
            List list = this.generatedSourceFolders;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"generatedSourceFolders");
            return list;
        }

        @NotNull
        public List<File> getTestSourceFolders() {
            if (this.testSourceFolders == null) {
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)this.module);
                VirtualFile[] virtualFileArray = manager.getSourceRoots(false);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
                VirtualFile[] sourceRoots = virtualFileArray;
                VirtualFile[] virtualFileArray2 = manager.getSourceRoots(true);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getSourceRoots(...)");
                VirtualFile[] sourceAndTestRoots = virtualFileArray2;
                com.intellij.openapi.project.Project project = this.module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                com.intellij.openapi.project.Project project2 = project;
                ArrayList<File> dirs = new ArrayList<File>(sourceAndTestRoots.length);
                for (VirtualFile root : sourceAndTestRoots) {
                    if (ArrayUtil.contains((Object)root, (Object[])Arrays.copyOf(sourceRoots, sourceRoots.length))) continue;
                    Intrinsics.checkNotNull((Object)root);
                    if (GeneratedSourcesFilter.Companion.isGeneratedSourceByAnyFilter(root, project2)) continue;
                    dirs.add(VfsUtilCore.virtualToIoFile((VirtualFile)root));
                }
                this.testSourceFolders = dirs;
            }
            List list = this.testSourceFolders;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"testSourceFolders");
            return list;
        }

        @NotNull
        public List<File> getJavaClassFolders() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public List<File> getJavaLibraries(boolean includeProvided) {
            return CollectionsKt.emptyList();
        }
    }
}

