/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeFixPerformer;
import com.android.tools.idea.lint.common.LintIdeReadOnlyFileProvider;
import com.android.tools.idea.lint.common.LintIdeReadWriteFileProvider;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.lint.client.api.LintFixPerformer;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.IncidentKt;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u001e\b\u0002\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u001b\u001a\u00070\t\u00a2\u0006\u0002\b\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J&\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0&2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000RF\u0010\u0015\u001a:\u0012\u0004\u0012\u00020\r\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00170\u0016j\u001c\u0012\u0004\u0012\u00020\r\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0017`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeFixPerformerFix;", "Lcom/intellij/modcommand/ModCommandAction;", "project", "Lcom/intellij/openapi/project/Project;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "name", "", "familyName", "valueOverride", "Lkotlin/Function2;", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEditFile;", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEdit;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/lint/detector/api/Incident;Lcom/android/tools/lint/detector/api/LintFix;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getFix", "()Lcom/android/tools/lint/detector/api/LintFix;", "performer", "Lcom/android/tools/idea/lint/common/LintIdeFixPerformer;", "edits", "Ljava/util/LinkedHashMap;", "Lkotlin/Pair;", "Lcom/intellij/psi/SmartPsiFileRange;", "", "Lkotlin/collections/LinkedHashMap;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "applyEdits", "", "fileData", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.lint"})
@SourceDebugExtension(value={"SMAP\nLintIdeFixPerformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintIdeFixPerformer.kt\ncom/android/tools/idea/lint/common/LintIdeFixPerformerFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,601:1\n1#2:602\n543#3,6:603\n*S KotlinDebug\n*F\n+ 1 LintIdeFixPerformer.kt\ncom/android/tools/idea/lint/common/LintIdeFixPerformerFix\n*L\n492#1:603,6\n*E\n"})
final class LintIdeFixPerformerFix
implements ModCommandAction {
    @NotNull
    private final Project project;
    @NotNull
    private final LintFix fix;
    @NotNull
    private final String name;
    @NotNull
    private final String familyName;
    @Nullable
    private final Function2<LintFixPerformer.PendingEditFile, LintFixPerformer.PendingEdit, String> valueOverride;
    @NotNull
    private final LintIdeFixPerformer performer;
    @NotNull
    private final LinkedHashMap<LintFixPerformer.PendingEditFile, Pair<SmartPsiFileRange, CharSequence>> edits;

    public LintIdeFixPerformerFix(@NotNull Project project, @NotNull Incident incident, @NotNull LintFix fix, @NotNull String name, @NotNull String familyName, @Nullable Function2<? super LintFixPerformer.PendingEditFile, ? super LintFixPerformer.PendingEdit, String> valueOverride) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        this.project = project;
        this.fix = fix;
        this.name = name;
        this.familyName = familyName;
        this.valueOverride = valueOverride;
        this.performer = new LintIdeFixPerformer(LintIdeSupport.createClient$default(LintIdeSupport.Companion.get(), this.project, null, 2, null));
        this.edits = new LinkedHashMap();
        List affectedFiles = this.performer.registerFixes(IncidentKt.copySafe((Incident)incident), CollectionsKt.listOf((Object)this.fix), new LintIdeReadOnlyFileProvider(this.project));
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.project);
        for (LintFixPerformer.PendingEditFile file : affectedFiles) {
            PsiFile psiFile;
            VirtualFile virtualFile = PhysicalFileSystemUtilsKt.toVirtualFile((File)file.getFile());
            PsiFile psiFile2 = psiFile = virtualFile != null ? PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)virtualFile, (Project)this.project) : null;
            if (psiFile != null) {
                SmartPsiFileRange pointer;
                CharSequence charSequence;
                CharSequence charSequence2;
                CharSequence charSequence3;
                TextRange textRange = file.affectedRange();
                Intrinsics.checkNotNullExpressionValue((Object)manager.createSmartPsiFileRangePointer(psiFile, textRange), (String)"createSmartPsiFileRangePointer(...)");
                int start = textRange.getStartOffset();
                int end = textRange.getEndOffset();
                Document document = PsiDocumentManager.getInstance((Project)this.project).getCachedDocument(psiFile);
                if (document != null && (charSequence3 = document.getCharsSequence()) != null && (charSequence2 = charSequence3.subSequence(start, end)) != null) {
                    charSequence = charSequence2;
                } else {
                    String string = psiFile.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String string2 = string.substring(start, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    charSequence = string2;
                }
                CharSequence contents = charSequence;
                ((Map)this.edits).put(file, new Pair((Object)pointer, (Object)contents));
                continue;
            }
            ((Map)this.edits).put(file, null);
        }
    }

    public /* synthetic */ LintIdeFixPerformerFix(Project project, Incident incident, LintFix lintFix, String string, String string2, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        String string3;
        String string4;
        if ((n & 8) != 0 && (string4 = lintFix.getDisplayName()) == null) {
            string4 = string = "Fix";
        }
        if ((n & 0x10) != 0 && (string3 = lintFix.getFamilyName()) == null) {
            string3 = string2 = string;
        }
        if ((n & 0x20) != 0) {
            function2 = null;
        }
        this(project, incident, lintFix, string, string2, (Function2<? super LintFixPerformer.PendingEditFile, ? super LintFixPerformer.PendingEdit, String>)function2);
    }

    @NotNull
    public final LintFix getFix() {
        return this.fix;
    }

    @NotNull
    public String getFamilyName() {
        return this.familyName;
    }

    @Nullable
    public Presentation getPresentation(@NotNull ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.edits.isEmpty()) {
            return null;
        }
        Map<LintFixPerformer.PendingEditFile, Integer> map = this.performer.getDeltas();
        if (map != null) {
            map.clear();
        }
        Iterator<Map.Entry<LintFixPerformer.PendingEditFile, Pair<SmartPsiFileRange, CharSequence>>> iterator = this.edits.entrySet().iterator();
        while (iterator.hasNext()) {
            CharSequence currentContents;
            CharSequence charSequence;
            CharSequence charSequence2;
            PsiFile psiFile;
            Document document;
            Object object;
            LintFixPerformer.PendingEditFile file;
            Segment range;
            Pair<SmartPsiFileRange, CharSequence> pair;
            Map.Entry<LintFixPerformer.PendingEditFile, Pair<SmartPsiFileRange, CharSequence>> entry;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            Intrinsics.checkNotNullExpressionValue((Object)entry.getKey(), (String)"<get-key>(...)");
            Pair<SmartPsiFileRange, CharSequence> pair2 = entry.getValue();
            if (pair2 == null) continue;
            SmartPsiFileRange pointer = (SmartPsiFileRange)pair.component1();
            CharSequence contents = (CharSequence)pair.component2();
            if (pointer.getContainingFile() == null) {
                return null;
            }
            if (pointer.getRange() == null) {
                return null;
            }
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            int delta = start - file.affectedRange().getStartOffset();
            if (delta != 0) {
                Map<LintFixPerformer.PendingEditFile, Integer> map2 = this.performer.getDeltas();
                if (map2 == null) {
                    Object it = object = (Map)new LinkedHashMap();
                    boolean bl = false;
                    this.performer.setDeltas((Map<LintFixPerformer.PendingEditFile, Integer>)it);
                    map2 = object;
                }
                Map<LintFixPerformer.PendingEditFile, Integer> deltas = map2;
                deltas.put(file, delta);
            }
            if ((document = PsiDocumentManager.getInstance((Project)this.project).getCachedDocument(psiFile)) != null && (object = document.getCharsSequence()) != null && (charSequence2 = object.subSequence(start, end)) != null) {
                charSequence = charSequence2;
            } else {
                String string = psiFile.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = string.substring(start, end);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                charSequence = string2;
            }
            if (Intrinsics.areEqual((Object)(currentContents = charSequence), (Object)contents)) continue;
            return null;
        }
        return Presentation.of((String)this.name);
    }

    @NotNull
    public ModCommand perform(@NotNull ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ModCommand modCommand = ModCommand.psiUpdate((ActionContext)context, arg_0 -> LintIdeFixPerformerFix.perform$lambda$2(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
        return modCommand;
    }

    private final void applyEdits(LintFixPerformer.PendingEditFile fileData, List<LintFixPerformer.PendingEdit> edits, ModPsiUpdater updater) {
        Segment range;
        LintFixPerformer.PendingEdit pendingEdit;
        List modifiedRanges;
        SmartPointerManager pointerManager;
        PsiDocumentManager documentManager;
        Project project;
        int delta;
        PsiFile file;
        PsiFile psiFile;
        block22: {
            if (edits.isEmpty()) {
                return;
            }
            File originalFile = fileData.getFile();
            psiFile = PhysicalFileSystemUtilsKt.toPsiFile((File)originalFile, (Project)this.project);
            if (psiFile == null) {
                if (fileData.getCreateText()) {
                    File file2 = originalFile.getParentFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
                    PsiDirectory psiDirectory = (PsiDirectory)updater.getWritable((PsiElement)PhysicalFileSystemUtilsKt.toPsiDirectory((File)file2, (Project)this.project));
                    psiFile = psiDirectory != null ? psiDirectory.createFile(originalFile.getName()) : null;
                }
            } else {
                psiFile = (PsiFile)updater.getWritable((PsiElement)psiFile);
                if (fileData.getCreateText()) {
                    psiFile.getFileDocument().setText((CharSequence)"");
                }
            }
            PsiFile psiFile2 = psiFile;
            Intrinsics.checkNotNull((Object)psiFile2);
            file = psiFile2;
            Map<LintFixPerformer.PendingEditFile, Integer> map = this.performer.getDeltas();
            delta = map != null && (map = map.get(fileData)) != null ? (Integer)((Object)map) : 0;
            Project project2 = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            project = project2;
            documentManager = PsiDocumentManager.getInstance((Project)project);
            pointerManager = SmartPointerManager.getInstance((Project)project);
            modifiedRanges = new ArrayList();
            List<LintFixPerformer.PendingEdit> $this$lastOrNull$iv = edits;
            boolean $i$f$lastOrNull = false;
            ListIterator<LintFixPerformer.PendingEdit> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                LintFixPerformer.PendingEdit element$iv = iterator$iv.previous();
                LintFixPerformer.PendingEdit it = element$iv;
                boolean bl = false;
                if (!(it.getSelectStart() != -1)) continue;
                pendingEdit = element$iv;
                break block22;
            }
            pendingEdit = null;
        }
        LintFixPerformer.PendingEdit firstSelection = pendingEdit;
        RangeMarker selectedRange = null;
        Document document = file.getFileDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
        Document document2 = document;
        documentManager.doPostponedOperationsAndUnblockDocument(document2);
        int originalLength = document2.getTextLength();
        for (LintFixPerformer.PendingEdit edit : edits) {
            boolean bl;
            Object object = this.valueOverride;
            if (object == null || (object = (String)object.invoke((Object)fileData, (Object)edit)) == null) {
                object = edit.getReplacement();
            }
            Function2<LintFixPerformer.PendingEditFile, LintFixPerformer.PendingEdit, String> replacement = object;
            int start = edit.getStartOffset() + delta;
            int end = edit.getEndOffset() + delta;
            document2.replaceString(start, end, (CharSequence)replacement);
            SmartPsiFileRange smartPsiFileRange = pointerManager.createSmartPsiFileRangePointer(file, TextRange.create((int)start, (int)(start + replacement.length())));
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
            modifiedRanges.add(smartPsiFileRange);
            if (!Intrinsics.areEqual((Object)firstSelection, (Object)edit)) continue;
            boolean bl2 = bl = firstSelection.getSelectStart() <= firstSelection.getSelectEnd();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            selectedRange = document2.createRangeMarker(start + firstSelection.getSelectStart(), start + firstSelection.getSelectEnd());
        }
        documentManager.commitDocument(document2);
        int replaceStart = ((LintFixPerformer.PendingEdit)CollectionsKt.last(edits)).getStartOffset();
        int replaceEnd = document2.getTextLength() - (originalLength - ((LintFixPerformer.PendingEdit)CollectionsKt.first(edits)).getEndOffset());
        TextRange textRange = TextRange.from((int)replaceStart, (int)(replaceEnd - replaceStart));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        TextRange resultTextRange = textRange;
        SmartPsiFileRange smartPsiFileRange = pointerManager.createSmartPsiFileRangePointer(file, resultTextRange);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"createSmartPsiFileRangePointer(...)");
        SmartPsiFileRange resultSmartRange = smartPsiFileRange;
        List imports = fileData.getImports();
        Collection collection = imports;
        if (!(collection == null || collection.isEmpty())) {
            collection = file;
            if (collection instanceof PsiJavaFile) {
                LintIdeFixPerformer.Companion.addJavaImports((PsiJavaFile)file, imports);
            } else if (collection instanceof KtFile) {
                LintIdeFixPerformer.Companion.addKotlinImports((KtFile)file, imports);
            }
        }
        if (fileData.getShortenReferences() && (range = resultSmartRange.getPsiRange()) != null) {
            TextRange textRange2 = new TextRange(range.getStartOffset(), range.getEndOffset());
            PsiFile psiFile3 = file;
            if (psiFile3 instanceof PsiJavaFile) {
                LintIdeFixPerformer.Companion.shortenJavaReferencesInRange(file, textRange2);
            } else if (psiFile3 instanceof KtFile) {
                ShortenReferencesFacility.Companion.getInstance().shorten((KtFile)file, textRange2);
            }
        }
        if (fileData.getReformat()) {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            Segment range2 = resultSmartRange.getPsiRange();
            if (range2 != null) {
                codeStyleManager.reformatRange((PsiElement)file, range2.getStartOffset(), range2.getEndOffset());
            }
        }
        if (fileData.getOpen() || fileData.getCreateText() && firstSelection != null) {
            updater.moveCaretTo((PsiElement)psiFile);
        }
        if (selectedRange != null) {
            int selectionStartOffset = selectedRange.getStartOffset();
            int selectionEndOffset = selectedRange.getEndOffset();
            if (selectionEndOffset <= file.getViewProvider().getDocument().getTextLength()) {
                updater.select(TextRange.create((int)selectionStartOffset, (int)selectionEndOffset));
            }
        }
    }

    private static final Unit perform$lambda$2$lambda$1(LintIdeFixPerformerFix this$0, ModPsiUpdater $updater, LintFixPerformer.PendingEditFile fileData, List edits) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter((Object)edits, (String)"edits");
        Intrinsics.checkNotNull((Object)$updater);
        this$0.applyEdits(fileData, edits, $updater);
        return Unit.INSTANCE;
    }

    private static final void perform$lambda$2(LintIdeFixPerformerFix this$0, ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        LintIdeReadWriteFileProvider fileProvider = new LintIdeReadWriteFileProvider(this$0.project, updater);
        LintIdeFixPerformer lintIdeFixPerformer = this$0.performer;
        LintFixPerformer.FileProvider fileProvider2 = fileProvider;
        Set<LintFixPerformer.PendingEditFile> set = this$0.edits.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        lintIdeFixPerformer.applyEdits(fileProvider2, CollectionsKt.toList((Iterable)set), (arg_0, arg_1) -> LintIdeFixPerformerFix.perform$lambda$2$lambda$1(this$0, updater, arg_0, arg_1));
    }
}

