/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\u001aF\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b\u00a8\u0006\n"}, d2={"getDefinedSeverityImpl", "Lcom/android/tools/lint/detector/api/Severity;", "superGetDefinedSeverity", "Lkotlin/Function0;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "visibleDefault", "enabledIssues", "", "disabledIssues", "intellij.lint"})
public final class LintIdeConfigurationKt {
    @Nullable
    public static final Severity getDefinedSeverityImpl(@NotNull Function0<? extends Severity> superGetDefinedSeverity, @NotNull Issue issue, @NotNull Severity visibleDefault, @NotNull Set<Issue> enabledIssues, @Nullable Set<Issue> disabledIssues) {
        Intrinsics.checkNotNullParameter(superGetDefinedSeverity, (String)"superGetDefinedSeverity");
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)visibleDefault, (String)"visibleDefault");
        Intrinsics.checkNotNullParameter(enabledIssues, (String)"enabledIssues");
        if (disabledIssues == null) {
            return enabledIssues.contains(issue) ? visibleDefault : Severity.IGNORE;
        }
        if (enabledIssues.contains(issue)) {
            Severity severity = (Severity)superGetDefinedSeverity.invoke();
            if (severity == null) {
                severity = visibleDefault;
            }
            return severity;
        }
        if (Intrinsics.areEqual((Object)issue, (Object)IssueRegistry.BASELINE_USED) || Intrinsics.areEqual((Object)issue, (Object)IssueRegistry.BASELINE_FIXED)) {
            return Severity.INFORMATIONAL;
        }
        if (disabledIssues.contains(issue)) {
            return Severity.IGNORE;
        }
        boolean isThirdPartyIssue = issue.getRegistry() instanceof JarFileIssueRegistry;
        if (isThirdPartyIssue) {
            return (Severity)superGetDefinedSeverity.invoke();
        }
        return Severity.IGNORE;
    }
}

