/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintGradleDeprecatedConfigurationInspection
extends AndroidLintInspectionBase {
    public AndroidLintGradleDeprecatedConfigurationInspection() {
        super(LintBundle.message("android.lint.inspections.gradle.deprecated.configuration", new Object[0]), GradleDetector.DEPRECATED_CONFIGURATION);
    }

    @Override
    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        LintIdeQuickFix[] quickFixes = super.getQuickFixes(startElement, endElement, message, fixData);
        if (!LintIdeSupport.get().shouldOfferUpgradeAssistantForDeprecatedConfigurations(startElement.getProject())) {
            return quickFixes;
        }
        return (LintIdeQuickFix[])Stream.concat(Arrays.stream(quickFixes), Stream.of(new InvokeAGPUpgradeAssistantQuickFix())).toArray(LintIdeQuickFix[]::new);
    }

    static class InvokeAGPUpgradeAssistantQuickFix
    extends DefaultLintQuickFix {
        public InvokeAGPUpgradeAssistantQuickFix() {
            super("Invoke AGP Upgrade Assistant on deprecated configurations");
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            LintIdeSupport.get().updateDeprecatedConfigurations(startElement.getProject(), startElement);
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            return true;
        }
    }
}

