/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestingInfrastructureFailureState;
import com.google.gct.testing.results.GoogleCloudTestingScheduledState;
import com.google.gct.testing.results.GoogleCloudTestingSuiteInProgressState;
import com.google.gct.testing.results.GoogleCloudTestingTimeoutState;
import com.google.gct.testing.results.GoogleCloudTestingTriggeringErrorState;
import com.google.gct.testing.results.GoogleCloudTestsPresentationUtil;
import com.intellij.execution.Location;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMStacktraceParser;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.CompoundTestFailedState;
import com.intellij.execution.testframework.sm.runner.states.NotRunState;
import com.intellij.execution.testframework.sm.runner.states.SuiteFinishedState;
import com.intellij.execution.testframework.sm.runner.states.TerminatedState;
import com.intellij.execution.testframework.sm.runner.states.TestComparisonFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestErrorState;
import com.intellij.execution.testframework.sm.runner.states.TestFailedState;
import com.intellij.execution.testframework.sm.runner.states.TestIgnoredState;
import com.intellij.execution.testframework.sm.runner.states.TestInProgressState;
import com.intellij.execution.testframework.sm.runner.states.TestPassedState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.AbstractProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestProxy
extends AbstractTestProxy
implements Navigatable {
    private List<GoogleCloudTestProxy> myChildren;
    private GoogleCloudTestProxy myParent;
    private AbstractState myState = NotRunState.getInstance();
    private final String myName;
    private Long myDuration = null;
    @Nullable
    private final String myLocationUrl;
    private boolean myDurationIsCached = false;
    private boolean myHasCriticalErrors = false;
    private boolean myHasErrorsCached = false;
    private boolean myHasPassedTests = false;
    private boolean myHasPassedTestsCached = false;
    @Nullable
    private String myStacktrace;
    private final boolean myIsSuite;
    private boolean myIsEmptyIsCached = false;
    private boolean myIsEmpty = true;
    SMTestLocator myLocator = null;
    private final boolean myPreservePresentableName;
    private Printer myPreferredPrinter = null;

    public GoogleCloudTestProxy(String testName, boolean isSuite, @Nullable String locationUrl) {
        this(testName, isSuite, locationUrl, false);
    }

    public GoogleCloudTestProxy(String testName, boolean isSuite, @Nullable String locationUrl, boolean preservePresentableName) {
        this.myName = testName;
        this.myIsSuite = isSuite;
        this.myLocationUrl = locationUrl;
        this.myPreservePresentableName = preservePresentableName;
    }

    public void setLocator(@NotNull SMTestLocator locator) {
        this.myLocator = locator;
    }

    public void setPreferredPrinter(@NotNull Printer preferredPrinter) {
        this.myPreferredPrinter = preferredPrinter;
    }

    public boolean isInProgress() {
        return this.myState.isInProgress();
    }

    public boolean isDefect() {
        return this.myState.isDefect();
    }

    public boolean isError() {
        return this.myState instanceof TestErrorState;
    }

    public boolean isFailure() {
        return this.myState instanceof TestFailedState;
    }

    public boolean shouldRun() {
        return true;
    }

    public int getMagnitude() {
        return this.getMagnitudeInfo().getValue();
    }

    public boolean isActiveScheduled() {
        return this.myState instanceof GoogleCloudTestingScheduledState && ((GoogleCloudTestingScheduledState)this.myState).isActive();
    }

    public TestStateInfo.Magnitude getMagnitudeInfo() {
        return this.myState.getMagnitude();
    }

    public boolean hasErrors() {
        if (this.myHasErrorsCached) {
            return this.myHasCriticalErrors;
        }
        boolean canCacheErrors = !this.myState.isInProgress();
        boolean hasErrors = this.calcHasErrors();
        if (canCacheErrors) {
            this.myHasCriticalErrors = hasErrors;
            this.myHasErrorsCached = true;
        }
        return hasErrors;
    }

    private boolean calcHasErrors() {
        if (this.myHasCriticalErrors) {
            return true;
        }
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (!googleCloudTestProxy.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public boolean isFinal() {
        return this.myState.isFinal();
    }

    private void setStacktraceIfNotSet(@Nullable String stacktrace) {
        if (this.myStacktrace == null) {
            this.myStacktrace = stacktrace;
        }
    }

    public boolean isLeaf() {
        return this.myChildren == null || this.myChildren.isEmpty();
    }

    public boolean isInterrupted() {
        return this.myState.wasTerminated();
    }

    public boolean hasPassedTests() {
        boolean canCache;
        if (this.myHasPassedTestsCached) {
            return this.myHasPassedTests;
        }
        boolean hasPassedTests = this.calcPassedTests();
        boolean bl = canCache = !this.myState.isInProgress();
        if (canCache) {
            this.myHasPassedTests = hasPassedTests;
            this.myHasPassedTestsCached = true;
        }
        return hasPassedTests;
    }

    boolean hasScheduledOrPendingConfigurations() {
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.SCHEDULED_INDEX && googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.RUNNING_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean calcPassedTests() {
        if (this.isPassed()) {
            return true;
        }
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (!googleCloudTestProxy.hasPassedTests()) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnored() {
        if (this.hasPassedTests()) {
            return false;
        }
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.IGNORED_INDEX;
    }

    public boolean isPassed() {
        return this.myState.getMagnitude() == TestStateInfo.Magnitude.SKIPPED_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.COMPLETE_INDEX || this.myState.getMagnitude() == TestStateInfo.Magnitude.PASSED_INDEX;
    }

    public void addChild(GoogleCloudTestProxy child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<GoogleCloudTestProxy>();
        }
        this.myChildren.add(child);
        if (this.getParent() != null && this.getParent().getParent() != null) {
            this.addLast((Printable)child);
            GoogleCloudTestProxy configurationNode = this.getParent();
            configurationNode.addLast((Printable)child);
            configurationNode.getParent().addLast((Printable)child);
        }
        child.setParent(this);
        child.setPrinter(this.myPrinter);
        if (this.myPreferredPrinter != null && child.myPreferredPrinter == null) {
            child.setPreferredPrinter(this.myPreferredPrinter);
        }
    }

    @Nullable
    private Printer getRightPrinter(@Nullable Printer printer) {
        if (this.myPreferredPrinter != null && printer != null) {
            return this.myPreferredPrinter;
        }
        return printer;
    }

    public void setPrinter(Printer printer) {
        super.setPrinter(this.getRightPrinter(printer));
    }

    public String getName() {
        return this.myName;
    }

    public boolean isConfig() {
        return false;
    }

    @Nullable
    public Location getLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        List locations;
        if (this.myLocationUrl == null || this.myLocator == null) {
            return null;
        }
        String protocolId = VirtualFileManager.extractProtocol((String)this.myLocationUrl);
        String path = GoogleCloudTestProxy.extractPath(this.myLocationUrl);
        if (protocolId != null && path != null && !(locations = this.myLocator.getLocation(protocolId, path, project, searchScope)).isEmpty()) {
            return (Location)locations.iterator().next();
        }
        return null;
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    private static String extractPath(@NotNull String locationUrl) {
        int index = locationUrl.indexOf("://");
        return index >= 0 ? locationUrl.substring(index + "://".length()) : null;
    }

    @Nullable
    public Navigatable getDescriptor(@Nullable Location location, @NotNull TestConsoleProperties testConsoleProperties) {
        Navigatable result;
        if (location == null) {
            return null;
        }
        String stacktrace = this.myStacktrace;
        if (stacktrace != null && testConsoleProperties instanceof SMStacktraceParser && this.isLeaf() && (result = ((SMStacktraceParser)testConsoleProperties).getErrorNavigatable(location, stacktrace)) != null) {
            return result;
        }
        return EditSourceUtil.getDescriptor((PsiElement)location.getPsiElement());
    }

    public boolean isSuite() {
        return this.myIsSuite;
    }

    public GoogleCloudTestProxy getParent() {
        return this.myParent;
    }

    public List<? extends GoogleCloudTestProxy> getChildren() {
        return this.myChildren != null ? this.myChildren : Collections.emptyList();
    }

    public List<GoogleCloudTestProxy> getAllTests() {
        ArrayList<GoogleCloudTestProxy> allTests = new ArrayList<GoogleCloudTestProxy>();
        allTests.add(this);
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            allTests.addAll(googleCloudTestProxy.getAllTests());
        }
        return allTests;
    }

    public void setStarted() {
        this.myState = !this.myIsSuite ? TestInProgressState.TEST : new GoogleCloudTestingSuiteInProgressState(this);
    }

    public void setScheduled() {
        this.myState = !this.myIsSuite ? TestInProgressState.TEST : new GoogleCloudTestingScheduledState(this);
    }

    public void setScheduledActive() {
        if (!(this.myState instanceof GoogleCloudTestingScheduledState)) {
            this.myState = new GoogleCloudTestingScheduledState(this);
        }
        ((GoogleCloudTestingScheduledState)this.myState).makeActive();
    }

    @Nullable
    public Long getDuration() {
        if (this.myDurationIsCached || !this.isSuite()) {
            return this.myDuration;
        }
        this.myDuration = this.calcSuiteDuration();
        this.myDurationIsCached = true;
        return this.myDuration;
    }

    private boolean isSubjectToHide(TestConsoleProperties consoleProperties) {
        return TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)consoleProperties) && this.getParent() != null && !this.isDefect();
    }

    @Nullable
    public String getDurationString(TestConsoleProperties consoleProperties) {
        switch (this.getMagnitudeInfo()) {
            case PASSED_INDEX: 
            case RUNNING_INDEX: {
                return !this.isSubjectToHide(consoleProperties) ? this.getDurationString() : null;
            }
            case COMPLETE_INDEX: 
            case FAILED_INDEX: 
            case ERROR_INDEX: 
            case IGNORED_INDEX: 
            case SKIPPED_INDEX: 
            case TERMINATED_INDEX: {
                return this.getDurationString();
            }
        }
        return null;
    }

    private String getDurationString() {
        Long duration = this.getDuration();
        return duration != null ? StringUtil.formatDuration((long)duration) : null;
    }

    public boolean shouldSkipRootNodeForExport() {
        return true;
    }

    public void setDuration(long duration) {
        this.invalidateCachedDurationForContainerSuites();
        this.myDurationIsCached = true;
        this.myDuration = duration >= 0L ? Long.valueOf(duration) : null;
    }

    public void setFinished() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = !this.isSuite() ? TestPassedState.INSTANCE : this.determineSuiteStateOnFinished();
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setTestFailed(@NotNull String localizedMessage, @Nullable String stackTrace, boolean testError) {
        this.setStacktraceIfNotSet(stackTrace);
        localizedMessage = this.getParent().getParent().getName() + "\n\t" + (String)localizedMessage;
        if (this.myState instanceof TestFailedState) {
            this.myState = GoogleCloudTestProxy.compoundOf((TestFailedState)this.myState, new TestFailedState((String)localizedMessage, stackTrace));
        } else {
            this.myState = testError ? new TestErrorState((String)localizedMessage, stackTrace) : new TestFailedState((String)localizedMessage, stackTrace);
            this.fireOnNewPrintable((Printable)this.myState);
        }
    }

    @NotNull
    private static CompoundTestFailedState compoundOf(@NotNull TestFailedState tfs1, @NotNull TestFailedState tfs2) {
        CompoundTestFailedState compoundTestFailedState = new CompoundTestFailedState();
        compoundTestFailedState.addFailure(tfs1);
        compoundTestFailedState.addFailure(tfs2);
        return compoundTestFailedState;
    }

    public void setTestComparisonFailed(@NotNull String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        this.setStacktraceIfNotSet(stackTrace);
        this.myState = new TestComparisonFailedState(localizedMessage, stackTrace, actualText, expectedText, true, null, null);
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setTestIgnored(@Nullable String ignoreComment, @Nullable String stackTrace) {
        this.setStacktraceIfNotSet(stackTrace);
        ignoreComment = this.getParent().getParent().getName() + "\n\t" + (String)ignoreComment;
        this.myState = new TestIgnoredState((String)ignoreComment, stackTrace);
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setParent(@Nullable GoogleCloudTestProxy parent) {
        this.myParent = parent;
    }

    public List<? extends GoogleCloudTestProxy> getChildren(@Nullable Filter<? super GoogleCloudTestProxy> filter) {
        List<? extends GoogleCloudTestProxy> allChildren = this.getChildren();
        return GoogleCloudTestProxy.filterChildren(filter, allChildren);
    }

    private static List<? extends GoogleCloudTestProxy> filterChildren(@Nullable Filter<? super GoogleCloudTestProxy> filter, List<? extends GoogleCloudTestProxy> allChildren) {
        if (filter == Filter.NO_FILTER || filter == null) {
            return allChildren;
        }
        ArrayList<GoogleCloudTestProxy> selectedChildren = new ArrayList<GoogleCloudTestProxy>();
        for (GoogleCloudTestProxy googleCloudTestProxy : allChildren) {
            if (!filter.shouldAccept((AbstractTestProxy)googleCloudTestProxy)) continue;
            selectedChildren.add(googleCloudTestProxy);
        }
        if (selectedChildren.isEmpty()) {
            return Collections.emptyList();
        }
        return selectedChildren;
    }

    public boolean wasLaunched() {
        return this.myState.wasLaunched();
    }

    public void printOn(Printer printer) {
        Printer rightPrinter = this.getRightPrinter(printer);
        super.printOn(rightPrinter);
        AbstractState oldState = this.myState;
        CompositePrintable.invokeInAlarm(() -> oldState.printOn(rightPrinter));
    }

    public void addStdOutput(String output, Key outputType, boolean shouldFireEvent) {
        GoogleCloudTestProxy parent = this.getParent();
        if (parent != null) {
            if (parent instanceof GoogleCloudRootTestProxy) {
                String configurationPrefix = this.getName() + "\n\t";
                parent.fireOnNewPrintable(this.printableFromString(configurationPrefix, outputType));
                parent.addStdOutput(configurationPrefix + output, outputType, false);
            } else {
                parent.addStdOutput(output, outputType, false);
            }
        }
        Printable outputPrintable = this.printableFromString(output, outputType);
        if (shouldFireEvent) {
            this.addLast(outputPrintable);
        } else {
            this.myNestedPrintables.add(outputPrintable);
        }
    }

    private Printable printableFromString(String text, Key outputType) {
        return printer -> printer.print(text, ConsoleViewContentType.getConsoleViewType((Key)outputType));
    }

    public void addStdErr(String output, boolean shouldFireEvent) {
        Printable printable = printer -> printer.print(output, ConsoleViewContentType.ERROR_OUTPUT);
        if (shouldFireEvent) {
            this.addLast(printable);
        } else {
            this.myNestedPrintables.add(printable);
        }
        GoogleCloudTestProxy parent = this.getParent();
        if (parent != null) {
            parent.addStdErr(output, false);
        }
    }

    @Deprecated
    public void addError(String output, @Nullable String stackTrace) {
        this.addError(output, stackTrace, true);
    }

    public void addError(String output, @Nullable String stackTrace, boolean isCritical) {
        this.myHasCriticalErrors = isCritical;
        this.setStacktraceIfNotSet(stackTrace);
        this.addLast(printer -> new TestFailedState(output, stackTrace).printOn(printer));
    }

    public void addSystemOutput(String output) {
        this.addLast(printer -> printer.print(output, ConsoleViewContentType.SYSTEM_OUTPUT));
    }

    @NotNull
    public String getPresentableName() {
        if (this.myPreservePresentableName) {
            return GoogleCloudTestsPresentationUtil.getPresentableNameTrimmedOnly(this);
        }
        return GoogleCloudTestsPresentationUtil.getPresentableName(this);
    }

    @Nullable
    public DiffHyperlink getDiffViewerProvider() {
        if (this.myState instanceof TestComparisonFailedState) {
            return ((TestComparisonFailedState)this.myState).getHyperlink();
        }
        if (this.myChildren != null) {
            for (GoogleCloudTestProxy child : this.myChildren) {
                DiffHyperlink provider;
                if (!child.isDefect() || (provider = child.getDiffViewerProvider()) == null) continue;
                return provider;
            }
        }
        return null;
    }

    public String toString() {
        return this.getPresentableName();
    }

    public void setTerminated() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = TerminatedState.INSTANCE;
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            googleCloudTestProxy.setTerminated();
        }
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setTimeout() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = new GoogleCloudTestingTimeoutState();
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            googleCloudTestProxy.setTimeout();
        }
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setInfrastructureFailed() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = new GoogleCloudTestingInfrastructureFailureState(this);
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            googleCloudTestProxy.setInfrastructureFailed();
        }
        this.fireOnNewPrintable((Printable)this.myState);
    }

    public void setTriggeringError() {
        if (this.myState.isFinal()) {
            return;
        }
        this.myState = new GoogleCloudTestingTriggeringErrorState(this);
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            googleCloudTestProxy.setTriggeringError();
        }
        this.fireOnNewPrintable((Printable)this.myState);
    }

    @Nullable
    public String getLocationUrl() {
        return this.myLocationUrl;
    }

    private boolean containsErrorTests() {
        List<? extends GoogleCloudTestProxy> children = this.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : children) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.ERROR_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsFailedTests() {
        List<? extends GoogleCloudTestProxy> children = this.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : children) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.FAILED_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsPassedTests() {
        List<? extends GoogleCloudTestProxy> children = this.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : children) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.PASSED_INDEX) continue;
            return true;
        }
        return false;
    }

    protected AbstractState determineSuiteStateOnFinished() {
        Object state = this.isLeaf() ? SuiteFinishedState.EMPTY_SUITE : (this.isEmptySuite() && !this.isDefect() && !this.containsTriggeringErrorChildren() ? SuiteFinishedState.EMPTY_SUITE : (this.isDefect() ? (this.containsTerminatedChildren() ? TerminatedState.INSTANCE : (this.containsTimeoutChildren() ? new GoogleCloudTestingTimeoutState() : (this.containsInfrastructureFailureChildren() ? new GoogleCloudTestingInfrastructureFailureState(this) : (this.containsErrorTests() ? SuiteFinishedState.ERROR_SUITE : (this.containsFailedTests() ? SuiteFinishedState.FAILED_SUITE : SuiteFinishedState.WITH_IGNORED_TESTS_SUITE))))) : (this.containsPassedTests() || !this.containsTriggeringErrorChildren() ? SuiteFinishedState.PASSED_SUITE : new GoogleCloudTestingTriggeringErrorState(this))));
        return state;
    }

    private boolean containsTerminatedChildren() {
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.TERMINATED_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsTimeoutChildren() {
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.TIMEOUT_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsInfrastructureFailureChildren() {
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.INFRASTRUCTURE_FAILURE_INDEX) continue;
            return true;
        }
        return false;
    }

    private boolean containsTriggeringErrorChildren() {
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            if (googleCloudTestProxy.getMagnitudeInfo() != TestStateInfo.Magnitude.TRIGGERING_ERROR_INDEX) continue;
            return true;
        }
        return false;
    }

    public boolean isEmptySuite() {
        if (this.myIsEmptyIsCached) {
            return this.myIsEmpty;
        }
        if (!this.isSuite()) {
            this.myIsEmpty = true;
            this.myIsEmptyIsCached = true;
            return this.myIsEmpty;
        }
        this.myIsEmpty = true;
        List<? extends GoogleCloudTestProxy> allTestCases = this.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : allTestCases) {
            if (googleCloudTestProxy.isSuite()) {
                if (!googleCloudTestProxy.isEmptySuite()) {
                    this.myIsEmpty = false;
                    this.myIsEmptyIsCached = true;
                    break;
                }
                this.myIsEmpty = true;
                this.myIsEmptyIsCached = this.myState.isFinal();
                continue;
            }
            this.myIsEmpty = false;
            this.myIsEmptyIsCached = true;
            break;
        }
        return this.myIsEmpty;
    }

    @Nullable
    private Long calcSuiteDuration() {
        long partialDuration = 0L;
        boolean durationOfChildrenIsUnknown = true;
        for (GoogleCloudTestProxy googleCloudTestProxy : this.getChildren()) {
            Long duration = googleCloudTestProxy.getDuration();
            if (duration == null) continue;
            durationOfChildrenIsUnknown = false;
            partialDuration += duration.longValue();
        }
        return durationOfChildrenIsUnknown ? null : Long.valueOf(partialDuration);
    }

    private void invalidateCachedDurationForContainerSuites() {
        this.myDuration = null;
        this.myDurationIsCached = false;
        GoogleCloudTestProxy containerSuite = this.getParent();
        if (containerSuite != null) {
            containerSuite.invalidateCachedDurationForContainerSuites();
        }
    }

    public static class GoogleCloudRootTestProxy
    extends GoogleCloudTestProxy {
        private String testRunId;
        private boolean myTestsReporterAttached;

        public GoogleCloudRootTestProxy() {
            super("[root]", true, null);
        }

        public String getTestRunId() {
            return this.testRunId;
        }

        public void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        public void setTestsReporterAttached() {
            this.myTestsReporterAttached = true;
        }

        public boolean isTestsReporterAttached() {
            return this.myTestsReporterAttached;
        }

        @Override
        protected AbstractState determineSuiteStateOnFinished() {
            if (this.isLeaf() && !this.isTestsReporterAttached()) {
                return SuiteFinishedState.TESTS_REPORTER_NOT_ATTACHED;
            }
            return super.determineSuiteStateOnFinished();
        }
    }
}

