/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp;

import com.android.tools.ndk.run.lldb.renderers.TemplateParamsParser;
import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class UniquePtrTypeNameFormatter
implements TypeNameFormatterCategory.TypeNameFormatter {
    private static boolean isDefaultDeleteType(@NotNull String dataType, @NotNull String deleteType) {
        String defaultDeleteType = String.format("std::default_delete<%s%s>", dataType, TemplateParamsParser.spaceBetweenAngleBracket(dataType));
        return deleteType.contentEquals(defaultDeleteType);
    }

    @Override
    @NotNull
    public String format(@NotNull String typeName) {
        int numParams;
        ArrayList<String> templateParams = TemplateParamsParser.getTemplateParams(typeName);
        int n = numParams = templateParams == null ? 0 : templateParams.size();
        if (numParams < 1 || numParams > 2) {
            return typeName;
        }
        String dataType = templateParams.get(0);
        if (templateParams.size() == 2 && !UniquePtrTypeNameFormatter.isDefaultDeleteType(dataType, templateParams.get(1))) {
            return typeName;
        }
        TypeNameFormatterCategory.TypeNameFormatter formatter = TypeNameFormatterCategory.lookupTypeNameFormatter(dataType);
        String formattedDataType = formatter == null ? dataType : formatter.format(dataType);
        return String.format("std::unique_ptr<%s%s>", formattedDataType, TemplateParamsParser.spaceBetweenAngleBracket(formattedDataType));
    }
}

