/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.Client;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.ConcurrencyUtil;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ShellSessionStarterImpl
extends SessionStarter {
    private static final Logger LOG = Logger.getInstance(ShellSessionStarterImpl.class);

    public ShellSessionStarterImpl(@NotNull Client client, @NotNull ClientShellHelper clientShellHelper, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull Project project) throws ExecutionException {
        super(client, clientShellHelper, localServerFile, localStartScriptFile, debuggerState, project);
    }

    @Override
    public void internalStartServer(ProgressIndicator indicator) throws ExecutionException {
        String mkdirOutput = this.executeCommand(this.getClientCommand(String.format("sh -c 'mkdir -p %s; mkdir -p %s'", this.getTargetRootDirectory(), this.getTargetBinDirectory())), 5L, TimeUnit.SECONDS, indicator);
        if (!mkdirOutput.isEmpty()) {
            LOG.warn(mkdirOutput);
        }
        this.copyFileToTargetBinDirectory(this.myServerTempFile.getFilePath(), indicator);
        this.copyFileToTargetBinDirectory(this.myStartScriptTempFile.getFilePath(), indicator);
        String startCmd = this.getStartCommandLine();
        LOG.info("Starting LLDB server : " + startCmd);
        indicator.setText("Starting LLDB server: " + startCmd);
        ApplicationManager.getApplication().executeOnPooledThread(() -> ConcurrencyUtil.runUnderThreadName((String)"lldb-server executor", () -> {
            try {
                String output = this.executeCommand(this.getClientCommand(startCmd), 0L, TimeUnit.DAYS, indicator);
                LOG.info("LLDB server has exited: " + output);
            }
            catch (ExecutionException e) {
                LOG.error("LLDB server has failed: ", (Throwable)e);
            }
        }));
    }

    @NotNull
    protected String executeCommand(@NotNull String command, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, ProgressIndicator indicator) throws ExecutionException {
        MyMultiLineReceiver receiver = new MyMultiLineReceiver(indicator);
        try {
            this.myDevice.executeShellCommand(command, (IShellOutputReceiver)receiver, maxTimeToOutputResponse, maxTimeUnits);
        }
        catch (Exception e) {
            throw new ExecutionException(String.format("Command failed: '%s'", command), (Throwable)e);
        }
        return receiver.getOutput();
    }

    private void copyFileToTargetBinDirectory(@NotNull String tmpDeviceFile, ProgressIndicator indicator) throws ExecutionException {
        String fileName = new File(tmpDeviceFile).getName();
        String destFile = ShellSessionStarterImpl.joinPaths(this.getTargetBinDirectory(), fileName);
        String copyChmodCommand = "cat " + tmpDeviceFile + " | " + this.getClientCommand(String.format("sh -c 'cat > %s && chmod 700 %s'", destFile, destFile));
        LOG.info("Copying to app folder: " + tmpDeviceFile + " => " + destFile);
        LOG.info("Command: " + copyChmodCommand);
        this.executeCommand(copyChmodCommand, 60L, TimeUnit.SECONDS, indicator);
    }

    private static class MyMultiLineReceiver
    extends MultiLineReceiver {
        private final StringBuilder myStringBuilder;
        private ProgressIndicator myIndicator;

        public MyMultiLineReceiver(ProgressIndicator indicator) {
            this.myIndicator = indicator;
            this.myStringBuilder = new StringBuilder();
        }

        public void processNewLines(@NotNull String[] lines) {
            for (String line : lines) {
                this.myStringBuilder.append(line).append("\n");
            }
        }

        public boolean isCancelled() {
            return this.myIndicator.isCanceled();
        }

        public String getOutput() {
            return this.myStringBuilder.toString();
        }
    }
}

