/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class SessionStarter {
    private Project myProject;
    private static final Logger LOG = Logger.getInstance(SessionStarter.class);
    protected final IDevice myDevice;
    private final NativeAndroidDebuggerState myDebuggerState;
    private final String myPlatformSocketName;
    protected final File myLocalServerFile;
    private final File myLocalStartScriptFile;
    private final String myTargetDataDir;
    private final String myTargetSocketDir;
    protected FileStat myServerTempFile;
    protected FileStat myStartScriptTempFile;
    private final List<EventListener> myEventListeners = Lists.newLinkedList();
    private boolean mySessionStarted = false;

    protected SessionStarter(@NotNull IDevice device, @NotNull String targetDataDir, @NotNull String targetSocketDir, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull Project project) throws ExecutionException {
        this.myDevice = device;
        this.myDebuggerState = debuggerState;
        this.myPlatformSocketName = String.format("platform-%d.sock", System.currentTimeMillis());
        this.myLocalServerFile = localServerFile;
        this.myLocalStartScriptFile = localStartScriptFile;
        this.myTargetDataDir = targetDataDir;
        this.myTargetSocketDir = targetSocketDir;
        this.myProject = project;
    }

    protected SessionStarter(@NotNull Client client, @NotNull ClientShellHelper clientShellHelper, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull Project project) throws ExecutionException {
        this(client.getDevice(), clientShellHelper.getDataDir(), SessionStarter.getHelpfullyNamedSocketDirectory(client), localServerFile, localStartScriptFile, debuggerState, project);
    }

    public void pushFilesToDevice(ProgressIndicator indicator) throws ExecutionException {
        LOG.info("Pushing files to device");
        indicator.setText("Pushing files to device");
        try {
            this.myServerTempFile = this.pushDebuggerFile(this.myDevice, this.myLocalServerFile);
            this.myStartScriptTempFile = this.pushDebuggerFile(this.myDevice, this.myLocalStartScriptFile);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @NotNull
    public List<Attachment> getLogFilesFromDevice() {
        String[] files = new String[]{"gdb-server.log", "platform.log"};
        ArrayList<Attachment> result = new ArrayList<Attachment>(files.length);
        for (String targetFile : files) {
            String contents;
            String targetPath = this.getTargetLogFilePath(targetFile);
            try {
                CollectingOutputReceiver receiver = new CollectingOutputReceiver();
                this.myDevice.executeShellCommand(this.getClientCommand("cat '" + targetPath + "'"), (IShellOutputReceiver)receiver, 30L, TimeUnit.SECONDS);
                contents = receiver.getOutput();
            }
            catch (Exception e) {
                contents = e.toString();
            }
            result.add(new Attachment(targetPath, contents));
        }
        return result;
    }

    @NotNull
    protected String getClientCommand(@NotNull String command) {
        return command;
    }

    public String startServer() throws ExecutionException {
        TaskInfo taskInfo = new TaskInfo(this){

            @NotNull
            public String getTitle() {
                return "Starting LLDB server";
            }

            public String getCancelText() {
                return "Stop Native Debug Session";
            }

            public String getCancelTooltipText() {
                return null;
            }

            public boolean isCancellable() {
                return true;
            }
        };
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(this.myProject, taskInfo);
        indicator.start();
        this.internalStartServer((ProgressIndicator)indicator);
        String connectUrl = this.getConnectUrl();
        indicator.finish(taskInfo);
        return connectUrl;
    }

    protected abstract void internalStartServer(ProgressIndicator var1) throws ExecutionException;

    @NotNull
    protected String getStartCommandLine() {
        return String.format("%s %s %s %s %s \"%s\"", this.getStartScriptTargetPath(), this.getTargetRootDirectory(), "unix-abstract", this.myTargetSocketDir, this.myPlatformSocketName, this.myDebuggerState.getTargetLoggingChannels());
    }

    @NotNull
    private String getConnectUrl() {
        return String.format("%s-connect://[%s]%s/%s", "unix-abstract", this.myDevice.getSerialNumber(), this.myTargetSocketDir, this.myPlatformSocketName);
    }

    @NotNull
    protected String getTargetRootDirectory() {
        return SessionStarter.joinPaths(this.myTargetDataDir, "lldb");
    }

    @NotNull
    protected String getTargetBinDirectory() {
        return SessionStarter.joinPaths(this.getTargetRootDirectory(), "bin");
    }

    @NotNull
    private String getTargetLogFilePath(@NotNull String file) {
        return SessionStarter.joinPaths(this.getTargetRootDirectory(), "log", file);
    }

    @NotNull
    protected String getTargetBinFilePath(@NotNull String filePath) {
        return SessionStarter.joinPaths(this.getTargetBinDirectory(), filePath);
    }

    @NotNull
    protected String getStartScriptTargetPath() {
        return this.getTargetBinFilePath("start_lldb_server.sh");
    }

    @NotNull
    protected static String joinPaths(String ... paths) {
        return StringUtil.join((String[])paths, (String)"/");
    }

    @NotNull
    private FileStat pushDebuggerFile(@NotNull IDevice myDevice, @NotNull File localFile) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        String fileName = localFile.getName();
        String tmpDestFile = SessionStarter.joinPaths("/data/local/tmp", fileName);
        Date localFileLmt = new Date(localFile.lastModified() / 1000L * 1000L);
        SyncService.FileStat destFileStat = myDevice.statFile(tmpDestFile);
        if (destFileStat == null || destFileStat.getMode() == 0 || !localFileLmt.equals(destFileStat.getLastModified()) || localFile.length() != (long)destFileStat.getSize()) {
            LOG.info("Pushing to the device: " + String.valueOf(localFile) + " => " + tmpDestFile);
            myDevice.pushFile(localFile.getAbsolutePath(), tmpDestFile);
        } else {
            LOG.info("Remote file " + tmpDestFile + " is up-to-date.");
        }
        return new FileStat(tmpDestFile, destFileStat == null ? 0L : destFileStat.getLastModified().getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStarted(XDebugSession debugSession) throws ExecutionException {
        List<EventListener> list = this.myEventListeners;
        synchronized (list) {
            assert (!this.mySessionStarted);
            this.mySessionStarted = true;
            for (EventListener eventListener : this.myEventListeners) {
                eventListener.sessionStarted(debugSession);
            }
            this.myEventListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(@NotNull EventListener eventListener) {
        List<EventListener> list = this.myEventListeners;
        synchronized (list) {
            assert (!this.mySessionStarted);
            this.myEventListeners.add(eventListener);
        }
    }

    @NotNull
    public IDevice getDevice() {
        return this.myDevice;
    }

    @NotNull
    private static String getHelpfullyNamedSocketDirectory(@NotNull Client client) {
        Object dir = client.getClientData().getPackageName() + "-" + client.getClientData().getUserId();
        if (((String)dir).length() >= 70) {
            dir = ((String)dir).substring(((String)dir).length() - 70);
        }
        return "/" + (String)dir;
    }

    protected static class FileStat {
        private final String myFilePath;
        private final long myLastModified;

        public FileStat(@NotNull String filePath, long lastModified) {
            this.myFilePath = filePath;
            this.myLastModified = lastModified;
        }

        @NotNull
        public String getFilePath() {
            return this.myFilePath;
        }

        public long getLastModified() {
            return this.myLastModified;
        }
    }

    public static interface EventListener {
        public void sessionStarted(XDebugSession var1) throws ExecutionException;
    }
}

