/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.tools.ndk.AndroidNdkBundle;
import com.android.tools.ndk.run.editor.HybridDebuggerSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class HybridDebuggerSteppingConfigurableUi
implements ConfigurableUi<HybridDebuggerSettings> {
    private JPanel myPanel;
    private JCheckBox myAlwaysSmartStepInto;

    public HybridDebuggerSteppingConfigurableUi() {
        this.setupUI();
    }

    public void reset(@NotNull HybridDebuggerSettings settings) {
        this.myAlwaysSmartStepInto.setSelected(settings.ALWAYS_SMART_STEP_INTO);
    }

    public boolean isModified(@NotNull HybridDebuggerSettings settings) {
        return this.myAlwaysSmartStepInto.isSelected() != settings.ALWAYS_SMART_STEP_INTO;
    }

    public void apply(@NotNull HybridDebuggerSettings settings) {
        settings.ALWAYS_SMART_STEP_INTO = this.myAlwaysSmartStepInto.isSelected();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myAlwaysSmartStepInto = new JCheckBox();
        this.loadButtonText(this.myAlwaysSmartStepInto, AndroidNdkBundle.message("label.debugger.general.configurable.always.smart.step.into", new Object[0]));
        this.myPanel.add((Component)this.myAlwaysSmartStepInto, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
    }

    private void loadButtonText(AbstractButton component, String text) {
        TextWithMnemonic textWithMnemonic = TextWithMnemonic.parse((String)text);
        component.setText(textWithMnemonic.getText());
        if (textWithMnemonic.hasMnemonic()) {
            component.setMnemonic(textWithMnemonic.getMnemonicCode());
            component.setDisplayedMnemonicIndex(textWithMnemonic.getMnemonicIndex());
        }
    }
}

