/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.reference;

import com.android.tools.ndk.jni.model.FindClassCall;
import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.GetFieldIdCall;
import com.android.tools.ndk.jni.model.GetMethodIdCall;
import com.android.tools.ndk.jni.model.JvmFieldId;
import com.android.tools.ndk.jni.model.JvmMethodId;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.reference.JvmClassReference;
import com.android.tools.ndk.jni.reference.JvmFieldReference;
import com.android.tools.ndk.jni.reference.JvmMethodReference;
import com.android.tools.ndk.jni.reference.JvmPackageReference;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.utils.DataSource;
import com.android.tools.ndk.jni.utils.DataSourceKt;
import com.android.tools.ndk.jni.utils.StringDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiReference;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000b\u001a!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000f\" \u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"buildReferencesFromFindClassCall", "", "Lcom/intellij/psi/PsiReference;", "jniCall", "Lcom/android/tools/ndk/jni/model/FindClassCall;", "classNameLiteral", "Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;", "(Lcom/android/tools/ndk/jni/model/FindClassCall;Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)[Lcom/intellij/psi/PsiReference;", "buildReferencesFromGetMethodIdCall", "Lcom/android/tools/ndk/jni/model/GetMethodIdCall;", "methodNameLiteral", "(Lcom/android/tools/ndk/jni/model/GetMethodIdCall;Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)[Lcom/intellij/psi/PsiReference;", "buildReferencesFromGetFieldIdCall", "Lcom/android/tools/ndk/jni/model/GetFieldIdCall;", "fieldNameLiteral", "(Lcom/android/tools/ndk/jni/model/GetFieldIdCall;Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)[Lcom/intellij/psi/PsiReference;", "contentTextRange", "Lcom/intellij/openapi/util/TextRange;", "kotlin.jvm.PlatformType", "getContentTextRange", "(Lcom/jetbrains/cidr/lang/psi/OCLiteralExpression;)Lcom/intellij/openapi/util/TextRange;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniReferenceContributor.kt\ncom/android/tools/ndk/jni/reference/JniReferenceContributorKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,228:1\n37#2:229\n36#2,3:230\n*S KotlinDebug\n*F\n+ 1 JniReferenceContributor.kt\ncom/android/tools/ndk/jni/reference/JniReferenceContributorKt\n*L\n137#1:229\n137#1:230,3\n*E\n"})
public final class JniReferenceContributorKt {
    @NotNull
    public static final PsiReference[] buildReferencesFromFindClassCall(@NotNull FindClassCall jniCall, @NotNull OCLiteralExpression classNameLiteral) {
        int classNameEndPosition;
        int numberOfBrackets;
        Intrinsics.checkNotNullParameter((Object)jniCall, (String)"jniCall");
        Intrinsics.checkNotNullParameter((Object)classNameLiteral, (String)"classNameLiteral");
        OCExpression oCExpression = jniCall.getClassNameExpression();
        DataSource dataSource = oCExpression != null ? DataSourceKt.getDataSource((OCElement)oCExpression) : null;
        Object object = dataSource instanceof StringDataSource ? (StringDataSource)dataSource : null;
        if (object == null || (object = ((StringDataSource)object).getString()) == null) {
            return new PsiReference[0];
        }
        Object classNameString = object;
        for (numberOfBrackets = 0; numberOfBrackets < ((String)classNameString).length() && ((String)classNameString).charAt(numberOfBrackets) == '['; ++numberOfBrackets) {
        }
        int classNameStartPosition = numberOfBrackets == 0 ? 0 : numberOfBrackets + 1;
        int n = classNameEndPosition = numberOfBrackets == 0 ? ((String)classNameString).length() : ((String)classNameString).length() - 1;
        if (classNameEndPosition <= classNameStartPosition) {
            return new PsiReference[0];
        }
        String string = ((String)classNameString).substring(classNameStartPosition, classNameEndPosition);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromStringOrNull(string);
        if (fullyQualifiedClassName == null) {
            return new PsiReference[0];
        }
        FullyQualifiedClassName className = fullyQualifiedClassName;
        int nameStartIndex = classNameStartPosition;
        List currentPackages = new ArrayList();
        List resultReferences = new ArrayList();
        for (String string2 : className.getPackages()) {
            ((Collection)currentPackages).add(string2);
            int nameEndIndex = nameStartIndex + string2.length();
            ((Collection)resultReferences).add(new JvmPackageReference(CollectionsKt.joinToString$default((Iterable)currentPackages, (CharSequence)".", null, null, (int)0, null, null, (int)62, null), classNameLiteral, new TextRange(1 + nameStartIndex, 1 + nameEndIndex)));
            nameStartIndex = nameEndIndex + 1;
        }
        List currentClasses = new ArrayList();
        for (String c : className.getClasses()) {
            ((Collection)currentClasses).add(c);
            int nameEndIndex = nameStartIndex + c.length();
            ((Collection)resultReferences).add(new JvmClassReference(new FullyQualifiedClassName(currentPackages, CollectionsKt.toMutableList((Collection)currentClasses)), classNameLiteral, new TextRange(1 + nameStartIndex, 1 + nameEndIndex)));
            nameStartIndex = nameEndIndex + 1;
        }
        Collection collection = resultReferences;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = collection;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    @NotNull
    public static final PsiReference[] buildReferencesFromGetMethodIdCall(@NotNull GetMethodIdCall jniCall, @NotNull OCLiteralExpression methodNameLiteral) {
        Intrinsics.checkNotNullParameter((Object)jniCall, (String)"jniCall");
        Intrinsics.checkNotNullParameter((Object)methodNameLiteral, (String)"methodNameLiteral");
        Project project = methodNameLiteral.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JniInfoInferencer $this$buildReferencesFromGetMethodIdCall_u24lambda_u240 = JniInfoInferencer.Companion.getInstance(project);
        boolean bl = false;
        JvmType jvmType = $this$buildReferencesFromGetMethodIdCall_u24lambda_u240.inferJvmClassType(jniCall.getClassExpression());
        Object object = jvmType instanceof JvmObjectType ? (JvmObjectType)jvmType : null;
        if (object == null || (object = ((JvmObjectType)object).getName()) == null) {
            return new PsiReference[0];
        }
        Object className = object;
        OCExpression oCExpression = jniCall.getMethodNameExpression();
        Object object2 = oCExpression != null ? DataSourceKt.getDataSource((OCElement)oCExpression) : null;
        Object object3 = object2 instanceof StringDataSource ? (StringDataSource)object2 : null;
        if (object3 == null || (object3 = ((StringDataSource)object3).getString()) == null) {
            return new PsiReference[0];
        }
        Object methodName = object3;
        OCExpression oCExpression2 = jniCall.getMethodTypeExpression();
        DataSource dataSource = oCExpression2 != null ? DataSourceKt.getDataSource((OCElement)oCExpression2) : null;
        Object object4 = dataSource instanceof StringDataSource ? (StringDataSource)dataSource : null;
        if (object4 == null || (object4 = ((StringDataSource)object4).getString()) == null) {
            return new PsiReference[0];
        }
        Object methodType = object4;
        object2 = new PsiReference[]{new JvmMethodReference(new JvmMethodId((FullyQualifiedClassName)className, (String)methodName, (String)methodType), methodNameLiteral)};
        return object2;
    }

    @NotNull
    public static final PsiReference[] buildReferencesFromGetFieldIdCall(@NotNull GetFieldIdCall jniCall, @NotNull OCLiteralExpression fieldNameLiteral) {
        Intrinsics.checkNotNullParameter((Object)jniCall, (String)"jniCall");
        Intrinsics.checkNotNullParameter((Object)fieldNameLiteral, (String)"fieldNameLiteral");
        Project project = fieldNameLiteral.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JniInfoInferencer $this$buildReferencesFromGetFieldIdCall_u24lambda_u241 = JniInfoInferencer.Companion.getInstance(project);
        boolean bl = false;
        PsiReference[] psiReferenceArray = $this$buildReferencesFromGetFieldIdCall_u24lambda_u241.inferJvmClassType(jniCall.getClassExpression());
        Object object = psiReferenceArray instanceof JvmObjectType ? (JvmObjectType)psiReferenceArray : null;
        if (object == null || (object = ((JvmObjectType)object).getName()) == null) {
            return new PsiReference[0];
        }
        Object className = object;
        OCExpression oCExpression = jniCall.getFieldNameExpression();
        DataSource dataSource = oCExpression != null ? DataSourceKt.getDataSource((OCElement)oCExpression) : null;
        Object object2 = dataSource instanceof StringDataSource ? (StringDataSource)dataSource : null;
        if (object2 == null || (object2 = ((StringDataSource)object2).getString()) == null) {
            return new PsiReference[0];
        }
        Object fieldName = object2;
        psiReferenceArray = new PsiReference[]{new JvmFieldReference(new JvmFieldId((FullyQualifiedClassName)className, (String)fieldName), fieldNameLiteral)};
        return psiReferenceArray;
    }

    private static final TextRange getContentTextRange(OCLiteralExpression $this$contentTextRange) {
        return $this$contentTextRange.getTextLength() >= 2 ? new TextRange(1, $this$contentTextRange.getTextLength() - 1) : $this$contentTextRange.getTextRange();
    }

    public static final /* synthetic */ TextRange access$getContentTextRange(OCLiteralExpression $receiver) {
        return JniReferenceContributorKt.getContentTextRange($receiver);
    }
}

