/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.model;

import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JvmFieldId;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0006\u0010\u001c\u001a\u00020\u001dJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\u000bH\u00c6\u0003J;\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/android/tools/ndk/jni/model/JvmFieldInfo;", "Lcom/intellij/openapi/util/ModificationTracker;", "className", "Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "fieldName", "", "fieldType", "Lcom/android/tools/ndk/jni/model/JvmType;", "isStatic", "", "psiElement", "Lcom/intellij/psi/PsiField;", "<init>", "(Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;Ljava/lang/String;Lcom/android/tools/ndk/jni/model/JvmType;ZLcom/intellij/psi/PsiField;)V", "getClassName", "()Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "getFieldName", "()Ljava/lang/String;", "getFieldType", "()Lcom/android/tools/ndk/jni/model/JvmType;", "()Z", "getPsiElement", "()Lcom/intellij/psi/PsiField;", "modificationStamp", "", "getModificationCount", "description", "getDescription", "toJvmFieldId", "Lcom/android/tools/ndk/jni/model/JvmFieldId;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "android-ndk"})
public final class JvmFieldInfo
implements ModificationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FullyQualifiedClassName className;
    @NotNull
    private final String fieldName;
    @NotNull
    private final JvmType fieldType;
    private final boolean isStatic;
    @NotNull
    private final PsiField psiElement;
    private final long modificationStamp;

    public JvmFieldInfo(@NotNull FullyQualifiedClassName className, @NotNull String fieldName, @NotNull JvmType fieldType, boolean isStatic, @NotNull PsiField psiElement) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        this.className = className;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.isStatic = isStatic;
        this.psiElement = psiElement;
        this.modificationStamp = this.psiElement.getContainingFile().getModificationStamp();
    }

    @NotNull
    public final FullyQualifiedClassName getClassName() {
        return this.className;
    }

    @NotNull
    public final String getFieldName() {
        return this.fieldName;
    }

    @NotNull
    public final JvmType getFieldType() {
        return this.fieldType;
    }

    public final boolean isStatic() {
        return this.isStatic;
    }

    @NotNull
    public final PsiField getPsiElement() {
        return this.psiElement;
    }

    public long getModificationCount() {
        return this.psiElement.isValid() ? this.psiElement.getContainingFile().getModificationStamp() : this.modificationStamp + 1L;
    }

    @NotNull
    public final String getDescription() {
        return this.fieldType.toShortJavaType() + " " + this.fieldName;
    }

    @NotNull
    public final JvmFieldId toJvmFieldId() {
        return new JvmFieldId(this.className, this.fieldName);
    }

    @NotNull
    public final FullyQualifiedClassName component1() {
        return this.className;
    }

    @NotNull
    public final String component2() {
        return this.fieldName;
    }

    @NotNull
    public final JvmType component3() {
        return this.fieldType;
    }

    public final boolean component4() {
        return this.isStatic;
    }

    @NotNull
    public final PsiField component5() {
        return this.psiElement;
    }

    @NotNull
    public final JvmFieldInfo copy(@NotNull FullyQualifiedClassName className, @NotNull String fieldName, @NotNull JvmType fieldType, boolean isStatic, @NotNull PsiField psiElement) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return new JvmFieldInfo(className, fieldName, fieldType, isStatic, psiElement);
    }

    public static /* synthetic */ JvmFieldInfo copy$default(JvmFieldInfo jvmFieldInfo, FullyQualifiedClassName fullyQualifiedClassName, String string, JvmType jvmType, boolean bl, PsiField psiField, int n, Object object) {
        if ((n & 1) != 0) {
            fullyQualifiedClassName = jvmFieldInfo.className;
        }
        if ((n & 2) != 0) {
            string = jvmFieldInfo.fieldName;
        }
        if ((n & 4) != 0) {
            jvmType = jvmFieldInfo.fieldType;
        }
        if ((n & 8) != 0) {
            bl = jvmFieldInfo.isStatic;
        }
        if ((n & 0x10) != 0) {
            psiField = jvmFieldInfo.psiElement;
        }
        return jvmFieldInfo.copy(fullyQualifiedClassName, string, jvmType, bl, psiField);
    }

    @NotNull
    public String toString() {
        return "JvmFieldInfo(className=" + this.className + ", fieldName=" + this.fieldName + ", fieldType=" + this.fieldType + ", isStatic=" + this.isStatic + ", psiElement=" + this.psiElement + ")";
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = result * 31 + this.fieldName.hashCode();
        result = result * 31 + this.fieldType.hashCode();
        result = result * 31 + Boolean.hashCode(this.isStatic);
        result = result * 31 + this.psiElement.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmFieldInfo)) {
            return false;
        }
        JvmFieldInfo jvmFieldInfo = (JvmFieldInfo)other;
        if (!Intrinsics.areEqual((Object)this.className, (Object)jvmFieldInfo.className)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fieldName, (Object)jvmFieldInfo.fieldName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fieldType, (Object)jvmFieldInfo.fieldType)) {
            return false;
        }
        if (this.isStatic != jvmFieldInfo.isStatic) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.psiElement, (Object)jvmFieldInfo.psiElement);
    }

    @JvmStatic
    @Nullable
    public static final JvmFieldInfo fromPsiField(@NotNull PsiField psiElement) {
        return Companion.fromPsiField(psiElement);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/ndk/jni/model/JvmFieldInfo$Companion;", "", "<init>", "()V", "fromPsiField", "Lcom/android/tools/ndk/jni/model/JvmFieldInfo;", "psiElement", "Lcom/intellij/psi/PsiField;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final JvmFieldInfo fromPsiField(@NotNull PsiField psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            if (psiElement.getContainingFile() == null) {
                return null;
            }
            PsiClass psiClass = psiElement.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromJavaClass(psiClass);
            if (fullyQualifiedClassName == null) {
                return null;
            }
            FullyQualifiedClassName className = fullyQualifiedClassName;
            String string = psiElement.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fieldName = string;
            PsiType psiType = psiElement.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            JvmType jvmType = JvmType.Companion.fromJavaType(psiType);
            if (jvmType == null) {
                return null;
            }
            JvmType fieldType = jvmType;
            return new JvmFieldInfo(className, fieldName, fieldType, JniUtilsKt.isStatic((JvmModifiersOwner)psiElement), psiElement);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

