/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.cidr.lang.LanguageUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/ndk/jni/inspections/KotlinInternalExternalFunctionInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nKotlinInternalExternalFunctionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinInternalExternalFunctionInspection.kt\ncom/android/tools/ndk/jni/inspections/KotlinInternalExternalFunctionInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JniInspectionTool.kt\ncom/android/tools/ndk/jni/inspections/JniInspectionTool\n+ 4 JniUtils.kt\ncom/android/tools/ndk/jni/utils/JniUtilsKt\n*L\n1#1,80:1\n1563#2:81\n1634#2,3:82\n62#3,4:85\n66#3:93\n67#3:103\n516#4,4:89\n522#4,9:94\n*S KotlinDebug\n*F\n+ 1 KotlinInternalExternalFunctionInspection.kt\ncom/android/tools/ndk/jni/inspections/KotlinInternalExternalFunctionInspection\n*L\n70#1:81\n70#1:82,3\n39#1:85,4\n39#1:93\n39#1:103\n39#1:89,4\n39#1:94,9\n*E\n"})
public final class KotlinInternalExternalFunctionInspection
extends JniInspectionTool {
    public KotlinInternalExternalFunctionInspection() {
        super(JniInspectionEvent.JniInspectionType.KOTLIN_INTERNAL_EXTERNAL_FUNCTION_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project)) {
            return new PsiElementVisitor(){};
        }
        return (PsiElementVisitor)VisitorWrappersKt.namedFunctionVisitor(arg_0 -> KotlinInternalExternalFunctionInspection.buildVisitor$lambda$3(this, holder, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean buildVisitor$lambda$3$lambda$2$lambda$1(KtNamedFunction $fn, Project project, ProblemDescriptor descriptor) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        KtPsiFactory factory = new KtPsiFactory(project, false, 2, null);
        String fnText = $fn.getText();
        Intrinsics.checkNotNull((Object)fnText);
        KtNamedFunction privateFn = factory.createFunction(fnText);
        privateFn.removeModifier(KtTokens.INTERNAL_KEYWORD);
        privateFn.addModifier(KtTokens.PRIVATE_KEYWORD);
        privateFn.setName($fn.getName() + "Impl");
        $fn.getParent().addAfter((PsiElement)privateFn, (PsiElement)$fn);
        $fn.removeModifier(KtTokens.EXTERNAL_KEYWORD);
        KtExpression ktExpression = $fn.getBodyExpression();
        if (ktExpression != null) {
            ktExpression.delete();
        }
        if ((psiElement = $fn.getEqualsToken()) == null) {
            KtTypeReference ktTypeReference = $fn.getTypeReference();
            if (ktTypeReference != null) {
                psiElement = (PsiElement)ktTypeReference;
            } else {
                KtParameterList ktParameterList = $fn.getValueParameterList();
                if (ktParameterList != null) {
                    psiElement = (PsiElement)ktParameterList;
                } else {
                    return false;
                }
            }
        }
        PsiElement fnEnd = psiElement;
        PsiElement eq = factory.createEQ();
        $fn.addAfter(eq, fnEnd);
        String string = $fn.getName();
        List list = $fn.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
        Iterable iterable = list;
        String string2 = string;
        KtPsiFactory ktPsiFactory = factory;
        boolean $i$f$map = false;
        void var11_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        KtExpression body = ktPsiFactory.createExpression(string2 + "Impl(" + CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")");
        PsiElement psiElement2 = (PsiElement)body;
        PsiElement psiElement3 = $fn.getEqualsToken();
        Intrinsics.checkNotNull((Object)psiElement3);
        $fn.addAfter(psiElement2, psiElement3);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit buildVisitor$lambda$3(KotlinInternalExternalFunctionInspection this$0, ProblemsHolder $holder, KtNamedFunction fn) {
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        if (fn.hasModifier(KtTokens.EXTERNAL_KEYWORD) && fn.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
            void inspectionType$iv$iv;
            void $this$reportJniPerf$iv$iv;
            void this_$iv;
            JniInspectionTool jniInspectionTool = this$0;
            PsiElement psiElement$iv = (PsiElement)fn;
            boolean $i$f$reportPerf$android_ndk = false;
            Project project = psiElement$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
            int n = 100;
            boolean $i$f$reportJniPerf = false;
            JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
            Instant startTime$iv$iv = Instant.now();
            try {
                JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                boolean bl = false;
                boolean bl2 = false;
                KtModifierList ktModifierList = fn.getModifierList();
                Intrinsics.checkNotNull((Object)ktModifierList);
                PsiElement psiElement = ktModifierList.getModifier(KtTokens.INTERNAL_KEYWORD);
                Intrinsics.checkNotNull((Object)psiElement);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{this$0.quickFix("Replace internal external function with private delegate", "Create private " + fn.getName() + "Impl() and delegate to it", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> KotlinInternalExternalFunctionInspection.buildVisitor$lambda$3$lambda$2$lambda$1(fn, arg_0, arg_1)))};
                $holder.registerProblem(psiElement, "An external function should not be marked internal.\n\nKotlin compiler mangles the name of an internal function with the build variant, which could cause UnsatisfiedLinkError at runtime depending on the build variant. \n\nPlease use a private external function instead and delegate this internal function to it.", ProblemHighlightType.GENERIC_ERROR, localQuickFixArray);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                void inverseSampleRate$iv$iv;
                if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                    Instant endTime$iv$iv = Instant.now();
                    JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                }
            }
        }
        return Unit.INSTANCE;
    }
}

