/*
 * Decompiled with CFR 0.152.
 */
package com.google.play.policy.insights;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/google/play/policy/insights/FullScreenIntentPolicyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "getApplicableMethodNames", "", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "policyinsights"})
public final class FullScreenIntentPolicyDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> PERMISSIONS = CollectionsKt.listOf((Object)"android.permission.USE_FULL_SCREEN_INTENT");
    @NotNull
    public static final String SET_FULL_SCREEN_INTENT = "setFullScreenIntent";
    @NotNull
    public static final String NOTIFICATION_BUILDER = "android.app.Notification.Builder";
    @NotNull
    public static final String NOTIFICATION_COMPAT_BUILDER = "androidx.core.app.NotificationCompat.Builder";
    public static final int MIN_TARGET_SDK_VERSION = 34;
    @NotNull
    public static final String ID = "FullScreenIntentPolicy";
    @NotNull
    public static final String DESCRIPTION = "Full Screen Intent Insights";
    @NotNull
    private static final String EXPLANATION = "On Android 14+, the `USE_FULL_SCREEN_INTENT` permission is auto-granted *only* for apps \\\nwhose core function is setting alarms or handling calls. For any other use case, you must \\\nobtain explicit user consent and clearly explain your need. This policy prevents the misuse \\\nof full-screen intents for non-critical purposes and requires that your use does not \\\ninterfere with or disrupt the user's device, other apps, or overall usability.\n\n**Dos:**\n\n- Request user consent for the permission and provide a clear explanation for the request if \\\nnot auto-granted. \n- Limit use to necessary high-priority notifications/alerts.\n- Submit a declaration form in your Play Console to establish pre-grant eligibility for the \\\nfull-screen intent permission if targeting Android 14+.\n\n**Don'ts:**\n\n- Use this permission for non-core or low-priority features.\n- Use this permission to interfere with devices or other apps.\n- Use this permission for disruptive ads or disruptive notifications.\n\n**Helpful Links:**\n\nSee Policy page: https://goo.gle/play-policy-full-screen-intent \nSee Help Center article: https://goo.gle/play-help-full-screen-intent \nSee Declaration form:  https://goo.gle/play-permission-decl-form\n\nAlways review the full policy in the Policy Center to ensure compliance.";
    @NotNull
    public static final String URL = "https://support.google.com/googleplay/android-developer/answer/9888170#full_screen_intent";
    @NotNull
    private static final String MESSAGE = "`USE_FULL_SCREEN_INTENT` permission is auto-granted to core alarm or call functions on \\\nAndroid 14+ but other use cases require user consent.";
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Attr nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        Attr attr = nameNode;
        if (CollectionsKt.contains((Iterable)PERMISSIONS, (Object)(attr != null ? attr.getValue() : null))) {
            Intrinsics.checkNotNull((Object)nameNode);
            context.report(new Incident(ISSUE, (Object)element, context.getLocation((Node)nameNode), MESSAGE), Constraints.targetSdkAtLeast((int)34));
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)SET_FULL_SCREEN_INTENT);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, NOTIFICATION_BUILDER, false) & !context.getEvaluator().isMemberInSubClassOf((PsiMember)method, NOTIFICATION_COMPAT_BUILDER, false)) {
            return;
        }
        context.report(new Incident(ISSUE, (Object)node, context.getNameLocation((UElement)node), MESSAGE), Constraints.targetSdkAtLeast((int)34));
    }

    static {
        Issue.Companion companion = Issue.Companion;
        String string = EXPLANATION;
        Category category = Category.Companion.create("Play Policy", 84);
        Severity severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE};
        Implementation implementation = new Implementation(FullScreenIntentPolicyDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), enumSetArray);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)ID, (String)DESCRIPTION, (String)string, (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/google/play/policy/insights/FullScreenIntentPolicyDetector$Companion;", "", "<init>", "()V", "PERMISSIONS", "", "", "getPERMISSIONS", "()Ljava/util/List;", "SET_FULL_SCREEN_INTENT", "NOTIFICATION_BUILDER", "NOTIFICATION_COMPAT_BUILDER", "MIN_TARGET_SDK_VERSION", "", "ID", "DESCRIPTION", "EXPLANATION", "getEXPLANATION", "()Ljava/lang/String;", "URL", "MESSAGE", "getMESSAGE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "policyinsights"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPERMISSIONS() {
            return PERMISSIONS;
        }

        @NotNull
        public final String getEXPLANATION() {
            return EXPLANATION;
        }

        @NotNull
        public final String getMESSAGE() {
            return MESSAGE;
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

