/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.DfaType;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenSelfTypeExhaustivenessChecker;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J.\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "<init>", "()V", "isApplicable", "", "subjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "recordValue", "", "value", "", "data", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$Flags;", "computeMissingCases", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "destination", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "Flags", "ConditionChecker", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,626:1\n1617#2,9:627\n1869#2:636\n1870#2:638\n1626#2:639\n1869#2,2:640\n1#3:637\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker\n*L\n358#1:627,9\n358#1:636\n358#1:638\n358#1:639\n359#1:640,2\n358#1:637\n*E\n"})
final class WhenOnBooleanExhaustivenessChecker
extends WhenExhaustivenessChecker {
    @NotNull
    public static final WhenOnBooleanExhaustivenessChecker INSTANCE = new WhenOnBooleanExhaustivenessChecker();

    private WhenOnBooleanExhaustivenessChecker() {
        super(null);
    }

    @Override
    public boolean isApplicable(@NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        Intrinsics.checkNotNullParameter(session, "session");
        return Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(subjectType), StandardClassIds.INSTANCE.getBoolean());
    }

    private final void recordValue(Object value2, Flags data) {
        Object object = value2;
        if (Intrinsics.areEqual(object, true)) {
            data.setContainsTrue(true);
        } else if (Intrinsics.areEqual(object, false)) {
            data.setContainsFalse(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void computeMissingCases(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session, @NotNull Collection<WhenMissingCase> destination) {
        Intrinsics.checkNotNullParameter(whenExpression, "whenExpression");
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(destination, "destination");
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.ImprovedExhaustivenessChecksIn21) && WhenSelfTypeExhaustivenessChecker.INSTANCE.isExhaustiveThroughSelfTypeCheck(whenExpression, subjectType, session)) {
            return;
        }
        Flags flags = new Flags();
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.DataFlowBasedExhaustiveness)) {
            FirSmartCastExpression firSmartCastExpression;
            FirVariable firVariable = whenExpression.getSubjectVariable();
            Object object = firVariable != null ? firVariable.getInitializer() : null;
            FirSmartCastExpression firSmartCastExpression2 = firSmartCastExpression = object instanceof FirSmartCastExpression ? (FirSmartCastExpression)object : null;
            if (firSmartCastExpression != null && (object = firSmartCastExpression.getLowerTypesFromSmartCast()) != null) {
                void $this$forEach$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Iterable iterable = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                Iterator iterator2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    Boolean it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl = false;
                    DfaType it = (DfaType)element$iv$iv;
                    boolean bl2 = false;
                    DfaType.BooleanLiteral booleanLiteral = it instanceof DfaType.BooleanLiteral ? (DfaType.BooleanLiteral)it : null;
                    if ((booleanLiteral != null ? Boolean.valueOf(booleanLiteral.getValue()) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl = false;
                    INSTANCE.recordValue(it, flags);
                }
            }
        }
        whenExpression.accept(ConditionChecker.INSTANCE, flags);
        if (!flags.getContainsTrue()) {
            destination.add(WhenMissingCase.BooleanIsMissing.TrueIsMissing.INSTANCE);
        }
        if (!flags.getContainsFalse()) {
            destination.add(WhenMissingCase.BooleanIsMissing.FalseIsMissing.INSTANCE);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$ConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker$AbstractConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$Flags;", "<init>", "()V", "visitEqualityOperatorCall", "", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "data", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$ConditionChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,626:1\n1#2:627\n46#3:628\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$ConditionChecker\n*L\n373#1:628\n*E\n"})
    private static final class ConditionChecker
    extends WhenExhaustivenessChecker.AbstractConditionChecker<Flags> {
        @NotNull
        public static final ConditionChecker INSTANCE = new ConditionChecker();

        private ConditionChecker() {
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull Flags data) {
            Intrinsics.checkNotNullParameter(equalityOperatorCall, "equalityOperatorCall");
            Intrinsics.checkNotNullParameter(data, "data");
            FirOperation it = equalityOperatorCall.getOperation();
            boolean bl = false;
            boolean bl2 = it == FirOperation.EQ || it == FirOperation.IDENTITY;
            if (bl2) {
                FirCall $this$arguments$iv = equalityOperatorCall;
                boolean $i$f$getArguments = false;
                FirExpression argument = $this$arguments$iv.getArgumentList().getArguments().get(1);
                if (argument instanceof FirLiteralExpression) {
                    INSTANCE.recordValue(((FirLiteralExpression)argument).getValue(), data);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnBooleanExhaustivenessChecker$Flags;", "", "<init>", "()V", "containsTrue", "", "getContainsTrue", "()Z", "setContainsTrue", "(Z)V", "containsFalse", "getContainsFalse", "setContainsFalse", "resolve"})
    private static final class Flags {
        private boolean containsTrue;
        private boolean containsFalse;

        public final boolean getContainsTrue() {
            return this.containsTrue;
        }

        public final void setContainsTrue(boolean bl) {
            this.containsTrue = bl;
        }

        public final boolean getContainsFalse() {
            return this.containsFalse;
        }

        public final void setContainsFalse(boolean bl) {
            this.containsFalse = bl;
        }
    }
}

