/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackersImpl;
import com.jetbrains.cidr.lang.workspace.RunAfterOCWorkspaceIsInitialized;
import com.jetbrains.cidr.lang.workspace.RunAfterOCWorkspaceIsLoaded;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class OCWorkspaceRunConfigurationListener {
    private static volatile boolean ourDisableUpdatesInTests;
    @Nullable
    private volatile OCResolveConfiguration mySelectedResolveConfiguration;

    private static void listenChanges(final @NotNull Project project) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(0);
        }
        final MessageBusConnection connection = project.getMessageBus().connect();
        class MyListener
        implements RunManagerListener,
        ExecutionTargetListener,
        OCWorkspaceListener {
            final AtomicInteger bulkUpdate = new AtomicInteger(0);
            final AtomicBoolean updateTarget = new AtomicBoolean();

            MyListener() {
            }

            public void beginUpdate() {
                this.bulkUpdate.incrementAndGet();
            }

            public void endUpdate() {
                if (this.bulkUpdate.decrementAndGet() == 0) {
                    this.doUpdate();
                }
            }

            public void runConfigurationSelected(@Nullable RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    MyListener.$$$reportNull$$$0(0);
                }
                this.doUpdate();
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    MyListener.$$$reportNull$$$0(1);
                }
                this.doUpdate();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    MyListener.$$$reportNull$$$0(2);
                }
                this.doUpdate();
            }

            public void activeTargetChanged(@NotNull ExecutionTarget newTarget) {
                if (newTarget == null) {
                    MyListener.$$$reportNull$$$0(3);
                }
                this.doUpdate();
            }

            @Override
            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                if (event == null) {
                    MyListener.$$$reportNull$$$0(4);
                }
                if (event.resolveConfigurationsChanged() || event.clientVersionChanged()) {
                    this.updateTarget.set(true);
                    this.doUpdate();
                }
            }

            void doUpdate() {
                if (ourDisableUpdatesInTests || this.bulkUpdate.get() != 0) {
                    return;
                }
                MergingUpdateQueue queue = new MergingUpdateQueue("update selected configuration", 0, true, null, (Disposable)connection, null, true);
                queue.queue(new Update("1"){

                    public void run() {
                        if (updateTarget.getAndSet(false)) {
                            ExecutionTargetManager.getInstance((Project)project).update();
                        }
                        OCWorkspaceRunConfigurationListener.updateSelectedConfiguration(project);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newTarget";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener$1MyListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "activeTargetChanged";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "workspaceChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        MyListener listener = new MyListener();
        connection.subscribe(RunManagerListener.TOPIC, (Object)listener);
        connection.subscribe(ExecutionTargetManager.TOPIC, (Object)listener);
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)listener);
    }

    @RequiresEdt
    private static void updateSelectedConfiguration(@NotNull Project project) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(1);
        }
        OCResolveConfiguration selectedResolveConfiguration = (OCResolveConfiguration)ReadAction.compute(() -> {
            OCRunConfiguration rc;
            OCResolveConfiguration configuration;
            RunConfiguration patt4849$temp;
            RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
            ExecutionTarget target = ExecutionTargetManager.getInstance((Project)project).getActiveTarget();
            if (settings != null && (patt4849$temp = settings.getConfiguration()) instanceof OCRunConfiguration && (configuration = (rc = (OCRunConfiguration)patt4849$temp).getResolveConfiguration(target)) != null) {
                return configuration;
            }
            return null;
        });
        OCWorkspaceRunConfigurationListener.setSelectedResolveConfiguration(project, selectedResolveConfiguration);
    }

    @Nullable
    public static OCResolveConfiguration getSelectedResolveConfiguration(@NotNull Project project) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(2);
        }
        return project.isDefault() ? null : OCWorkspaceRunConfigurationListener.getInstance((Project)project).mySelectedResolveConfiguration;
    }

    @RequiresEdt
    public static void setSelectedResolveConfiguration(@NotNull Project project, @Nullable OCResolveConfiguration selectedResolveConfiguration) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(3);
        }
        if (project.isDefault()) {
            return;
        }
        OCWorkspaceRunConfigurationListener configurationListener = OCWorkspaceRunConfigurationListener.getInstance(project);
        if (!Objects.equals(configurationListener.mySelectedResolveConfiguration, selectedResolveConfiguration)) {
            OCResolveConfiguration old = configurationListener.mySelectedResolveConfiguration;
            configurationListener.mySelectedResolveConfiguration = selectedResolveConfiguration;
            ApplicationManager.getApplication().runWriteAction(() -> {
                OCWorkspaceModificationTrackersImpl trackers = (OCWorkspaceModificationTrackersImpl)OCWorkspace.getInstance(project).getModificationTrackers();
                trackers.fireSelectedResolveConfigurationChanged();
            });
            OCResolveContextSettings.getInstance(project).onRunConfigurationChanged(old, selectedResolveConfiguration);
        }
    }

    @NotNull
    private static OCWorkspaceRunConfigurationListener getInstance(@NotNull Project project) {
        if (project == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(4);
        }
        OCWorkspaceRunConfigurationListener oCWorkspaceRunConfigurationListener = (OCWorkspaceRunConfigurationListener)project.getService(OCWorkspaceRunConfigurationListener.class);
        if (oCWorkspaceRunConfigurationListener == null) {
            OCWorkspaceRunConfigurationListener.$$$reportNull$$$0(5);
        }
        return oCWorkspaceRunConfigurationListener;
    }

    @TestOnly
    public static void setDisableUpdatesInTests(boolean value) {
        ourDisableUpdatesInTests = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listenChanges";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedResolveConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedResolveConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static final class LoadedActivity
    implements RunAfterOCWorkspaceIsLoaded {
        @Override
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                LoadedActivity.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().invokeLater(() -> OCWorkspaceRunConfigurationListener.updateSelectedConfiguration(project), project.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener$LoadedActivity", "runActivity"));
        }
    }

    public static final class InitializedActivity
    implements RunAfterOCWorkspaceIsInitialized {
        @Override
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                InitializedActivity.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().invokeLater(() -> OCWorkspaceRunConfigurationListener.listenChanges(project), project.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/workspace/OCWorkspaceRunConfigurationListener$InitializedActivity", "runActivity"));
        }
    }
}

