/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import icons.CidrLangIcons;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewModuleFileAction
extends OCNewFileWithSelectedExtensionAction<MyCreateFileDialog> {
    public OCNewModuleFileAction() {
        super((FileType)OCNewFileLangBackendHandlerProvider.getHandler().getFileType(), CidrLangBundle.message((String)"create.cpp.module.title", (Object[])new Object[0]), CidrLangBundle.message((String)"create.cpp.module.title", (Object[])new Object[0]), CidrLangIcons.FileTypes.Cpp);
    }

    @Nullable
    private static CidrCompilerSwitches getBestCompilerSwitches(OCResolveConfiguration config) {
        @Nullable CidrCompilerSwitches switches = config.getCompilerSettings((OCLanguageKind)CLanguageKind.CPP).getCompilerSwitches();
        if (switches != null && !switches.equals(CidrCompilerSwitches.EMPTY)) {
            return switches;
        }
        switches = config.getCompilerSettings((OCLanguageKind)CLanguageKind.C).getCompilerSwitches();
        if (switches != null && !switches.equals(CidrCompilerSwitches.EMPTY)) {
            return switches;
        }
        for (OCCompilerSettings settings : config.getAllCompilerSettings().toList()) {
            switches = settings.getCompilerSwitches();
            if (switches == null || switches.equals(CidrCompilerSwitches.EMPTY)) continue;
            return switches;
        }
        return null;
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        @NotNull List<OCResolveConfiguration> configs = OCWorkspace.getInstance(project).getConfigurations();
        OCResolveConfiguration config = (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, configs).first;
        if (config == null) {
            return false;
        }
        @Nullable CidrCompilerSwitches compilerSwitches = OCNewModuleFileAction.getBestCompilerSwitches(config);
        if (compilerSwitches == null) {
            OCResolveConfiguration curConfig;
            Iterator<OCResolveConfiguration> iterator = configs.iterator();
            while (iterator.hasNext() && (compilerSwitches = OCNewModuleFileAction.getBestCompilerSwitches(curConfig = iterator.next())) == null) {
            }
        }
        if (compilerSwitches == null) {
            return false;
        }
        OCLanguageStandard langStandard = OCLanguageStandard.findLanguageStandard(compilerSwitches.getList(CidrCompilerSwitches.Format.RAW));
        return langStandard == null || langStandard.supports(OCLanguageStandard.CPP20);
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        if (OCFileTypeHelpers.isModuleFile((String)selectedName)) {
            return new OCNewFileActionBase.NewFileNames(selectedName, null);
        }
        OCNewFileActionBase.DisposableState state = this.getState();
        String extension = state != null && ((MyCreateFileDialog)state.dialogPeer).getFileExtensionPair() != null ? ((MyCreateFileDialog)state.dialogPeer).getFileExtensionPair().mySourceExt : (String)OCFileTypeHelpers.moduleExtensions().stream().toList().get(0);
        return new OCNewFileActionBase.NewFileNames(selectedName + "." + extension, null);
    }

    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        if (sampleFile == null) {
            OCNewModuleFileAction.$$$reportNull$$$0(0);
        }
        OCNewFileActionBase.NewFileNames newFileNames = this.getNewFileNames(selectedName);
        if (newFileNames == null) {
            OCNewModuleFileAction.$$$reportNull$$$0(1);
        }
        return newFileNames;
    }

    protected boolean isValidName(@NotNull String selectedName) {
        String sourceName;
        if (selectedName == null) {
            OCNewModuleFileAction.$$$reportNull$$$0(2);
        }
        if ((sourceName = this.getNewFileNames(selectedName).getSourceName()) == null || !super.isValidName(sourceName) || !OCFileTypeHelpers.isModuleFile((String)sourceName)) {
            return false;
        }
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)sourceName);
        @NotNull List moduleNameParts = StringUtil.split((String)nameWithoutExtension, (String)".", (boolean)true, (boolean)false);
        for (String part : moduleNameParts) {
            if (!StringUtil.isEmpty((String)part) && StringUtil.isJavaIdentifier((String)part)) continue;
            return false;
        }
        return true;
    }

    protected String getFileTemplate(String fileName) {
        return "C++ Module File.ixx";
    }

    protected String getName() {
        if (OCFileTypeHelpers.isModuleFile((String)this.mySelectedName)) {
            return FileUtilRt.getNameWithoutExtension((String)this.mySelectedName);
        }
        return this.mySelectedName;
    }

    @NotNull
    protected MyCreateFileDialog createDialog(@NlsContexts.Label @NotNull String defaultName) {
        if (defaultName == null) {
            OCNewModuleFileAction.$$$reportNull$$$0(3);
        }
        return new MyCreateFileDialog(defaultName, this.getHelpId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCNewModuleFileAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCNewModuleFileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFileNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileNames";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    protected class MyCreateFileDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        MyCreateFileDialog(@Nullable String defaultName, String helpId) {
            super((OCNewFileWithSelectedExtensionAction)OCNewModuleFileAction.this, defaultName, helpId);
        }

        @NotNull
        protected String getPresentableName(@NotNull FileExtensionPair pair) {
            if (pair == null) {
                MyCreateFileDialog.$$$reportNull$$$0(0);
            }
            String string = "." + pair.mySourceExt;
            if (string == null) {
                MyCreateFileDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected boolean isAllowed(FileExtensionPair pair) {
            return pair.myHeaderExt.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCNewModuleFileAction$MyCreateFileDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCNewModuleFileAction$MyCreateFileDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

