/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.oauth;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.IntellijLoginClient;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.LandingPages;
import com.google.cloud.tools.intellij.login.ByoidProviderKt;
import com.google.cloud.tools.intellij.login.ClientCredentialsKt;
import com.google.cloud.tools.intellij.util.CloudCodePlatform;
import com.google.cloud.tools.intellij.util.CommonDirectoryProvider;
import com.google.cloud.tools.intellij.util.PlatformsKt;
import com.intellij.ide.BrowserUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/google/tools/intellij/aiplugin/oauth/AiPluginIntelliJLoginClient;", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/IntellijLoginClient;", "()V", "browse", "", "url", "", "getByoidAuthUrl", "getByoidProviderName", "getCredentialStoragePath", "Ljava/nio/file/Path;", "getLandingPages", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/LandingPages;", "getOAuthClientId", "getOAuthClientNotSoSecret", "Companion", "aiplugin.ij-platform"})
@StabilityInferred(parameters=1)
public final class AiPluginIntelliJLoginClient
implements IntellijLoginClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String DEFAULT_AUTH_BASE_URL = "https://auth.cloud.google/authorize";

    public void browse(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        BrowserUtil.browse((String)url);
    }

    @NotNull
    public Path getCredentialStoragePath() {
        CloudCodePlatform cloudCodePlatform = PlatformsKt.currentPlatform();
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties(...)");
        Map<String, String> map2 = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getenv(...)");
        String[] stringArray = new String[]{"intellij"};
        Path path2 = Paths.get(((Object)CommonDirectoryProvider.INSTANCE.getPlatformSpecificDepsDir(cloudCodePlatform, properties, map2)).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return path2;
    }

    @NotNull
    public LandingPages getLandingPages() {
        return new LandingPages("https://developers.google.com/gemini-code-assist/auth/auth_success_gemini", "https://developers.google.com/gemini-code-assist/auth/auth_failure_gemini");
    }

    @NotNull
    public String getOAuthClientId() {
        return ClientCredentialsKt.getOauthClientId();
    }

    @NotNull
    public String getOAuthClientNotSoSecret() {
        return ClientCredentialsKt.getOauthClientNotSoSecret();
    }

    @Nullable
    public String getByoidProviderName() {
        return ByoidProviderKt.isByoidEnabled() ? ByoidProviderKt.getWifProviderName() : null;
    }

    @Nullable
    public String getByoidAuthUrl() {
        if (!ByoidProviderKt.isByoidEnabled()) {
            return null;
        }
        String authUrl = ByoidProviderKt.getWifAuthUrl();
        CharSequence charSequence = authUrl;
        return charSequence == null || charSequence.length() == 0 ? DEFAULT_AUTH_BASE_URL : authUrl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/google/tools/intellij/aiplugin/oauth/AiPluginIntelliJLoginClient$Companion;", "", "()V", "DEFAULT_AUTH_BASE_URL", "", "aiplugin.ij-platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

