/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.notes;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.ReleaseNotesUrlSource;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.analytics.UsageTrackerService;
import com.google.tools.intellij.aiplugin.logs.GeminiBackendLogger;
import com.google.tools.intellij.aiplugin.notification.AiPluginNotificationService;
import com.google.tools.intellij.aiplugin.state.AiPluginSettingsProvider;
import com.google.tools.intellij.aiplugin.util.PluginInfoUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/google/tools/intellij/aiplugin/notes/ReleaseNotesService;", "", "()V", "backendLogger", "Lcom/google/tools/intellij/aiplugin/logs/GeminiBackendLogger;", "pluginVersionPartsSize", "", "getAndClearReleaseNotesInChatMessage", "", "handleVersionChange", "", "currentVersion", "previousVersion", "prettifyVersion", "version", "showNotificationsForVersion", "", "showReleaseNotesNotification", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nReleaseNotesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseNotesService.kt\ncom/google/tools/intellij/aiplugin/notes/ReleaseNotesService\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,105:1\n1088#2,2:106\n1088#2,2:108\n*S KotlinDebug\n*F\n+ 1 ReleaseNotesService.kt\ncom/google/tools/intellij/aiplugin/notes/ReleaseNotesService\n*L\n77#1:106,2\n79#1:108,2\n*E\n"})
public final class ReleaseNotesService {
    @NotNull
    private final GeminiBackendLogger backendLogger = GeminiBackendLogger.Companion.getINSTANCE();
    private final int pluginVersionPartsSize;
    public static final int $stable = GeminiBackendLogger.$stable;

    public ReleaseNotesService() {
        this.pluginVersionPartsSize = 3;
    }

    public final void handleVersionChange(@NotNull String currentVersion, @NotNull String previousVersion) {
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
        Intrinsics.checkNotNullParameter((Object)previousVersion, (String)"previousVersion");
        if (this.showNotificationsForVersion(currentVersion, previousVersion)) {
            AiPluginSettingsProvider.Companion.getInstance().setShouldShowReleaseNotesNotificationMessageInChat(true);
            this.showReleaseNotesNotification();
        }
    }

    @Nullable
    public final String getAndClearReleaseNotesInChatMessage() {
        String string;
        if (AiPluginSettingsProvider.Companion.getInstance().getShouldShowReleaseNotesNotificationMessageInChat()) {
            AiPluginSettingsProvider.Companion.getInstance().setShouldShowReleaseNotesNotificationMessageInChat(false);
            Object[] objectArray = new Object[]{SmlIjBundle.message("aiplugin.product.name", new Object[0]), this.prettifyVersion(PluginInfoUtil.INSTANCE.getPluginVersion()), SmlIjBundle.message("aiplugin.release.notes.link", new Object[0])};
            string = SmlIjBundle.message("aiplugin.release.notes.notification.chat.message", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    private final void showReleaseNotesNotification() {
        AiPluginNotificationService aiPluginNotificationService = AiPluginNotificationService.Companion.getInstance();
        Object[] objectArray = new Object[]{SmlIjBundle.message("aiplugin.product.name", new Object[0])};
        String string = SmlIjBundle.message("aiplugin.release.notes.notification.title", objectArray);
        NotificationAction notificationAction = NotificationAction.createSimple((String)SmlIjBundle.message("aiplugin.release.notes.notification.text", new Object[0]), ReleaseNotesService::showReleaseNotesNotification$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimple(...)");
        AiPluginNotificationService.notifyInformation$default(aiPluginNotificationService, string, "", (AnAction)notificationAction, null, 8, null);
    }

    private final boolean showNotificationsForVersion(String currentVersion, String previousVersion) {
        boolean bl;
        block8: {
            boolean bl2;
            char it;
            char element$iv;
            int n;
            boolean $i$f$any;
            CharSequence $this$any$iv;
            block7: {
                if (PluginInfoUtil.INSTANCE.isRunningInAndroidStudio()) {
                    return false;
                }
                $this$any$iv = currentVersion;
                $i$f$any = false;
                for (n = 0; n < $this$any$iv.length(); ++n) {
                    it = element$iv = $this$any$iv.charAt(n);
                    boolean bl3 = false;
                    if (!Character.isLetter(it)) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
            if (bl2) {
                return false;
            }
            $this$any$iv = previousVersion;
            $i$f$any = false;
            for (n = 0; n < $this$any$iv.length(); ++n) {
                it = element$iv = $this$any$iv.charAt(n);
                boolean bl4 = false;
                if (!Character.isLetter(it)) continue;
                bl = true;
                break block8;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        String[] $i$f$any = new String[]{"."};
        List currentVersionParts = StringsKt.split$default((CharSequence)this.prettifyVersion(currentVersion), (String[])$i$f$any, (boolean)false, (int)0, (int)6, null);
        String[] stringArray = new String[]{"."};
        List previousVersionParts = StringsKt.split$default((CharSequence)this.prettifyVersion(previousVersion), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (currentVersionParts.size() != this.pluginVersionPartsSize) {
            this.backendLogger.warn("GCA current version " + currentVersion + " is not prod version. Skipping release notes notifications.");
            return false;
        }
        if (previousVersionParts.size() != this.pluginVersionPartsSize) {
            this.backendLogger.warn("GCA previous version " + previousVersion + " is not prod version. Skipping release notes notifications.");
            return false;
        }
        return !Intrinsics.areEqual(currentVersionParts.get(0), previousVersionParts.get(0)) || !Intrinsics.areEqual(currentVersionParts.get(1), previousVersionParts.get(1));
    }

    private final String prettifyVersion(String version) {
        return StringsKt.substringBeforeLast$default((String)version, (String)"-", null, (int)2, null);
    }

    private static final void showReleaseNotesNotification$lambda$0() {
        UsageTrackerService.Companion.getInstance().trackReleaseNotesOpen(ReleaseNotesUrlSource.INFORMATION_NOTIFICATION);
        BrowserUtil.browse((String)SmlIjBundle.message("aiplugin.release.notes.link", new Object[0]));
    }
}

