/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.completion;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.studiobot.util.Diffs;
import com.google.tools.intellij.aiplugin.completion.Suggestion;
import com.google.tools.intellij.aiplugin.completion.SuggestionDiff;
import com.google.tools.intellij.aiplugin.completion.SuggestionLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/google/tools/intellij/aiplugin/completion/DiffToSuggestionParser;", "", "()V", "ADDITION_PREFIX", "", "DELETION_PREFIX", "MIN_CHAR_SUGGESTION_THRESHOLD", "", "createModificationSuggestions", "", "Lcom/google/tools/intellij/aiplugin/completion/SuggestionLine;", "startLine", "removedLines", "", "addedLines", "findInlineDiff", "Lcom/google/tools/intellij/aiplugin/completion/DiffToSuggestionParser$InlineDiffResult;", "oldLine", "newLine", "handleAddition", "Lcom/google/tools/intellij/aiplugin/completion/Suggestion;", "state", "Lcom/google/tools/intellij/aiplugin/completion/DiffToSuggestionParser$ParserState;", "handleModificationOrDeletion", "parse", "Lcom/google/tools/intellij/aiplugin/completion/SuggestionDiff;", "diff", "parseHunk", "hunk", "Lcom/android/tools/idea/studiobot/util/Diffs$Hunk;", "InlineDiffResult", "ParserState", "aiplugin.ij-platform"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nDiffToSuggestionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffToSuggestionParser.kt\ncom/google/tools/intellij/aiplugin/completion/DiffToSuggestionParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1374#2:225\n1460#2,5:226\n774#2:231\n865#2:232\n1761#2,3:233\n866#2:236\n774#2:237\n865#2,2:238\n774#2:240\n865#2,2:241\n*S KotlinDebug\n*F\n+ 1 DiffToSuggestionParser.kt\ncom/google/tools/intellij/aiplugin/completion/DiffToSuggestionParser\n*L\n38#1:225\n38#1:226,5\n39#1:231\n39#1:232\n40#1:233,3\n39#1:236\n51#1:237\n51#1:238,2\n65#1:240\n65#1:241,2\n*E\n"})
public final class DiffToSuggestionParser {
    @NotNull
    public static final DiffToSuggestionParser INSTANCE = new DiffToSuggestionParser();
    private static final char ADDITION_PREFIX = '+';
    private static final char DELETION_PREFIX = '-';
    private static final int MIN_CHAR_SUGGESTION_THRESHOLD = 3;
    public static final int $stable;

    private DiffToSuggestionParser() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SuggestionDiff parse(@NotNull String diff) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        List<Diffs.Hunk> hunks = Diffs.Companion.parseDiff(diff);
        Iterable iterable = hunks;
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Diffs.Hunk hunk = (Diffs.Hunk)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.parseHunk(hunk);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                Suggestion it = (Suggestion)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = it.getSuggestionLines();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SuggestionLine line = (SuggestionLine)element$iv;
                        boolean bl3 = false;
                        if (!(((Object)StringsKt.trim((CharSequence)line.getText())).toString().length() >= 3 || ((Object)StringsKt.trim((CharSequence)line.getToReplace())).toString().length() >= 3)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredSuggestions = (List)destination$iv$iv;
        return new SuggestionDiff(diff, filteredSuggestions, false, false, 0, null, 60, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Suggestion> parseHunk(Diffs.Hunk hunk) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)hunk.getContent());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.startsWith$default((String)it, (String)"\\", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        int n2 = 0;
        int n3 = hunk.getNewFileStartLine() - 1;
        int n4 = hunk.getOriginalFileStartLine() - 1;
        List list = (List)destination$iv$iv;
        ParserState state2 = new ParserState(list, n4, n3, n2, n, defaultConstructorMarker);
        List suggestions = new ArrayList();
        while (state2.hasMoreLines()) {
            String line = state2.currentLine();
            if (StringsKt.startsWith$default((CharSequence)line, (char)'+', (boolean)false, (int)2, null)) {
                suggestions.add(this.handleAddition(state2));
                continue;
            }
            if (StringsKt.startsWith$default((CharSequence)line, (char)'-', (boolean)false, (int)2, null)) {
                suggestions.add(this.handleModificationOrDeletion(state2));
                continue;
            }
            state2.consumeContextLine();
        }
        Iterable $this$filter$iv2 = suggestions;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Suggestion it = (Suggestion)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)it.getSuggestionLines()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final Suggestion handleAddition(ParserState state2) {
        int startBlockLine = state2.getNewLineCounter();
        List<String> addedLines = state2.consumeLinesWithPrefix('+');
        SuggestionLine suggestionLine = new SuggestionLine(startBlockLine, null, "", CollectionsKt.joinToString$default((Iterable)addedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        state2.setNewLineCounter(state2.getNewLineCounter() + addedLines.size());
        return new Suggestion(addedLines.size(), CollectionsKt.listOf((Object)suggestionLine), false, false, 12, null);
    }

    private final Suggestion handleModificationOrDeletion(ParserState state2) {
        int startBlockLine = state2.getNewLineCounter();
        List<String> removedLines = state2.consumeLinesWithPrefix('-');
        List<String> addedLines = state2.consumeLinesWithPrefix('+');
        if (addedLines.isEmpty()) {
            SuggestionLine suggestionLine = new SuggestionLine(startBlockLine, null, CollectionsKt.joinToString$default((Iterable)removedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n", "");
            state2.setOriginalLineCounter(state2.getOriginalLineCounter() + removedLines.size());
            return new Suggestion(-removedLines.size(), CollectionsKt.listOf((Object)suggestionLine), false, false, 12, null);
        }
        List<SuggestionLine> suggestionLines = this.createModificationSuggestions(startBlockLine, removedLines, addedLines);
        state2.setOriginalLineCounter(state2.getOriginalLineCounter() + removedLines.size());
        state2.setNewLineCounter(state2.getNewLineCounter() + addedLines.size());
        int lineDelta = addedLines.size() - removedLines.size();
        return new Suggestion(lineDelta, suggestionLines, false, false, 12, null);
    }

    private final List<SuggestionLine> createModificationSuggestions(int startLine, List<String> removedLines, List<String> addedLines) {
        List suggestionLines = new ArrayList();
        int commonCount = Math.min(removedLines.size(), addedLines.size());
        for (int i2 = 0; i2 < commonCount; ++i2) {
            String replaceWith;
            InlineDiffResult inlineDiffResult = this.findInlineDiff(removedLines.get(i2), addedLines.get(i2));
            int inlineOffset = inlineDiffResult.component1();
            String toReplace = inlineDiffResult.component2();
            if (Intrinsics.areEqual((Object)toReplace, (Object)(replaceWith = inlineDiffResult.component3()))) continue;
            suggestionLines.add(new SuggestionLine(startLine + i2, inlineOffset, toReplace, replaceWith));
        }
        if (removedLines.size() > commonCount) {
            String line = CollectionsKt.joinToString$default((Iterable)removedLines.subList(commonCount, removedLines.size()), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n";
            int n = startLine + commonCount;
            suggestionLines.add(new SuggestionLine(n, null, line, ""));
        }
        if (addedLines.size() > commonCount) {
            String line = CollectionsKt.joinToString$default((Iterable)addedLines.subList(commonCount, addedLines.size()), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            int n = startLine + commonCount;
            suggestionLines.add(new SuggestionLine(n, null, "", line));
        }
        return suggestionLines;
    }

    private final InlineDiffResult findInlineDiff(String oldLine, String newLine) {
        int prefixLength = StringsKt.commonPrefixWith$default((CharSequence)oldLine, (CharSequence)newLine, (boolean)false, (int)2, null).length();
        String string = oldLine.substring(prefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String oldRemainder = string;
        String string2 = newLine.substring(prefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String newRemainder = string2;
        int suffixLength = StringsKt.commonSuffixWith$default((CharSequence)oldRemainder, (CharSequence)newRemainder, (boolean)false, (int)2, null).length();
        return new InlineDiffResult(prefixLength, StringsKt.dropLast((String)oldRemainder, (int)suffixLength), StringsKt.dropLast((String)newRemainder, (int)suffixLength));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/DiffToSuggestionParser$InlineDiffResult;", "", "inlineOffset", "", "toReplace", "", "replaceWith", "(ILjava/lang/String;Ljava/lang/String;)V", "getInlineOffset", "()I", "getReplaceWith", "()Ljava/lang/String;", "getToReplace", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "aiplugin.ij-platform"})
    private static final class InlineDiffResult {
        private final int inlineOffset;
        @NotNull
        private final String toReplace;
        @NotNull
        private final String replaceWith;

        public InlineDiffResult(int inlineOffset, @NotNull String toReplace, @NotNull String replaceWith) {
            Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
            Intrinsics.checkNotNullParameter((Object)replaceWith, (String)"replaceWith");
            this.inlineOffset = inlineOffset;
            this.toReplace = toReplace;
            this.replaceWith = replaceWith;
        }

        public final int getInlineOffset() {
            return this.inlineOffset;
        }

        @NotNull
        public final String getToReplace() {
            return this.toReplace;
        }

        @NotNull
        public final String getReplaceWith() {
            return this.replaceWith;
        }

        public final int component1() {
            return this.inlineOffset;
        }

        @NotNull
        public final String component2() {
            return this.toReplace;
        }

        @NotNull
        public final String component3() {
            return this.replaceWith;
        }

        @NotNull
        public final InlineDiffResult copy(int inlineOffset, @NotNull String toReplace, @NotNull String replaceWith) {
            Intrinsics.checkNotNullParameter((Object)toReplace, (String)"toReplace");
            Intrinsics.checkNotNullParameter((Object)replaceWith, (String)"replaceWith");
            return new InlineDiffResult(inlineOffset, toReplace, replaceWith);
        }

        public static /* synthetic */ InlineDiffResult copy$default(InlineDiffResult inlineDiffResult, int n, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = inlineDiffResult.inlineOffset;
            }
            if ((n2 & 2) != 0) {
                string = inlineDiffResult.toReplace;
            }
            if ((n2 & 4) != 0) {
                string2 = inlineDiffResult.replaceWith;
            }
            return inlineDiffResult.copy(n, string, string2);
        }

        @NotNull
        public String toString() {
            return "InlineDiffResult(inlineOffset=" + this.inlineOffset + ", toReplace=" + this.toReplace + ", replaceWith=" + this.replaceWith + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.inlineOffset);
            result2 = result2 * 31 + this.toReplace.hashCode();
            result2 = result2 * 31 + this.replaceWith.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InlineDiffResult)) {
                return false;
            }
            InlineDiffResult inlineDiffResult = (InlineDiffResult)other;
            if (this.inlineOffset != inlineDiffResult.inlineOffset) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.toReplace, (Object)inlineDiffResult.toReplace)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.replaceWith, (Object)inlineDiffResult.replaceWith);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/google/tools/intellij/aiplugin/completion/DiffToSuggestionParser$ParserState;", "", "lines", "", "", "originalLineCounter", "", "newLineCounter", "currentIndex", "(Ljava/util/List;III)V", "getNewLineCounter", "()I", "setNewLineCounter", "(I)V", "getOriginalLineCounter", "setOriginalLineCounter", "advance", "", "consumeContextLine", "consumeLinesWithPrefix", "prefix", "", "currentLine", "hasMoreLines", "", "aiplugin.ij-platform"})
    private static final class ParserState {
        @NotNull
        private final List<String> lines;
        private int originalLineCounter;
        private int newLineCounter;
        private int currentIndex;

        public ParserState(@NotNull List<String> lines, int originalLineCounter, int newLineCounter, int currentIndex) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            this.lines = lines;
            this.originalLineCounter = originalLineCounter;
            this.newLineCounter = newLineCounter;
            this.currentIndex = currentIndex;
        }

        public /* synthetic */ ParserState(List list, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 8) != 0) {
                n3 = 0;
            }
            this(list, n, n2, n3);
        }

        public final int getOriginalLineCounter() {
            return this.originalLineCounter;
        }

        public final void setOriginalLineCounter(int n) {
            this.originalLineCounter = n;
        }

        public final int getNewLineCounter() {
            return this.newLineCounter;
        }

        public final void setNewLineCounter(int n) {
            this.newLineCounter = n;
        }

        public final boolean hasMoreLines() {
            return this.currentIndex < this.lines.size();
        }

        @NotNull
        public final String currentLine() {
            return this.lines.get(this.currentIndex);
        }

        public final void advance() {
            int n = this.currentIndex;
            this.currentIndex = n + 1;
        }

        public final void consumeContextLine() {
            int n = this.originalLineCounter;
            this.originalLineCounter = n + 1;
            n = this.newLineCounter;
            this.newLineCounter = n + 1;
            this.advance();
        }

        @NotNull
        public final List<String> consumeLinesWithPrefix(char prefix) {
            List consumedLines = new ArrayList();
            while (this.hasMoreLines() && StringsKt.startsWith$default((CharSequence)this.currentLine(), (char)prefix, (boolean)false, (int)2, null)) {
                String string = this.currentLine().substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                consumedLines.add(string);
                this.advance();
            }
            return consumedLines;
        }
    }
}

