/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.intellij.aiplugin.action;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.studiobot.action.GeminiEditorActionGroup;
import com.google.tools.intellij.aiplugin.SmlIjBundle;
import com.google.tools.intellij.aiplugin.flag.FeatureFlagsService;
import com.google.tools.intellij.aiplugin.outlines.OutlinesService;
import com.google.tools.intellij.aiplugin.outlines.TriggerType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/google/tools/intellij/aiplugin/action/OutlinesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "aiplugin.ij-platform"})
@StabilityInferred(parameters=0)
public final class OutlinesAction
extends DumbAwareAction {
    public static final int $stable = 8;

    public OutlinesAction() {
        super(SmlIjBundle.message("aiplugin.outlines.action.text", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setEnabledAndVisible(false);
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        VirtualFile virtualFile2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file = virtualFile2;
        OutlinesService outlinesService = OutlinesService.Companion.getInstance(project3);
        boolean isEnabled = FeatureFlagsService.Companion.getInstance().isOutlinesEnabled() && GeminiEditorActionGroup.Companion.isActionAllowedByAiExclude(e) && editor3.getDocument().getTextLength() > 0 && outlinesService.isFileSupported(file);
        presentation2.setEnabledAndVisible(isEnabled);
        if (outlinesService.hasOutlines(file)) {
            presentation2.setText(SmlIjBundle.message("aiplugin.outlines.refresh.action.text", new Object[0]));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        VirtualFile virtualFile2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file = virtualFile2;
        OutlinesService.Companion.getInstance(project3).generateOutlinesForFile(file, TriggerType.MANUAL);
    }
}

