/*
 * Decompiled with CFR 0.152.
 */
package com.google.tools.aiplugin.editor.prediction;

import com.google.tools.aiplugin.editor.prediction.Delta;
import com.google.tools.aiplugin.editor.prediction.Diff;
import com.google.tools.aiplugin.editor.prediction.DiffChunk;
import com.google.tools.aiplugin.editor.prediction.DiffLine;
import com.google.tools.aiplugin.editor.prediction.EditScript;
import com.google.tools.aiplugin.editor.prediction.EditScriptKt;
import com.google.tools.aiplugin.editor.prediction.LineAction;
import com.google.tools.aiplugin.editor.prediction.LineEdit;
import com.google.tools.aiplugin.editor.prediction.LineType;
import com.google.tools.aiplugin.editor.prediction.PathNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005J2\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ@\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u000e\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00100\u00050\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0016\u001a\u00020\bJ\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bJ\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00052\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b\u00a8\u0006 "}, d2={"Lcom/google/tools/aiplugin/editor/prediction/Differ;", "", "<init>", "()V", "shortestEditScript", "", "Lcom/google/tools/aiplugin/editor/prediction/Delta;", "a", "", "b", "backtrackPath", "endNode", "Lcom/google/tools/aiplugin/editor/prediction/PathNode;", "distance", "", "bestPairing", "Lkotlin/Pair;", "diffToEditScript", "Lcom/google/tools/aiplugin/editor/prediction/EditScript;", "diff", "Lcom/google/tools/aiplugin/editor/prediction/Diff;", "splitWithNewLines", "document", "tokenize", "text", "delimiters", "bestEditScript", "before", "after", "calculateLineActions", "Lcom/google/tools/aiplugin/editor/prediction/LineAction;", "PairingPath", "aiplugin.editor.prediction"})
@SourceDebugExtension(value={"SMAP\nDiffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Differ.kt\ncom/google/tools/aiplugin/editor/prediction/Differ\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,404:1\n1#2:405\n774#3:406\n865#3,2:407\n774#3:409\n865#3,2:410\n1573#3:412\n1604#3,4:413\n1563#3:417\n1634#3,3:418\n1563#3:421\n1634#3,3:422\n1869#3:425\n1563#3:426\n1634#3,3:427\n1870#3:430\n*S KotlinDebug\n*F\n+ 1 Differ.kt\ncom/google/tools/aiplugin/editor/prediction/Differ\n*L\n299#1:406\n299#1:407,2\n300#1:409\n300#1:410,2\n314#1:412\n314#1:413,4\n368#1:417\n368#1:418,3\n371#1:421\n371#1:422,3\n379#1:425\n393#1:426\n393#1:427,3\n379#1:430\n*E\n"})
public final class Differ {
    @NotNull
    public static final Differ INSTANCE = new Differ();

    private Differ() {
    }

    @NotNull
    public final List<Delta> shortestEditScript(@NotNull List<String> a, @NotNull List<String> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        int n = a.size();
        int m = b.size();
        int maxLen = n + m;
        int[] v = new int[maxLen * 2 + 2];
        Map pathMap = new LinkedHashMap();
        PathNode pathEndNode = null;
        int d = 0;
        if (d <= maxLen) {
            while (true) {
                int n2;
                int n3;
                int k;
                if ((k = (n3 = -d)) <= (n2 = ProgressionUtilKt.getProgressionLastElement((int)n3, (int)d, (int)2))) {
                    while (true) {
                        int currentY;
                        int vIndex = k + maxLen;
                        int x = k == -d || k != d && v[vIndex - 1] < v[vIndex + 1] ? v[vIndex + 1] : v[vIndex - 1] + 1;
                        int y = x - k;
                        int prevX = k == -d || k != d && v[vIndex - 1] < v[vIndex + 1] ? v[vIndex + 1] : v[vIndex - 1];
                        int prevK = x == prevX ? k + 1 : k - 1;
                        PathNode prevPathNode = (PathNode)pathMap.get(prevK + maxLen);
                        int currentX = x;
                        PathNode currentPathNode = new PathNode(currentX, currentY, prevPathNode);
                        for (currentY = y; currentX < n && currentY < m && Intrinsics.areEqual((Object)a.get(currentX), (Object)b.get(currentY)); ++currentX, ++currentY) {
                        }
                        v[vIndex] = currentX;
                        pathMap.put(vIndex, new PathNode(currentX, currentY, currentPathNode));
                        if (currentX >= n && currentY >= m) {
                            pathEndNode = (PathNode)pathMap.get(vIndex);
                            break;
                        }
                        if (k == n2) break;
                        k += 2;
                    }
                }
                if (pathEndNode != null || d == maxLen) break;
                ++d;
            }
        }
        PathNode pathNode = pathEndNode;
        Intrinsics.checkNotNull(pathNode);
        return this.backtrackPath(pathNode, a, b);
    }

    private final List<Delta> backtrackPath(PathNode endNode, List<String> a, List<String> b) {
        List deltas;
        block10: {
            Delta delta;
            List path2 = new ArrayList();
            PathNode currentNode = endNode;
            while (currentNode != null) {
                path2.add(currentNode);
                PathNode previous = currentNode.getPreviousPath();
                if (previous != null && Math.abs(currentNode.getX() - previous.getX()) > 1) {
                    currentNode = new PathNode(previous.getX(), previous.getY(), previous.getPreviousPath());
                    continue;
                }
                currentNode = previous;
            }
            CollectionsKt.reverse((List)path2);
            int x = 0;
            int y = 0;
            deltas = new ArrayList();
            int offset2 = 0;
            Delta delta2 = null;
            int n = path2.size();
            for (int i2 = 1; i2 < n; ++i2) {
                PathNode nextNode = (PathNode)path2.get(i2);
                int nextX = nextNode.getX();
                int nextY = nextNode.getY();
                if (nextX > x && nextY == y) {
                    Delta delta3 = delta2;
                    if (delta3 == null) {
                        delta3 = new Delta(offset2, "", "");
                    }
                    delta2 = delta3;
                    delta2 = new Delta(delta2.getOffset(), delta2.getBefore() + a.get(x), delta2.getAfter());
                    offset2 += a.get(x).length();
                    ++x;
                } else if (nextX == x && nextY > y) {
                    Delta delta4 = delta2;
                    if (delta4 == null) {
                        delta4 = new Delta(offset2, "", "");
                    }
                    delta2 = delta4;
                    delta2 = new Delta(delta2.getOffset(), delta2.getBefore(), delta2.getAfter() + b.get(y));
                    ++y;
                }
                while (x < nextX && y < nextY && Intrinsics.areEqual((Object)a.get(x), (Object)b.get(y))) {
                    if (delta2 != null) {
                        Delta delta5;
                        Delta it = delta5;
                        boolean bl = false;
                        deltas.add(it);
                    }
                    delta2 = null;
                    offset2 += a.get(x).length();
                    ++x;
                    ++y;
                }
            }
            Delta delta6 = delta2;
            if (delta6 == null) break block10;
            Delta it = delta = delta6;
            boolean bl = false;
            deltas.add(it);
        }
        return deltas;
    }

    public final int distance(@NotNull String a, @NotNull String b) {
        int j;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int n = a.length();
        int m = b.length();
        int n2 = 0;
        int n3 = n + 1;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            nArrayArray[n4] = new int[m + 1];
        }
        int[][] dp = nArrayArray;
        int i2 = 0;
        if (i2 <= n) {
            while (true) {
                dp[i2][0] = i2;
                if (i2 == n) break;
                ++i2;
            }
        }
        if ((j = 0) <= m) {
            while (true) {
                dp[0][j] = j;
                if (j == m) break;
                ++j;
            }
        }
        if ((i2 = 1) <= n) {
            while (true) {
                int j2;
                if ((j2 = 1) <= m) {
                    while (true) {
                        int cost = a.charAt(i2 - 1) == b.charAt(j2 - 1) ? 0 : 1;
                        dp[i2][j2] = Math.min(dp[i2 - 1][j2] + 1, Math.min(dp[i2][j2 - 1] + 1, dp[i2 - 1][j2 - 1] + cost));
                        if (j2 == m) break;
                        ++j2;
                    }
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return dp[n][m];
    }

    @NotNull
    public final Pair<Integer, List<Pair<Integer, Integer>>> bestPairing(@NotNull List<String> a, @NotNull List<String> b) {
        int j;
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        int m = a.size();
        int n = b.size();
        int n2 = 0;
        int n3 = m + 1;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            nArrayArray[n4] = new int[n + 1];
        }
        int[][] dp = nArrayArray;
        int n5 = m + 1;
        Pair pair = new PairingPath[n5][];
        for (n3 = 0; n3 < n5; ++n3) {
            int n6 = n3;
            int n7 = 0;
            int n8 = n + 1;
            PairingPath[] pairingPathArray = new PairingPath[n8];
            int n9 = n6;
            Pair pair2 = pair;
            while (n7 < n8) {
                int n10 = n7++;
                pairingPathArray[n10] = PairingPath.NONE;
            }
            pair2[n9] = pairingPathArray;
        }
        Pair path2 = pair;
        int i2 = 0;
        if (i2 <= m) {
            while (true) {
                dp[i2][0] = 0;
                path2[i2][0] = PairingPath.SKIP_A;
                if (i2 == m) break;
                ++i2;
            }
        }
        if ((j = 0) <= n) {
            while (true) {
                dp[0][j] = 0;
                path2[0][j] = PairingPath.SKIP_B;
                if (j == n) break;
                ++j;
            }
        }
        if ((i2 = 1) <= m) {
            while (true) {
                int n1;
                int d;
                int n0;
                int j2;
                if ((j2 = (n0 = ((Number)(pair = (d = m - n) > 0 ? TuplesKt.to((Object)Math.max(1, i2 - d), (Object)Math.min(i2, n)) : TuplesKt.to((Object)i2, (Object)Math.min(i2 - d, n))).component1()).intValue())) <= (n1 = ((Number)pair.component2()).intValue())) {
                    while (true) {
                        int match;
                        dp[i2][j2] = match = this.distance(a.get(i2 - 1), b.get(j2 - 1)) + dp[i2 - 1][j2 - 1];
                        path2[i2][j2] = PairingPath.MATCH;
                        if (i2 > j2) {
                            if (dp[i2 - 1][j2] < match) {
                                if (!(path2[i2 - 1][j2] != PairingPath.NONE)) {
                                    throw new IllegalStateException("Check failed.");
                                }
                                dp[i2][j2] = dp[i2 - 1][j2];
                                path2[i2][j2] = PairingPath.SKIP_A;
                            }
                        } else if (j2 > i2 && dp[i2][j2 - 1] < match) {
                            if (!(path2[i2][j2 - 1] != PairingPath.NONE)) {
                                throw new IllegalStateException("Check failed.");
                            }
                            dp[i2][j2] = dp[i2][j2 - 1];
                            path2[i2][j2] = PairingPath.SKIP_B;
                        }
                        if (j2 == n1) break;
                        ++j2;
                    }
                }
                if (i2 == m) break;
                ++i2;
            }
        }
        int maxScore = dp[m][n];
        List ret = new ArrayList();
        int i3 = m;
        int j3 = n;
        block12: while (i3 != 0 && j3 != 0) {
            switch (WhenMappings.$EnumSwitchMapping$0[path2[i3][j3].ordinal()]) {
                case 1: {
                    --i3;
                    continue block12;
                }
                case 2: {
                    --j3;
                    continue block12;
                }
                case 3: {
                    ret.add(new Pair((Object)(i3 - 1), (Object)(j3 - 1)));
                    --i3;
                    --j3;
                    continue block12;
                }
            }
            boolean bl = false;
            String string = "Invalid path type";
            throw new IllegalStateException(string.toString());
        }
        return new Pair((Object)maxScore, (Object)CollectionsKt.reversed((Iterable)ret));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EditScript diffToEditScript(@NotNull Diff diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        List edits = new ArrayList();
        for (DiffChunk chunk : diff.getChunks()) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = chunk.getLines();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                DiffLine it = (DiffLine)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() != LineType.ADDED)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String before = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, Differ::diffToEditScript$lambda$4, (int)30, null);
            Iterable $this$filter$iv2 = chunk.getLines();
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DiffLine it = (DiffLine)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() != LineType.REMOVED)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            String after = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"", null, null, (int)0, null, Differ::diffToEditScript$lambda$6, (int)30, null);
            EditScript es = this.bestEditScript(before, after);
            for (LineEdit edit : es.getEdits()) {
                int line = edit.getLine() + chunk.getOldStart() - 1;
                edits.add(new LineEdit(line, edit.getAction()));
            }
        }
        return new EditScript(edits);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> splitWithNewLines(@NotNull String document2) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        List rawLines = StringsKt.lines((CharSequence)document2);
        Iterable $this$mapIndexed$iv = rawLines;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void s;
            void i2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(i2 < rawLines.size() - 1 ? (String)s + "\n" : s);
        }
        List lines = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (Intrinsics.areEqual((Object)CollectionsKt.last((List)rawLines), (Object)"")) {
            lines.removeLast();
        }
        return lines;
    }

    @NotNull
    public final List<String> tokenize(@NotNull String text2, @NotNull String delimiters) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)delimiters, (String)"delimiters");
        if (((CharSequence)text2).length() == 0) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        Set delimiterSet = StringsKt.toSet((CharSequence)delimiters);
        int startIndex = 0;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            boolean isDelimiter = delimiterSet.contains(Character.valueOf(text2.charAt(i2)));
            if (!isDelimiter) continue;
            String string = text2.substring(startIndex, i2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result2.add(string);
            String string2 = text2.substring(i2, i2 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            result2.add(string2);
            startIndex = i2 + 1;
        }
        if (startIndex < text2.length()) {
            String string = text2.substring(startIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result2.add(string);
        }
        return result2;
    }

    @NotNull
    public final EditScript bestEditScript(@NotNull String before, @NotNull String after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        List<LineAction> actions2 = this.calculateLineActions(before, after);
        List edits = new ArrayList();
        int line = 1;
        for (LineAction action : actions2) {
            if (!(action instanceof LineAction.Edit) || !((LineAction.Edit)action).getDeltas().isEmpty()) {
                edits.add(new LineEdit(line, action));
            }
            if (action instanceof LineAction.Add) continue;
            ++line;
        }
        return new EditScript(edits);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LineAction> calculateLineActions(@NotNull String before, @NotNull String after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        List<String> a = null;
        a = this.splitWithNewLines(before);
        List<String> b = null;
        b = this.splitWithNewLines(after);
        List suffix = CollectionsKt.emptyList();
        int gap = 100;
        if (a.size() > b.size() + gap) {
            $this$map$iv = a.subList(b.size() + gap, a.size());
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                var37_17 = destination$iv$iv;
                boolean bl = false;
                var37_17.add(new LineAction.Delete(it));
            }
            suffix = (List)destination$iv$iv;
            a = a.subList(0, b.size() + gap);
        } else if (b.size() > a.size() + gap) {
            $this$map$iv = b.subList(a.size() + gap, b.size());
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                var37_17 = destination$iv$iv;
                boolean bl = false;
                var37_17.add(new LineAction.Add(it));
            }
            suffix = (List)destination$iv$iv;
            b = b.subList(0, a.size() + gap);
        }
        List pairs = (List)this.bestPairing(a, b).component2();
        List lines = new ArrayList();
        int n = 0;
        int m = 0;
        Iterable $this$forEach$iv = pairs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<Delta> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int n2;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int x = ((Number)pair.component1()).intValue();
            int y = ((Number)pair.component2()).intValue();
            while (n < x) {
                n2 = n;
                n = n2 + 1;
                lines.add(new LineAction.Delete(a.get(n2)));
            }
            while (m < y) {
                n2 = m;
                m = n2 + 1;
                lines.add(new LineAction.Add(b.get(n2)));
            }
            int n3 = n;
            n = n3 + 1;
            String l2 = a.get(n3);
            int n4 = m;
            m = n4 + 1;
            String r = b.get(n4);
            String delimiters = " (){}\t\n";
            List<Delta> es = INSTANCE.shortestEditScript(INSTANCE.tokenize(l2, delimiters), INSTANCE.tokenize(r, delimiters));
            Iterable iterable = es;
            String string = r;
            String string2 = l2;
            List list = lines;
            boolean $i$f$map = false;
            void var29_39 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Delta delta = (Delta)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(EditScriptKt.refine((Delta)it));
            }
            Collection<Delta> collection2 = collection = (List)destination$iv$iv;
            String string3 = string;
            String string4 = string2;
            list.add(new LineAction.Edit(string4, string3, (List<Delta>)collection2));
        }
        while (n < a.size()) {
            int n5 = n;
            n = n5 + 1;
            lines.add(new LineAction.Delete(a.get(n5)));
        }
        while (m < b.size()) {
            int n6 = m;
            m = n6 + 1;
            lines.add(new LineAction.Add(b.get(n6)));
        }
        return CollectionsKt.plus((Collection)lines, (Iterable)suffix);
    }

    private static final CharSequence diffToEditScript$lambda$4(DiffLine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContent();
    }

    private static final CharSequence diffToEditScript$lambda$6(DiffLine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContent();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/google/tools/aiplugin/editor/prediction/Differ$PairingPath;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "SKIP_A", "SKIP_B", "MATCH", "aiplugin.editor.prediction"})
    private static final class PairingPath
    extends Enum<PairingPath> {
        public static final /* enum */ PairingPath NONE = new PairingPath();
        public static final /* enum */ PairingPath SKIP_A = new PairingPath();
        public static final /* enum */ PairingPath SKIP_B = new PairingPath();
        public static final /* enum */ PairingPath MATCH = new PairingPath();
        private static final /* synthetic */ PairingPath[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PairingPath[] values() {
            return (PairingPath[])$VALUES.clone();
        }

        public static PairingPath valueOf(String value) {
            return Enum.valueOf(PairingPath.class, value);
        }

        @NotNull
        public static EnumEntries<PairingPath> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pairingPathArray = new PairingPath[]{PairingPath.NONE, PairingPath.SKIP_A, PairingPath.SKIP_B, PairingPath.MATCH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PairingPath.values().length];
            try {
                nArray[PairingPath.SKIP_A.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PairingPath.SKIP_B.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PairingPath.MATCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

