/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ThreadUtil {
    private static final ThreadUtil INSTANCE = new ThreadUtil();
    private ListeningExecutorService backgroundExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());

    private ThreadUtil() {
    }

    public static ThreadUtil getInstance() {
        return INSTANCE;
    }

    public <T> ListenableFuture<T> executeInBackground(Callable<T> callable) {
        return this.backgroundExecutorService.submit(callable);
    }

    public ListenableFuture<?> executeInBackground(Runnable runnable) {
        return this.backgroundExecutorService.submit(runnable);
    }

    public void executeInBackgroundWithoutFuture(Runnable runnable) {
        this.backgroundExecutorService.execute(runnable);
    }

    @VisibleForTesting
    public void setBackgroundExecutorService(ExecutorService backgroundExecutorService) {
        this.backgroundExecutorService = MoreExecutors.listeningDecorator((ExecutorService)backgroundExecutorService);
    }
}

