/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/google/cloud/tools/intellij/util/SystemUtils;", "", "<init>", "()V", "isArm64", "", "isIntel64", "isMac", "isM1Mac", "isRosetta2Installed", "aiplugin.cloudcode-core"})
public final class SystemUtils {
    @NotNull
    public static final SystemUtils INSTANCE = new SystemUtils();

    private SystemUtils() {
    }

    public final boolean isArm64() {
        return Intrinsics.areEqual((Object)"aarch64", (Object)SystemInfo.OS_ARCH) || Intrinsics.areEqual((Object)"arm64", (Object)SystemInfo.OS_ARCH);
    }

    public final boolean isIntel64() {
        return Intrinsics.areEqual((Object)"x86_64", (Object)SystemInfo.OS_ARCH) || Intrinsics.areEqual((Object)"amd64", (Object)SystemInfo.OS_ARCH);
    }

    public final boolean isMac() {
        return SystemInfo.isMac;
    }

    public final boolean isM1Mac() {
        return this.isArm64() && this.isMac();
    }

    public final boolean isRosetta2Installed() {
        return this.isM1Mac() && new File("/Library/Apple/usr/share/rosetta").exists();
    }
}

