/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.project;

import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.cloud.tools.intellij.IntellijPluginCoreMessageBundle;
import com.google.cloud.tools.intellij.analytics.UsageTrackerBase;
import com.google.cloud.tools.intellij.login.CredentialedUser;
import com.google.cloud.tools.intellij.login.GoogleLoginListener;
import com.google.cloud.tools.intellij.login.ui.GoogleLoginIcons;
import com.google.cloud.tools.intellij.project.AccountComboBoxRenderer;
import com.google.cloud.tools.intellij.project.CloudProject;
import com.google.cloud.tools.intellij.project.FilteredTextTableCellRenderer;
import com.google.cloud.tools.intellij.project.ProjectListTableModel;
import com.google.cloud.tools.intellij.project.ProjectLoader;
import com.google.cloud.tools.intellij.project.ProjectSelectorSignInPanel;
import com.google.cloud.tools.intellij.ui.components.TableUtilKt;
import com.google.cloud.tools.intellij.util.DebouncedDocumentAdapter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectSelectionDialogBase {
    private JComboBox<CredentialedUser> accountComboBox;
    private JTextField filterTextField;
    private JTable projectListTable;
    private JPanel centerPanel;
    protected ProjectSelectionDialogWrapper dialogWrapper;
    private JPanel centerPanelWrapper;
    protected ProjectSelectorSignInPanel signInScreen = new ProjectSelectorSignInPanel(this.getSignInText());
    private RefreshAction refreshAction;
    private ProjectListTableModel projectListTableModel;
    private JProgressBar progressBar;
    private ProjectLoader projectLoader = new ProjectLoader();
    private final Map<String, ProjectLoaderJob> runningProjectLoaderJobs = Maps.newHashMap();
    private final Map<String, String> selectedProjectsByAccount = Maps.newHashMap();
    private final Map<String, List<Project>> cachedProjectList = Maps.newHashMap();
    protected com.intellij.openapi.project.Project ideProject;
    protected boolean updateLoginProgressBarState = true;

    public ProjectSelectionDialogBase() {
        this.setup();
    }

    public void clearCachedProjectList() {
        this.cachedProjectList.clear();
    }

    public abstract CredentialedUser getActiveUser();

    public abstract Optional<CredentialedUser> getLoggedInUser(String var1);

    public abstract boolean isLoggedIn();

    public abstract Map<String, CredentialedUser> getAllUsers();

    public abstract boolean isRunningOnCloudWorkstation();

    public abstract void showStatusAndDisableLogInUntilDependenciesReady();

    public abstract boolean areDependenciesForLoginReady();

    public abstract void logInWithProgress(com.intellij.openapi.project.Project var1, Runnable var2, Runnable var3);

    public abstract String getLoginErrorMessage();

    public abstract UsageTrackerBase.PingsAnalytics trackEvent(String var1, Map<String, String> var2);

    protected String getOkButtonText(boolean isSignedIn) {
        String message = isSignedIn ? IntellijPluginCoreMessageBundle.message("login.panel.sign.in.button.text.ok", new Object[0]) : IntellijPluginCoreMessageBundle.message("login.panel.sign.in.button.text", new Object[0]);
        return message;
    }

    protected String getSignInText() {
        return IntellijPluginCoreMessageBundle.message("cloud.project.selector.signin.message", new Object[0]);
    }

    private void setup() {
        this.createUIComponents();
        this.centerPanel = new JPanel((LayoutManager)new MigLayout("insets 0, fillx, hidemode 3", "[left][grow][left]"));
        this.centerPanel.setMinimumSize(new Dimension(500, 200));
        this.centerPanel.setPreferredSize(new Dimension(700, 500));
        JLabel accountLabel = new JLabel(IntellijPluginCoreMessageBundle.message("cloud.project.selector.dialog.account.label", new Object[0]));
        this.centerPanel.add(accountLabel);
        this.centerPanel.add(this.accountComboBox, "growx, wrap");
        JLabel searchLabel = new JLabel(IntellijPluginCoreMessageBundle.message("cloud.project.selector.dialog.search.label", new Object[0]));
        this.centerPanel.add(searchLabel);
        this.centerPanel.add((Component)this.filterTextField, "growx, wrap");
        JBScrollPane projectScrollPane = new JBScrollPane();
        projectScrollPane.setViewportView(this.projectListTable);
        this.centerPanel.add((Component)projectScrollPane, "span, pushy, grow");
    }

    @Nullable
    public CloudProject showDialog(@Nullable CloudProject cloudProject, @Nullable com.intellij.openapi.project.Project ideProject) {
        this.ideProject = ideProject;
        this.signInScreen = new ProjectSelectorSignInPanel(this.getSignInText());
        if (this.dialogWrapper == null) {
            boolean isSignedIn = this.isLoggedIn();
            this.dialogWrapper = new ProjectSelectionDialogWrapper(isSignedIn);
            this.dialogWrapper.setTitle(IntellijPluginCoreMessageBundle.getString("cloud.project.selector.dialog.title", new Object[0]));
            this.installTableSpeedSearch(this.projectListTable);
            this.installProgressBar(this.dialogWrapper);
            ApplicationManager.getApplication().getMessageBus().connect(this.dialogWrapper.getDisposable()).subscribe(GoogleLoginListener.GOOGLE_LOGIN_LISTENER_TOPIC, () -> {
                CredentialedUser user = this.getActiveUser();
                this.refreshDialog(user);
                this.dialogWrapper.updateOkButtonUiState(user != null);
            });
            this.filterTextField.getDocument().addDocumentListener((DocumentListener)((Object)new DebouncedDocumentAdapter(this.dialogWrapper.getDisposable()){

                @Override
                protected void debouncedTextChanged(DocumentEvent e) {
                    ProjectSelectionDialogBase.this.cancelCurrentUserRunningJob();
                    ProjectSelectionDialogBase.this.loadAllProjects();
                }
            }));
        }
        this.clearCachedProjectList();
        this.loadAllProjects();
        this.setSelectedProject(cloudProject);
        this.dialogWrapper.show();
        int result2 = this.dialogWrapper.getExitCode();
        if (result2 == 0) {
            this.trackEvent("cloudcode.project.selection", Collections.emptyMap()).ping();
            return this.getSelectedProject();
        }
        return null;
    }

    @VisibleForTesting
    void setSelectedProject(CloudProject cloudProject) {
        if (cloudProject != null && !Strings.isNullOrEmpty((String)cloudProject.googleUsername())) {
            Optional<CredentialedUser> loggedInUser = this.getLoggedInUser(cloudProject.googleUsername());
            if (loggedInUser.isPresent()) {
                this.selectedProjectsByAccount.put(loggedInUser.get().getEmail(), cloudProject.projectName());
                this.accountComboBox.setSelectedItem(loggedInUser.get());
            }
        } else {
            this.accountComboBox.setSelectedItem(this.getActiveUser());
        }
    }

    @VisibleForTesting
    CloudProject getSelectedProject() {
        CredentialedUser user = this.accountComboBox.getItemAt(this.accountComboBox.getSelectedIndex());
        return CloudProject.Companion.create(this.getSelectedProjectName(), this.getSelectedProjectId(), this.getSelectedProjectNumber(), user.getEmail());
    }

    @VisibleForTesting
    void loadAllProjects() {
        Collection<CredentialedUser> credentialedUsers = this.getAllUsers().values();
        if (credentialedUsers.isEmpty()) {
            this.showSignInRequest();
        } else {
            this.hideSignInRequest();
            this.accountComboBox.removeAllItems();
            String filter2 = this.filterTextField.getText();
            for (CredentialedUser user : credentialedUsers) {
                this.accountComboBox.addItem(user);
                this.loadProjectList(user, filter2);
            }
        }
    }

    private void loadProjectList(final CredentialedUser user, String filter2) {
        final String cachedProjectListKey = String.join((CharSequence)"_", user.getEmail(), filter2);
        if (!this.cachedProjectList.containsKey(cachedProjectListKey) && this.runningProjectLoaderJobs.get(user.getEmail()) == null) {
            this.trackEvent("cloudcode.project.list.start", Collections.emptyMap()).ping();
            AtomicBoolean cancelled = new AtomicBoolean(false);
            ListenableFuture<List<Project>> futureResult = this.projectLoader.loadUserProjectsInBackground(user, filter2, cancelled);
            this.runningProjectLoaderJobs.put(user.getEmail(), new ProjectLoaderJob(futureResult, cancelled));
            this.addProjectListFutureCallback(futureResult, new FutureCallback<List<Project>>(){

                public void onSuccess(List<Project> projects) {
                    SwingUtilities.invokeLater(() -> {
                        ProjectSelectionDialogBase.this.runningProjectLoaderJobs.remove(user.getEmail());
                        ProjectSelectionDialogBase.this.cachedProjectList.put(cachedProjectListKey, projects);
                        ProjectSelectionDialogBase.this.refreshProjectListUi(user);
                    });
                    ProjectSelectionDialogBase.this.trackEvent("cloudcode.project.list.end", (Map<String, String>)ImmutableMap.of()).ping();
                }

                public void onFailure(@NotNull Throwable throwable) {
                    if (throwable instanceof CancellationException) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        ProjectSelectionDialogBase.this.runningProjectLoaderJobs.remove(user.getEmail());
                        String errorMessage = Optional.ofNullable(throwable.getMessage()).orElse(throwable.getClass().getName());
                        ProjectSelectionDialogBase.this.dialogWrapper.setErrorText(errorMessage, ProjectSelectionDialogBase.this.projectListTable);
                        ProjectSelectionDialogBase.this.refreshProjectListUi(user);
                    });
                    ProjectSelectionDialogBase.this.trackEvent("cloudcode.project.list.end", Collections.singletonMap("success", Boolean.FALSE.toString())).ping();
                }
            });
            this.refreshProjectListUi(user);
        } else {
            this.refreshProjectListUi(user);
        }
    }

    @VisibleForTesting
    void refreshDialog(@Nullable CredentialedUser userToSelect) {
        this.clearCachedProjectList();
        this.loadAllProjects();
        this.accountComboBox.setSelectedItem(userToSelect);
    }

    private void refreshProjectListUi(@Nullable CredentialedUser user) {
        if (user != null && user.getEmail().equals(Optional.ofNullable(this.accountComboBox.getItemAt(this.accountComboBox.getSelectedIndex())).map(CredentialedUser::getEmail).orElse(null))) {
            String filter2 = this.filterTextField.getText();
            String cachedProjectListKey = String.join((CharSequence)"_", user.getEmail(), filter2);
            if (this.cachedProjectList.containsKey(cachedProjectListKey)) {
                this.setLoading(false);
                this.projectListTableModel.setProjectList(this.cachedProjectList.get(cachedProjectListKey));
                this.showProjectInList(this.selectedProjectsByAccount.get(user.getEmail()));
            } else {
                this.projectListTableModel.setProjectList(Collections.emptyList());
            }
            if (this.runningProjectLoaderJobs.get(user.getEmail()) != null) {
                this.setLoading(true);
            }
        }
    }

    @VisibleForTesting
    void setLoading(boolean loading) {
        TableUtilKt.configureEmptyText((JBTable)this.projectListTable, loading, IntellijPluginCoreMessageBundle.message("table.default.loading", new Object[0]), IntellijPluginCoreMessageBundle.message("table.default.empty", new Object[0]));
        this.progressBar.setVisible(loading);
        int progressBarLength = 150;
        this.progressBar.setBounds(this.dialogWrapper.getSize().width / 2 - progressBarLength / 2, this.dialogWrapper.getSize().height / 2, progressBarLength, this.progressBar.getPreferredSize().height);
    }

    @VisibleForTesting
    void createUIComponents() {
        this.projectListTable = new JBTable();
        this.projectListTableModel = new ProjectListTableModel();
        this.projectListTable.setModel(this.projectListTableModel);
        this.projectListTable.setSelectionMode(0);
        this.projectListTable.getSelectionModel().addListSelectionListener(e -> this.validateProjectSelection());
        FilteredTextTableCellRenderer filterRenderer = new FilteredTextTableCellRenderer();
        this.projectListTable.setDefaultRenderer(Object.class, filterRenderer);
        DoubleClickListener tableDoubleClickListener = new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                ProjectSelectionDialogBase.this.dialogWrapper.clickDefaultButton();
                return true;
            }
        };
        tableDoubleClickListener.installOn((Component)this.projectListTable);
        this.filterTextField = new JBTextField();
        TableRowSorter<ProjectListTableModel> sorter = new TableRowSorter<ProjectListTableModel>(this.projectListTableModel);
        this.projectListTable.setRowSorter(sorter);
        this.refreshAction = new RefreshAction();
        this.accountComboBox = new ComboBox();
        this.accountComboBox.setRenderer((ListCellRenderer<CredentialedUser>)((Object)new AccountComboBoxRenderer()));
        this.accountComboBox.addActionListener(event -> this.refreshProjectListUi((CredentialedUser)this.accountComboBox.getSelectedItem()));
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        this.centerPanelWrapper = new JPanel(new BorderLayout());
    }

    @VisibleForTesting
    void installTableSpeedSearch(JTable projectListTable) {
        new TableSpeedSearch(projectListTable){

            protected void selectElement(Object element, String selectedText) {
                super.selectElement(element, selectedText);
                ProjectSelectionDialogBase.this.filterTextField.setText(selectedText);
            }
        };
    }

    private void installProgressBar(ProjectSelectionDialogWrapper dialogWrapper) {
        dialogWrapper.getRootPane().getLayeredPane().add((Component)this.progressBar, JLayeredPane.DRAG_LAYER);
    }

    private void showSignInRequest() {
        this.centerPanelWrapper.removeAll();
        this.centerPanelWrapper.add(this.signInScreen);
        Optional.ofNullable(this.getDialogButton(this.refreshAction)).ifPresent(b -> b.setVisible(false));
        this.dialogWrapper.validate();
    }

    private void hideSignInRequest() {
        if (!this.centerPanel.isShowing()) {
            this.centerPanelWrapper.removeAll();
            this.centerPanelWrapper.add(this.centerPanel);
            Optional.ofNullable(this.getDialogButton(this.refreshAction)).ifPresent(b -> b.setVisible(true));
            this.dialogWrapper.validate();
            this.dialogWrapper.pack();
        }
    }

    private void validateProjectSelection() {
        int selectedRow = this.projectListTable.getSelectedRow();
        int visibleRowCount = this.projectListTable.getRowSorter().getViewRowCount();
        if (selectedRow >= 0 && selectedRow < visibleRowCount) {
            this.dialogWrapper.setOKActionEnabled(true);
            this.selectedProjectsByAccount.put(((CredentialedUser)this.accountComboBox.getSelectedItem()).getEmail(), this.getSelectedProjectName());
        } else if (selectedRow < 0) {
            this.dialogWrapper.setOKActionEnabled(false);
            this.selectedProjectsByAccount.remove(((CredentialedUser)this.accountComboBox.getSelectedItem()).getEmail());
        }
    }

    @VisibleForTesting
    void showProjectInList(String projectName) {
        for (int i2 = 0; i2 < this.projectListTableModel.getRowCount(); ++i2) {
            String projectNameAtRow = this.projectListTableModel.getProjectNameAtRow(i2);
            if (!projectNameAtRow.equals(projectName)) continue;
            this.projectListTable.getSelectionModel().setSelectionInterval(i2, i2);
            this.projectListTable.scrollRectToVisible(this.projectListTable.getCellRect(i2, 0, true));
            break;
        }
    }

    @VisibleForTesting
    String getSelectedProjectName() {
        int actualSelectedRow = this.projectListTable.getRowSorter().convertRowIndexToModel(this.projectListTable.getSelectedRow());
        return this.projectListTableModel.getProjectNameAtRow(actualSelectedRow);
    }

    @VisibleForTesting
    String getSelectedProjectId() {
        int actualSelectedRow = this.projectListTable.getRowSorter().convertRowIndexToModel(this.projectListTable.getSelectedRow());
        return this.projectListTableModel.getProjectIdAtRow(actualSelectedRow);
    }

    @VisibleForTesting
    Long getSelectedProjectNumber() {
        int actualSelectedRow = this.projectListTable.getRowSorter().convertRowIndexToModel(this.projectListTable.getSelectedRow());
        return this.projectListTableModel.getProjectNumberAtRow(actualSelectedRow);
    }

    @VisibleForTesting
    JButton getDialogButton(@NotNull Action action) {
        return this.dialogWrapper.getButton(action);
    }

    @VisibleForTesting
    JComboBox<CredentialedUser> getAccountComboBox() {
        return this.accountComboBox;
    }

    @VisibleForTesting
    JTable getProjectListTable() {
        return this.projectListTable;
    }

    @VisibleForTesting
    ProjectListTableModel getProjectListTableModel() {
        return this.projectListTableModel;
    }

    @VisibleForTesting
    JPanel getCenterPanelWrapper() {
        return this.centerPanelWrapper;
    }

    @VisibleForTesting
    void setProjectLoader(ProjectLoader projectLoader) {
        this.projectLoader = projectLoader;
    }

    @VisibleForTesting
    void setDialogWrapper(ProjectSelectionDialogWrapper dialogWrapper) {
        this.dialogWrapper = dialogWrapper;
    }

    @VisibleForTesting
    void addProjectListFutureCallback(ListenableFuture<List<Project>> future, FutureCallback<List<Project>> callback2) {
        Futures.addCallback(future, callback2, (Executor)MoreExecutors.directExecutor());
    }

    private boolean checkForWorkstationsLoginFlow() {
        if (this.isRunningOnCloudWorkstation()) {
            this.dialogWrapper.doCancelAction();
            this.logInWithProgress(this.ideProject, () -> {}, () -> {});
            return true;
        }
        return false;
    }

    private void cancelCurrentUserRunningJob() {
        CredentialedUser user = this.getActiveUser();
        String userEmail = user.getEmail();
        ProjectLoaderJob runningJob = this.runningProjectLoaderJobs.get(userEmail);
        if (runningJob != null) {
            runningJob.future.cancel(false);
            runningJob.cancelled.set(true);
            this.runningProjectLoaderJobs.remove(userEmail);
        }
    }

    protected class ProjectSelectionDialogWrapper
    extends DialogWrapper {
        private boolean isSignedIn;

        private ProjectSelectionDialogWrapper(boolean isSignedIn) {
            super(false);
            this.init();
            this.updateOkButtonUiState(isSignedIn);
        }

        protected void updateOkButtonUiState(boolean isSignedIn) {
            this.isSignedIn = isSignedIn;
            this.setOKActionEnabled(!this.isSignedIn);
            this.setOKButtonText(ProjectSelectionDialogBase.this.getOkButtonText(this.isSignedIn));
        }

        protected void doOKAction() {
            if (!this.isSignedIn) {
                if (ProjectSelectionDialogBase.this.areDependenciesForLoginReady()) {
                    this.signIn();
                } else {
                    ProjectSelectionDialogBase.this.showStatusAndDisableLogInUntilDependenciesReady();
                }
            } else {
                super.doOKAction();
            }
        }

        public void doCancelAction() {
            ProjectSelectionDialogBase.this.updateLoginProgressBarState = false;
            ProjectSelectionDialogBase.this.cancelCurrentUserRunningJob();
            super.doCancelAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return ProjectSelectionDialogBase.this.centerPanelWrapper;
        }

        protected void setErrorText(@Nullable String text2, @Nullable JComponent component2) {
            if (!this.isDisposed()) {
                super.setErrorText(text2, component2);
            }
        }

        @NotNull
        protected Action[] createLeftSideActions() {
            return new Action[]{ProjectSelectionDialogBase.this.refreshAction};
        }

        public void setOKActionEnabled(boolean isEnabled) {
            super.setOKActionEnabled(isEnabled);
        }

        @Nullable
        protected JButton getButton(@NotNull Action action) {
            return super.getButton(action);
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return ProjectSelectionDialogBase.this.filterTextField;
        }

        private void signIn() {
            if (ProjectSelectionDialogBase.this.checkForWorkstationsLoginFlow()) {
                return;
            }
            this.setOKActionEnabled(false);
            ProjectSelectionDialogBase.this.signInScreen.hideErrorMessage();
            ProjectSelectionDialogBase.this.signInScreen.showProgressBar();
            ProjectSelectionDialogBase.this.logInWithProgress(ProjectSelectionDialogBase.this.ideProject, () -> {
                ProjectSelectionDialogBase.this.signInScreen.hideProgressBar();
                this.setOKButtonText(IntellijPluginCoreMessageBundle.message("login.panel.sign.in.button.text.ok", new Object[0]));
                this.isSignedIn = true;
                ProjectSelectionDialogBase.this.loadAllProjects();
            }, () -> {
                ProjectSelectionDialogBase.this.signInScreen.hideProgressBar();
                ProjectSelectionDialogBase.this.signInScreen.showErrorMessage(ProjectSelectionDialogBase.this.getLoginErrorMessage());
            });
        }
    }

    private static class ProjectLoaderJob {
        private final ListenableFuture<List<Project>> future;
        private final AtomicBoolean cancelled;

        private ProjectLoaderJob(ListenableFuture<List<Project>> future, AtomicBoolean cancelled) {
            this.future = future;
            this.cancelled = cancelled;
        }
    }

    private final class RefreshAction
    extends AbstractAction {
        private RefreshAction() {
            this.putValue("SmallIcon", GoogleLoginIcons.REFRESH);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProjectSelectionDialogBase.this.refreshDialog((CredentialedUser)ProjectSelectionDialogBase.this.accountComboBox.getSelectedItem());
        }
    }
}

