/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.login;

import com.google.cloud.developerexperience.cloudcode.intellij.auth.IntellijLoginClient;
import com.google.cloud.developerexperience.cloudcode.intellij.auth.LandingPages;
import com.google.cloud.tools.intellij.login.ByoidProviderKt;
import com.google.cloud.tools.intellij.login.ClientCredentialsKt;
import com.google.cloud.tools.intellij.util.CloudCodePlatform;
import com.google.cloud.tools.intellij.util.CommonDirectoryProvider;
import com.google.cloud.tools.intellij.util.PlatformsKt;
import com.intellij.ide.BrowserUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/google/cloud/tools/intellij/login/CloudCodeIntelliJLoginClient;", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/IntellijLoginClient;", "<init>", "()V", "browse", "", "url", "", "getCredentialStoragePath", "Ljava/nio/file/Path;", "getLandingPages", "Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/LandingPages;", "getOAuthClientId", "getOAuthClientNotSoSecret", "getByoidProviderName", "getByoidAuthUrl", "Companion", "aiplugin.cloudcode-core"})
public class CloudCodeIntelliJLoginClient
implements IntellijLoginClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DEFAULT_BYOID_AUTH_BASE_URL = "https://auth.cloud.google/authorize";

    public void browse(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        BrowserUtil.browse((String)url);
    }

    @NotNull
    public Path getCredentialStoragePath() {
        CloudCodePlatform cloudCodePlatform = PlatformsKt.currentPlatform();
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties(...)");
        Map<String, String> map2 = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getenv(...)");
        String[] stringArray = new String[]{"intellij"};
        Path path2 = Paths.get(((Object)CommonDirectoryProvider.INSTANCE.getPlatformSpecificDepsDir(cloudCodePlatform, properties, map2)).toString(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return path2;
    }

    @NotNull
    public LandingPages getLandingPages() {
        return new LandingPages("https://cloud.google.com/code/docs/intellij/auth_success", "https://cloud.google.com/code/docs/intellij/auth_failure");
    }

    @NotNull
    public String getOAuthClientId() {
        return ClientCredentialsKt.getOauthClientId();
    }

    @NotNull
    public String getOAuthClientNotSoSecret() {
        return ClientCredentialsKt.getOauthClientNotSoSecret();
    }

    @Nullable
    public String getByoidProviderName() {
        return ByoidProviderKt.isByoidEnabled() ? ByoidProviderKt.getWifProviderName() : null;
    }

    @Nullable
    public String getByoidAuthUrl() {
        if (!ByoidProviderKt.isByoidEnabled()) {
            return null;
        }
        String authUrl = ByoidProviderKt.getWifAuthUrl();
        CharSequence charSequence = authUrl;
        return charSequence == null || charSequence.length() == 0 ? DEFAULT_BYOID_AUTH_BASE_URL : authUrl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/google/cloud/tools/intellij/login/CloudCodeIntelliJLoginClient$Companion;", "", "<init>", "()V", "DEFAULT_BYOID_AUTH_BASE_URL", "", "aiplugin.cloudcode-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

