/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.intellij.analytics;

import com.google.cloud.tools.intellij.analytics.MetricWithMetadata;
import com.google.cloud.tools.intellij.analytics.MetricsFileType;
import com.google.cloud.tools.intellij.analytics.MetricsLocalDirectoryUtilKt;
import com.google.cloud.tools.intellij.analytics.firelog.EventMetadata;
import com.google.cloud.tools.intellij.analytics.firelog.SourceExtensionJson;
import com.google.gson.Gson;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/google/cloud/tools/intellij/analytics/MetricsLocalFileWriter;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "GSON", "Lcom/google/gson/Gson;", "writeToMetricsFile", "", "sourceExtensionJson", "Lcom/google/cloud/tools/intellij/analytics/firelog/SourceExtensionJson;", "metricsFileType", "Lcom/google/cloud/tools/intellij/analytics/MetricsFileType;", "writeToMetricsFileForRetry", "body", "", "fileLocation", "Ljava/nio/file/Path;", "writeToFile", "file", "Ljava/io/File;", "message", "aiplugin.cloudcode-core"})
@SourceDebugExtension(value={"SMAP\nMetricsLocalFileWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsLocalFileWriter.kt\ncom/google/cloud/tools/intellij/analytics/MetricsLocalFileWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1193#2,2:119\n1267#2,4:121\n1#3:125\n*S KotlinDebug\n*F\n+ 1 MetricsLocalFileWriter.kt\ncom/google/cloud/tools/intellij/analytics/MetricsLocalFileWriter\n*L\n62#1:119,2\n62#1:121,4\n*E\n"})
public class MetricsLocalFileWriter {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Gson GSON;

    public MetricsLocalFileWriter() {
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.GSON = new Gson();
    }

    public void writeToMetricsFile(@NotNull SourceExtensionJson sourceExtensionJson, @NotNull MetricsFileType metricsFileType) {
        block7: {
            String messageToLog;
            Intrinsics.checkNotNullParameter((Object)sourceExtensionJson, (String)"sourceExtensionJson");
            Intrinsics.checkNotNullParameter((Object)((Object)metricsFileType), (String)"metricsFileType");
            File file = MetricsLocalDirectoryUtilKt.getLocalMetricsFileLocation(metricsFileType);
            String eventName = sourceExtensionJson.getEventName();
            String string = messageToLog = (switch (WhenMappings.$EnumSwitchMapping$0[metricsFileType.ordinal()]) {
                case 1 -> "[" + eventName + "] - " + Instant.now() + "\n\n" + this.GSON.toJson((Object)sourceExtensionJson) + "\n--------------------\n";
                case 2 -> {
                    String $this$associate$iv;
                    try {
                        Map var20_20;
                        void $this$associateTo$iv$iv;
                        String v1 = sourceExtensionJson.getEventName();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getEventName(...)");
                        List<EventMetadata> v2 = sourceExtensionJson.getEventMetadata();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"getEventMetadata(...)");
                        Iterable var7_5 = v2;
                        String var19_7 = v1;
                        Gson var18_8 = this.GSON;
                        boolean $i$f$associate = false;
                        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associate$iv), (int)10)), (int)16);
                        String var10_12 = $this$associate$iv;
                        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                        boolean $i$f$associateTo = false;
                        for (Object element$iv$iv : $this$associateTo$iv$iv) {
                            Map var15_17 = destination$iv$iv;
                            EventMetadata it = (EventMetadata)element$iv$iv;
                            boolean $i$a$-associate-MetricsLocalFileWriter$writeToMetricsFile$messageToLog$1 = false;
                            Pair var16_18 = TuplesKt.to((Object)it.getKey(), (Object)it.getValue());
                            var15_17.put(var16_18.getFirst(), var16_18.getSecond());
                        }
                        Map var21_21 = var20_20 = destination$iv$iv;
                        String var22_22 = var19_7;
                        $this$associate$iv = var18_8.toJson((Object)new MetricWithMetadata(var22_22, var21_21)) + "\n";
                    }
                    catch (Exception e) {
                        $this$associate$iv = null;
                    }
                    yield $this$associate$iv;
                }
                default -> throw new NoWhenBranchMatchedException();
            });
            if (string == null) break block7;
            String it = string;
            boolean bl = false;
            this.writeToFile(file, it);
        }
    }

    @RequiresBackgroundThread
    public void writeToMetricsFileForRetry(@NotNull String body, @NotNull Path fileLocation) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)fileLocation, (String)"fileLocation");
        try {
            Path path2 = fileLocation.getParent();
            Intrinsics.checkNotNull((Object)path2);
            Files.createDirectories(path2, new FileAttribute[0]);
            Path path3 = fileLocation.getParent();
            Intrinsics.checkNotNull((Object)path3);
            Path tempFile = Files.createTempFile(path3, "tmp", "tmp", new FileAttribute[0]);
            CopyOption[] copyOptionArray = body;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = copyOptionArray.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Files.write(tempFile, byArray, new OpenOption[0]);
            copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(tempFile, fileLocation, copyOptionArray);
            this.logger.debug("Successfully stored logs for retry on disk.");
        }
        catch (IOException e) {
            this.logger.warn("Unable to save logs for retry to local file", (Throwable)e);
        }
    }

    private final void writeToFile(File file, String message) {
        try {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
            BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(file.getPath(), new String[0]), Charset.defaultCharset(), openOptionArray);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"newBufferedWriter(...)");
            Writer writer = bufferedWriter;
            writer.append(message);
            writer.close();
        }
        catch (IOException e) {
            this.logger.warn("Unable to save message to local file", (Throwable)e);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetricsFileType.values().length];
            try {
                nArray[MetricsFileType.LOCAL_TESTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricsFileType.UI_TEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

