/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.lucene;

import com.google.aiplugin.rag.lucene.LuceneIndexUtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.IdFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001 B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J!\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/google/aiplugin/rag/lucene/VirtualFileInScopeQuery;", "Lorg/apache/lucene/search/Query;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "idFilter", "Lcom/intellij/util/indexing/IdFilter;", "<init>", "(Lcom/intellij/psi/search/GlobalSearchScope;Lcom/intellij/util/indexing/IdFilter;)V", "createWeight", "Lorg/apache/lucene/search/ConstantScoreWeight;", "searcher", "Lorg/apache/lucene/search/IndexSearcher;", "scoreMode", "Lorg/apache/lucene/search/ScoreMode;", "boost", "", "toString", "", "field", "visit", "", "visitor", "Lorg/apache/lucene/search/QueryVisitor;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "FilesInScopeIterator", "aiplugin.rag.indexer"})
public final class VirtualFileInScopeQuery
extends Query {
    @Nullable
    private final GlobalSearchScope scope;
    @Nullable
    private final IdFilter idFilter;

    public VirtualFileInScopeQuery(@Nullable GlobalSearchScope scope2, @Nullable IdFilter idFilter) {
        this.scope = scope2;
        this.idFilter = idFilter;
        if (!(this.scope != null || this.idFilter != null)) {
            boolean bl = false;
            String string = "At least one of scope or idFilter must be provided";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ VirtualFileInScopeQuery(GlobalSearchScope globalSearchScope, IdFilter idFilter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            globalSearchScope = null;
        }
        if ((n & 2) != 0) {
            idFilter = null;
        }
        this(globalSearchScope, idFilter);
    }

    @NotNull
    public ConstantScoreWeight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)scoreMode, (String)"scoreMode");
        return new ConstantScoreWeight(this, boost, scoreMode){
            final /* synthetic */ VirtualFileInScopeQuery this$0;
            final /* synthetic */ ScoreMode $scoreMode;
            {
                this.this$0 = $receiver;
                this.$scoreMode = $scoreMode;
                super((Query)$receiver, $boost);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                return false;
            }

            public ConstantScoreScorer scorer(LeafReaderContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Weight weight = (Weight)this;
                float f = this.score();
                LeafReader leafReader = ctx.reader();
                Intrinsics.checkNotNullExpressionValue((Object)leafReader, (String)"reader(...)");
                return new ConstantScoreScorer(weight, f, this.$scoreMode, (TwoPhaseIterator)this.this$0.new FilesInScopeIterator(leafReader));
            }
        };
    }

    @NotNull
    public String toString(@NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return "InScope(" + this.scope + ", filter = " + this.idFilter + ")";
    }

    public void visit(@NotNull QueryVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.visitLeaf((Query)this);
    }

    private final GlobalSearchScope component1() {
        return this.scope;
    }

    private final IdFilter component2() {
        return this.idFilter;
    }

    @NotNull
    public final VirtualFileInScopeQuery copy(@Nullable GlobalSearchScope scope2, @Nullable IdFilter idFilter) {
        return new VirtualFileInScopeQuery(scope2, idFilter);
    }

    public static /* synthetic */ VirtualFileInScopeQuery copy$default(VirtualFileInScopeQuery virtualFileInScopeQuery, GlobalSearchScope globalSearchScope, IdFilter idFilter, int n, Object object) {
        if ((n & 1) != 0) {
            globalSearchScope = virtualFileInScopeQuery.scope;
        }
        if ((n & 2) != 0) {
            idFilter = virtualFileInScopeQuery.idFilter;
        }
        return virtualFileInScopeQuery.copy(globalSearchScope, idFilter);
    }

    public int hashCode() {
        int result2 = this.scope == null ? 0 : this.scope.hashCode();
        result2 = result2 * 31 + (this.idFilter == null ? 0 : this.idFilter.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VirtualFileInScopeQuery)) {
            return false;
        }
        VirtualFileInScopeQuery virtualFileInScopeQuery = (VirtualFileInScopeQuery)((Object)other);
        if (!Intrinsics.areEqual((Object)this.scope, (Object)virtualFileInScopeQuery.scope)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.idFilter, (Object)virtualFileInScopeQuery.idFilter);
    }

    public VirtualFileInScopeQuery() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/aiplugin/rag/lucene/VirtualFileInScopeQuery$FilesInScopeIterator;", "Lorg/apache/lucene/search/TwoPhaseIterator;", "reader", "Lorg/apache/lucene/index/LeafReader;", "<init>", "(Lcom/google/aiplugin/rag/lucene/VirtualFileInScopeQuery;Lorg/apache/lucene/index/LeafReader;)V", "storedFields", "Lorg/apache/lucene/index/StoredFields;", "matchCost", "", "matches", "", "aiplugin.rag.indexer"})
    @SourceDebugExtension(value={"SMAP\nVirtualFileInScopeQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileInScopeQuery.kt\ncom/google/aiplugin/rag/lucene/VirtualFileInScopeQuery$FilesInScopeIterator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,98:1\n24#2:99\n*S KotlinDebug\n*F\n+ 1 VirtualFileInScopeQuery.kt\ncom/google/aiplugin/rag/lucene/VirtualFileInScopeQuery$FilesInScopeIterator\n*L\n89#1:99\n*E\n"})
    private final class FilesInScopeIterator
    extends TwoPhaseIterator {
        @NotNull
        private final StoredFields storedFields;

        public FilesInScopeIterator(LeafReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            super(DocIdSetIterator.all((int)reader.maxDoc()));
            StoredFields storedFields = reader.storedFields();
            Intrinsics.checkNotNull((Object)storedFields);
            this.storedFields = storedFields;
        }

        public float matchCost() {
            return 100.0f;
        }

        public boolean matches() {
            if (Intrinsics.areEqual((Object)VirtualFileInScopeQuery.this.scope, (Object)GlobalSearchScope.EMPTY_SCOPE)) {
                return false;
            }
            Integer n = LuceneIndexUtilsKt.getVirtualFileIdForDoc(this.storedFields, this.approximation.docID());
            if (n == null) {
                return false;
            }
            int virtualFileId = n;
            if (VirtualFileInScopeQuery.this.idFilter != null && !VirtualFileInScopeQuery.this.idFilter.containsFileId(virtualFileId)) {
                return false;
            }
            if (VirtualFileInScopeQuery.this.scope == null) {
                return true;
            }
            return (Boolean)ActionsKt.runReadAction(() -> FilesInScopeIterator.matches$lambda$0(virtualFileId, this, VirtualFileInScopeQuery.this));
        }

        private static final boolean matches$lambda$0(int $virtualFileId, FilesInScopeIterator this$0, VirtualFileInScopeQuery this$1) {
            VirtualFile virtualFile2;
            try {
                VirtualFile virtualFile3 = VirtualFileManager.getInstance().findFileById($virtualFileId);
                if (virtualFile3 == null) {
                    return false;
                }
                virtualFile2 = virtualFile3;
            }
            catch (Exception e) {
                FilesInScopeIterator $this$thisLogger$iv = this$0;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(FilesInScopeIterator.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Could not load file with ID " + $virtualFileId, (Throwable)e);
                return false;
            }
            VirtualFile virtualFile4 = virtualFile2;
            return this$1.scope.contains(virtualFile4);
        }
    }
}

