/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.lucene;

import com.google.aiplugin.rag.lucene.IndexedDocument;
import com.google.aiplugin.rag.lucene.IndexedDocumentCollection;
import com.google.aiplugin.rag.lucene.IndexedValue;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.UpdatedEntryProcessor;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ4\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\f2\u0016\u0010\r\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\u0002\u0012\u0006\b\u0000\u0012\u00020\u00030\u000eH\u0016J\f\u0010\u000f\u001a\u00020\n*\u00020\u0003H\u0002J\u0013\u0010\u0010\u001a\r\u0012\u0004\u0012\u00020\u00020\u0011\u00a2\u0006\u0002\b\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/google/aiplugin/rag/lucene/LuceneInputDataDiffBuilder;", "Lcom/intellij/util/indexing/impl/DirectInputDataDiffBuilder;", "", "Lcom/google/aiplugin/rag/lucene/IndexedDocumentCollection;", "inputId", "indexedValue", "Lcom/google/aiplugin/rag/lucene/IndexedValue;", "<init>", "(ILcom/google/aiplugin/rag/lucene/IndexedValue;)V", "differentiate", "", "newData", "", "changesProcessor", "Lcom/intellij/util/indexing/impl/UpdatedEntryProcessor;", "allFieldsStored", "getKeys", "", "Lorg/jetbrains/annotations/Unmodifiable;", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nLuceneForwardIndexAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuceneForwardIndexAccessor.kt\ncom/google/aiplugin/rag/lucene/LuceneInputDataDiffBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1740#2,3:149\n*S KotlinDebug\n*F\n+ 1 LuceneForwardIndexAccessor.kt\ncom/google/aiplugin/rag/lucene/LuceneInputDataDiffBuilder\n*L\n139#1:149,3\n*E\n"})
final class LuceneInputDataDiffBuilder
extends DirectInputDataDiffBuilder<Integer, IndexedDocumentCollection> {
    @NotNull
    private final IndexedValue indexedValue;

    public LuceneInputDataDiffBuilder(int inputId, @NotNull IndexedValue indexedValue) {
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"indexedValue");
        super(inputId);
        this.indexedValue = indexedValue;
    }

    public boolean differentiate(@NotNull Map<Integer, IndexedDocumentCollection> newData, @NotNull UpdatedEntryProcessor<? super Integer, ? super IndexedDocumentCollection> changesProcessor) {
        Object object;
        Intrinsics.checkNotNullParameter(newData, (String)"newData");
        Intrinsics.checkNotNullParameter(changesProcessor, (String)"changesProcessor");
        IndexedDocumentCollection newValue = newData.isEmpty() ? null : (IndexedDocumentCollection)CollectionsKt.single((Iterable)newData.values());
        IndexedValue indexedValue = this.indexedValue;
        if (indexedValue instanceof IndexedValue.Present) {
            IndexedDocumentCollection oldValue;
            object = newValue != null ? (Intrinsics.areEqual((Object)(oldValue = ((IndexedValue.Present)this.indexedValue).getValue()), (Object)newValue) && this.allFieldsStored(oldValue) && this.allFieldsStored(newValue) ? null : UpdatedEntryProcessor.UpdateKind.UPDATED) : UpdatedEntryProcessor.UpdateKind.REMOVED;
        } else if (indexedValue instanceof IndexedValue.Absent) {
            object = newValue != null ? UpdatedEntryProcessor.UpdateKind.ADDED : null;
        } else if (indexedValue instanceof IndexedValue.Unknown) {
            object = newValue != null ? UpdatedEntryProcessor.UpdateKind.UPDATED : UpdatedEntryProcessor.UpdateKind.REMOVED;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        UpdatedEntryProcessor.UpdateKind updateKind = object;
        if (updateKind != null) {
            changesProcessor.process(updateKind, (Object)this.myInputId, (Object)newValue, this.myInputId);
            return true;
        }
        return false;
    }

    private final boolean allFieldsStored(IndexedDocumentCollection $this$allFieldsStored) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = $this$allFieldsStored.getDocuments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IndexedDocument doc = (IndexedDocument)element$iv;
                    boolean bl2 = false;
                    if (doc.getFields().size() == doc.getStoredFields().size()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public Collection<Integer> getKeys() {
        Collection collection;
        IndexedValue indexedValue = this.indexedValue;
        if (indexedValue instanceof IndexedValue.Present || indexedValue instanceof IndexedValue.Unknown) {
            collection = CollectionsKt.listOf((Object)this.myInputId);
        } else if (indexedValue instanceof IndexedValue.Absent) {
            collection = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return collection;
    }
}

