/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.lucene;

import com.google.aiplugin.rag.lucene.LuceneIndexUtilsKt;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0082\u0004J\u0019\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0082\u0004J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0004H\u0002J\u0013\u0010\u0016\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0018\u0010\u0011\u001a\u00020\u0001*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/google/aiplugin/rag/lucene/IndexedDocument;", "", "fields", "", "Lorg/apache/lucene/index/IndexableField;", "<init>", "(Ljava/util/List;)V", "", "([Lorg/apache/lucene/index/IndexableField;)V", "getFields", "()Ljava/util/List;", "storedFields", "getStoredFields", "contentEquals", "", "other", "Lorg/apache/lucene/document/StoredValue;", "valueObject", "getValueObject", "(Lorg/apache/lucene/document/StoredValue;)Ljava/lang/Object;", "contentHash", "", "equals", "hashCode", "toString", "", "Externalizer", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nIndexedDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedDocument.kt\ncom/google/aiplugin/rag/lucene/IndexedDocument\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n774#2:190\n865#2,2:191\n1056#2:193\n1740#2,3:194\n1803#2,3:197\n*S KotlinDebug\n*F\n+ 1 IndexedDocument.kt\ncom/google/aiplugin/rag/lucene/IndexedDocument\n*L\n63#1:190\n63#1:191,2\n64#1:193\n107#1:194,3\n111#1:197,3\n*E\n"})
public final class IndexedDocument {
    @NotNull
    private final List<IndexableField> fields;
    @NotNull
    private final List<IndexableField> storedFields;

    /*
     * WARNING - void declaration
     */
    public IndexedDocument(@NotNull List<? extends IndexableField> fields) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        this.fields = fields;
        Iterable iterable = this.fields;
        IndexedDocument indexedDocument = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IndexableField it = (IndexableField)element$iv$iv;
            boolean bl = false;
            if (!(it.storedValue() != null && !LuceneIndexUtilsKt.getINTERNAL_FIELD_NAMES().contains(it.name()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        indexedDocument.storedFields = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexableField it = (IndexableField)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.name());
                it = (IndexableField)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.name())));
            }
        });
    }

    @NotNull
    public final List<IndexableField> getFields() {
        return this.fields;
    }

    public IndexedDocument(IndexableField ... fields) {
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        this(ArraysKt.toList((Object[])fields));
    }

    @NotNull
    public final List<IndexableField> getStoredFields() {
        return this.storedFields;
    }

    private final boolean contentEquals(IndexableField $this$contentEquals, IndexableField other) {
        return !Intrinsics.areEqual((Object)$this$contentEquals.name(), (Object)other.name()) ? false : this.contentEquals($this$contentEquals.storedValue(), other.storedValue());
    }

    private final boolean contentEquals(StoredValue $this$contentEquals, StoredValue other) {
        return $this$contentEquals == null && other == null ? true : ($this$contentEquals != null && other != null ? $this$contentEquals.getType() == other.getType() && Intrinsics.areEqual((Object)this.getValueObject($this$contentEquals), (Object)this.getValueObject(other)) : false);
    }

    private final Object getValueObject(StoredValue $this$valueObject) {
        StoredValue.Type type2 = $this$valueObject.getType();
        Comparable comparable = switch (type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> Integer.valueOf($this$valueObject.getIntValue());
            case 2 -> Long.valueOf($this$valueObject.getLongValue());
            case 3 -> Float.valueOf($this$valueObject.getFloatValue());
            case 4 -> Double.valueOf($this$valueObject.getDoubleValue());
            case 5 -> (Comparable)$this$valueObject.getBinaryValue();
            case 6 -> (Comparable)((Object)$this$valueObject.getStringValue());
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)comparable);
        return comparable;
    }

    private final int contentHash(IndexableField $this$contentHash) {
        int hashCode;
        block0: {
            hashCode = 0;
            hashCode = $this$contentHash.name().hashCode();
            StoredValue storedValue = $this$contentHash.storedValue();
            if (storedValue == null) break block0;
            StoredValue it = storedValue;
            boolean bl = false;
            hashCode = 31 * hashCode + it.getType().hashCode();
            hashCode = 31 * hashCode + this.getValueObject(it).hashCode();
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        block5: {
            if (!(other instanceof IndexedDocument)) {
                return false;
            }
            if (this.storedFields.size() != ((IndexedDocument)other).storedFields.size()) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)this.storedFields, (Iterable)((IndexedDocument)other).storedFields);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    IndexableField right;
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    IndexableField left = (IndexableField)pair.component1();
                    if (this.contentEquals(left, right = (IndexableField)pair.component2())) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $this$fold$iv;
        Iterable iterable = this.storedFields;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void field;
            IndexableField indexableField = (IndexableField)element$iv;
            int acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = 31 * acc + this.contentHash((IndexableField)field);
        }
        return accumulator$iv;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u245.append("IndexedDocument[");
        for (IndexableField field : this.fields) {
            $this$toString_u24lambda_u245.append(field.name());
            $this$toString_u24lambda_u245.append("=");
            StoredValue storedValue = field.storedValue();
            StringBuilder stringBuilder2 = storedValue != null ? $this$toString_u24lambda_u245.append(this.getValueObject(storedValue)) : $this$toString_u24lambda_u245.append("<not stored>");
            $this$toString_u24lambda_u245.append(", ");
        }
        $this$toString_u24lambda_u245.append("]");
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/google/aiplugin/rag/lucene/IndexedDocument$Externalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lcom/google/aiplugin/rag/lucene/IndexedDocument;", "<init>", "()V", "save", "", "out", "Ljava/io/DataOutput;", "value", "writeStoredValue", "Lorg/apache/lucene/document/StoredValue;", "read", "input", "Ljava/io/DataInput;", "readStoredValueAsField", "Lorg/apache/lucene/document/StoredField;", "fieldName", "", "aiplugin.rag.indexer"})
    public static final class Externalizer
    implements DataExternalizer<IndexedDocument> {
        @NotNull
        public static final Externalizer INSTANCE = new Externalizer();

        private Externalizer() {
        }

        public void save(@NotNull DataOutput out, @NotNull IndexedDocument value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.getStoredFields().size());
            for (IndexableField field : value.getStoredFields()) {
                IOUtil.writeUTF((DataOutput)out, (String)field.name());
                StoredValue storedValue = field.storedValue();
                Intrinsics.checkNotNull((Object)storedValue);
                this.writeStoredValue(out, storedValue);
            }
        }

        private final void writeStoredValue(DataOutput out, StoredValue value) {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.getType().ordinal());
            StoredValue.Type type2 = value.getType();
            switch (type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value.getIntValue());
                    break;
                }
                case 2: {
                    DataInputOutputUtil.writeLONG((DataOutput)out, (long)value.getLongValue());
                    break;
                }
                case 3: {
                    out.writeFloat(value.getFloatValue());
                    break;
                }
                case 4: {
                    out.writeDouble(value.getDoubleValue());
                    break;
                }
                case 5: {
                    BytesRef bytesRef = value.getBinaryValue();
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)bytesRef.length);
                    out.write(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                    break;
                }
                case 6: {
                    IOUtil.writeUTF((DataOutput)out, (String)value.getStringValue());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @NotNull
        public IndexedDocument read(@NotNull DataInput input) {
            List list;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int fieldCount = DataInputOutputUtil.readINT((DataInput)input);
            List $this$read_u24lambda_u241 = list = CollectionsKt.createListBuilder((int)fieldCount);
            boolean bl = false;
            int n = 0;
            while (n < fieldCount) {
                int it = n++;
                boolean bl2 = false;
                String name = IOUtil.readUTF((DataInput)input);
                Intrinsics.checkNotNull((Object)name);
                StoredField field = INSTANCE.readStoredValueAsField(input, name);
                $this$read_u24lambda_u241.add(field);
            }
            List storedFields = CollectionsKt.build((List)list);
            return new IndexedDocument(storedFields);
        }

        private final StoredField readStoredValueAsField(DataInput input, String fieldName) {
            int typeOrdinal = DataInputOutputUtil.readINT((DataInput)input);
            StoredValue.Type type2 = (StoredValue.Type)EntriesMappings.entries$0.get(typeOrdinal);
            return switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1 -> new StoredField(fieldName, DataInputOutputUtil.readINT((DataInput)input));
                case 2 -> new StoredField(fieldName, DataInputOutputUtil.readLONG((DataInput)input));
                case 3 -> new StoredField(fieldName, input.readFloat());
                case 4 -> new StoredField(fieldName, input.readDouble());
                case 5 -> {
                    int length = DataInputOutputUtil.readINT((DataInput)input);
                    BytesRef ref = new BytesRef(length);
                    input.readFully(ref.bytes);
                    ref.length = length;
                    yield new StoredField(fieldName, ref);
                }
                case 6 -> new StoredField(fieldName, IOUtil.readUTF((DataInput)input));
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<StoredValue.Type> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])StoredValue.Type.values()));
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[StoredValue.Type.values().length];
                try {
                    nArray[StoredValue.Type.INTEGER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StoredValue.Type.LONG.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StoredValue.Type.FLOAT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StoredValue.Type.DOUBLE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StoredValue.Type.BINARY.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StoredValue.Type.STRING.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StoredValue.Type.values().length];
            try {
                nArray[StoredValue.Type.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.FLOAT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.DOUBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.BINARY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StoredValue.Type.STRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

