/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.embedding;

import com.google.aiplugin.rag.embedding.EmbeddingData;
import com.google.aiplugin.rag.embedding.LocalVectorDBClient;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u0012*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H&J\u0011\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0096\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020\u0012H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010)\u001a\u00020\u0012H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\b\u0010+\u001a\u00020 H\u0016J)\u0010,\u001a\u0004\u0018\u0001H-\"\u0004\b\u0000\u0010-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H-0/H\u0004\u00a2\u0006\u0002\u00100J\u0017\u00101\u001a\u0004\u0018\u00010\u001e2\u0006\u00102\u001a\u00020\u0004H\u0004\u00a2\u0006\u0002\u00103J7\u00101\u001a\u0004\u0018\u0001H-\"\u0004\b\u0000\u0010-2\u0006\u00102\u001a\u00020\u00042\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002H-04H\u0004\u00a2\u0006\u0002\u00106J7\u00107\u001a\u0004\u0018\u0001H-\"\u0004\b\u0000\u0010-2\u0006\u00102\u001a\u00020\u00042\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H-04H\u0004\u00a2\u0006\u0002\u00106R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00068"}, d2={"Lcom/google/aiplugin/rag/embedding/JdbcVectorDBClient;", "Lcom/google/aiplugin/rag/embedding/LocalVectorDBClient;", "Lcom/intellij/openapi/Disposable;", "embeddingDbUrl", "", "<init>", "(Ljava/lang/String;)V", "getEmbeddingDbUrl", "()Ljava/lang/String;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "dbConnection", "Ljava/sql/Connection;", "connectionLock", "", "addOrUpdate", "", "embeddings", "", "Lcom/google/aiplugin/rag/embedding/EmbeddingData;", "addEmbeddingData", "Ljava/sql/PreparedStatement;", "embeddingData", "connectionProperties", "Ljava/util/Properties;", "getConnectionProperties", "()Ljava/util/Properties;", "contains", "", "fileId", "", "unindex", "tryRecover", "clearUnindexed", "performPeriodicCleanup", "cleanupInterval", "Lkotlin/time/Duration;", "getCleanupInterval-UwyO8pc", "()J", "clearAll", "dispose", "count", "connect", "R", "run", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "createStatement", "sql", "(Ljava/lang/String;)Ljava/lang/Boolean;", "Lkotlin/Function2;", "Ljava/sql/ResultSet;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "prepareStatement", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nJdbcVectorDBClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcVectorDBClient.kt\ncom/google/aiplugin/rag/embedding/JdbcVectorDBClient\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n24#2:178\n1#3:179\n*S KotlinDebug\n*F\n+ 1 JdbcVectorDBClient.kt\ncom/google/aiplugin/rag/embedding/JdbcVectorDBClient\n*L\n46#1:178\n*E\n"})
public abstract class JdbcVectorDBClient
implements LocalVectorDBClient,
Disposable {
    @NotNull
    private final String embeddingDbUrl;
    @NotNull
    private final Logger logger;
    @Nullable
    private Connection dbConnection;
    @NotNull
    private final Object connectionLock;

    public JdbcVectorDBClient(@NotNull String embeddingDbUrl) {
        Intrinsics.checkNotNullParameter((Object)embeddingDbUrl, (String)"embeddingDbUrl");
        this.embeddingDbUrl = embeddingDbUrl;
        JdbcVectorDBClient $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JdbcVectorDBClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.connectionLock = new Object();
    }

    @NotNull
    protected final String getEmbeddingDbUrl() {
        return this.embeddingDbUrl;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void addOrUpdate(@NotNull List<EmbeddingData> embeddings) {
        Intrinsics.checkNotNullParameter(embeddings, (String)"embeddings");
        this.prepareStatement("\nINSERT INTO gemini_embeddings (file_id, embedding)\nVALUES (?, ?)\nON CONFLICT(file_id)\nDO UPDATE SET\nembedding = excluded.embedding;\n", (arg_0, arg_1) -> JdbcVectorDBClient.addOrUpdate$lambda$0(embeddings, this, arg_0, arg_1));
    }

    public abstract void addEmbeddingData(@NotNull PreparedStatement var1, @NotNull EmbeddingData var2);

    @NotNull
    public Properties getConnectionProperties() {
        return new Properties();
    }

    @Override
    public boolean contains(int fileId) {
        Boolean bl = (Boolean)this.prepareStatement("\nSELECT file_id FROM gemini_embeddings\nWHERE file_id = ? AND unindexed_time IS NULL;\n", (arg_0, arg_1) -> JdbcVectorDBClient.contains$lambda$1(fileId, arg_0, arg_1));
        return bl != null ? bl : false;
    }

    @Override
    public void unindex(int fileId) {
        this.prepareStatement("\nUPDATE gemini_embeddings\nSET unindexed_time = ?\nWHERE file_id = ? AND unindexed_time IS NULL;\n", (arg_0, arg_1) -> JdbcVectorDBClient.unindex$lambda$2(fileId, arg_0, arg_1));
    }

    @Override
    public boolean tryRecover(int fileId) {
        Boolean bl = (Boolean)this.prepareStatement("\nUPDATE gemini_embeddings\nSET unindexed_time = NULL\nWHERE file_id = ? AND unindexed_time IS NOT NULL;\n", (arg_0, arg_1) -> JdbcVectorDBClient.tryRecover$lambda$3(fileId, this, arg_0, arg_1));
        return bl != null ? bl : false;
    }

    @Override
    public void clearUnindexed() {
        this.createStatement("\n  DELETE FROM gemini_embeddings\n  WHERE unindexed_time is NOT NULL;\n");
    }

    @Override
    public void performPeriodicCleanup() {
        String deleteAllUnindexedSql = "DELETE FROM gemini_embeddings WHERE unindexed_time < datetime('now', '-1 hour');";
        this.createStatement(deleteAllUnindexedSql);
    }

    @Override
    public long getCleanupInterval-UwyO8pc() {
        return DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.MINUTES);
    }

    @Override
    public void clearAll() {
        this.createStatement("DELETE FROM gemini_embeddings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.clearUnindexed();
        Object object = this.connectionLock;
        synchronized (object) {
            boolean bl = false;
            Connection connection = this.dbConnection;
            if (connection != null) {
                connection.close();
            }
            this.dbConnection = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public int count() {
        Integer n = (Integer)this.createStatement("\n  SELECT COUNT(*) FROM gemini_embeddings\n  WHERE unindexed_time IS NULL;\n", JdbcVectorDBClient::count$lambda$5);
        return n != null ? n : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final <R> R connect(@NotNull Function1<? super Connection, ? extends R> run2) {
        Object object;
        Intrinsics.checkNotNullParameter(run2, (String)"run");
        try {
            Object object2;
            Object object3 = this.connectionLock;
            synchronized (object3) {
                Connection connection;
                block8: {
                    Connection it;
                    Connection connection2;
                    block7: {
                        boolean bl = false;
                        connection = this.dbConnection;
                        if (connection == null) break block7;
                        it = connection2 = connection;
                        boolean bl2 = false;
                        connection = !it.isClosed() ? connection2 : null;
                        if (connection != null) break block8;
                    }
                    it = connection2 = DriverManager.getConnection(this.embeddingDbUrl, this.getConnectionProperties());
                    boolean bl = false;
                    this.dbConnection = it;
                    connection = connection2;
                }
                Connection connection3 = connection;
                Intrinsics.checkNotNull((Object)connection3);
                object2 = run2.invoke((Object)connection3);
            }
            object = object2;
        }
        catch (Exception e) {
            this.getLogger().warn("Local vector search database access has an exception", (Throwable)e);
            object = null;
        }
        return (R)object;
    }

    @Nullable
    protected final Boolean createStatement(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return (Boolean)this.connect(arg_0 -> JdbcVectorDBClient.createStatement$lambda$10(sql, arg_0));
    }

    @Nullable
    protected final <R> R createStatement(@NotNull String sql, @NotNull Function2<? super Connection, ? super ResultSet, ? extends R> run2) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(run2, (String)"run");
        return this.connect(arg_0 -> JdbcVectorDBClient.createStatement$lambda$12(sql, run2, arg_0));
    }

    @Nullable
    protected final <R> R prepareStatement(@NotNull String sql, @NotNull Function2<? super Connection, ? super PreparedStatement, ? extends R> run2) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(run2, (String)"run");
        return this.connect(arg_0 -> JdbcVectorDBClient.prepareStatement$lambda$14(sql, run2, arg_0));
    }

    private static final int[] addOrUpdate$lambda$0(List $embeddings, JdbcVectorDBClient this$0, Connection connection, PreparedStatement statement) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        for (EmbeddingData embeddingData : $embeddings) {
            this$0.addEmbeddingData(statement, embeddingData);
        }
        return statement.executeBatch();
    }

    private static final boolean contains$lambda$1(int $fileId, Connection connection, PreparedStatement statement) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        statement.setInt(1, $fileId);
        ResultSet rs = statement.executeQuery();
        if (!rs.next()) {
            return false;
        }
        if (rs.getInt("file_id") != $fileId) {
            return false;
        }
        return !rs.next();
    }

    private static final int unindex$lambda$2(int $fileId, Connection connection, PreparedStatement statement) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        statement.setTimestamp(1, Timestamp.from(Instant.now()));
        statement.setInt(2, $fileId);
        return statement.executeUpdate();
    }

    private static final boolean tryRecover$lambda$3(int $fileId, JdbcVectorDBClient this$0, Connection connection, PreparedStatement statement) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        statement.setInt(1, $fileId);
        switch (statement.executeUpdate()) {
            case 1: {
                this$0.getLogger().info("Reversed unindexing file id " + $fileId);
                return true;
            }
            case 0: {
                this$0.getLogger().info("File id " + $fileId + " was not unindexed");
            }
        }
        return false;
    }

    private static final int count$lambda$5(Connection connection, ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean createStatement$lambda$10(String $sql, Connection connection) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement statement = (Statement)autoCloseable;
            boolean bl2 = false;
            bl = statement.execute($sql);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object createStatement$lambda$12(String $sql, Function2 $run, Connection connection) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.createStatement();
        Throwable throwable = null;
        try {
            Statement statement = (Statement)autoCloseable;
            boolean bl = false;
            ResultSet rs = statement.executeQuery($sql);
            Intrinsics.checkNotNull((Object)rs);
            object = $run.invoke((Object)connection, (Object)rs);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object prepareStatement$lambda$14(String $sql, Function2 $run, Connection connection) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        AutoCloseable autoCloseable = connection.prepareStatement($sql);
        Throwable throwable = null;
        try {
            PreparedStatement statement = (PreparedStatement)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)statement);
            object = $run.invoke((Object)connection, (Object)statement);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return object;
    }
}

