/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.bm25;

import com.google.aiplugin.rag.bm25.CamelCaseSplitterFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterIterator;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/google/aiplugin/rag/bm25/CodeAnalyzer;", "Lorg/apache/lucene/analysis/Analyzer;", "stopWords", "Lorg/apache/lucene/analysis/CharArraySet;", "<init>", "(Lorg/apache/lucene/analysis/CharArraySet;)V", "createComponents", "Lorg/apache/lucene/analysis/Analyzer$TokenStreamComponents;", "fieldName", "", "normalize", "Lorg/apache/lucene/analysis/TokenStream;", "in", "aiplugin.rag.indexer"})
public final class CodeAnalyzer
extends Analyzer {
    @NotNull
    private final CharArraySet stopWords;

    public CodeAnalyzer(@NotNull CharArraySet stopWords) {
        Intrinsics.checkNotNullParameter((Object)stopWords, (String)"stopWords");
        this.stopWords = stopWords;
    }

    public /* synthetic */ CodeAnalyzer(CharArraySet charArraySet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            CharArraySet charArraySet2 = EnglishAnalyzer.ENGLISH_STOP_WORDS_SET;
            Intrinsics.checkNotNullExpressionValue((Object)charArraySet2, (String)"ENGLISH_STOP_WORDS_SET");
            charArraySet = charArraySet2;
        }
        this(charArraySet);
    }

    @NotNull
    protected Analyzer.TokenStreamComponents createComponents(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Tokenizer source = (Tokenizer)new StandardTokenizer();
        TokenStream result2 = (TokenStream)new EnglishPossessiveFilter((TokenStream)source);
        int wdfFlags = 163;
        result2 = (TokenStream)new WordDelimiterGraphFilter(result2, true, WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, wdfFlags, null);
        result2 = (TokenStream)new CamelCaseSplitterFilter(result2);
        result2 = (TokenStream)new LowerCaseFilter(result2);
        result2 = (TokenStream)new StopFilter(result2, this.stopWords);
        return new Analyzer.TokenStreamComponents(source, result2);
    }

    @NotNull
    protected TokenStream normalize(@NotNull String fieldName, @NotNull TokenStream in) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        TokenStream result2 = (TokenStream)new EnglishPossessiveFilter(in);
        result2 = (TokenStream)new LowerCaseFilter(result2);
        return result2;
    }

    public CodeAnalyzer() {
        this(null, 1, null);
    }
}

