/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.rag.bm25;

import com.android.studio.ml.bot.StudioBotFlags;
import com.google.aiplugin.rag.bm25.Bm25Indexer;
import com.google.aiplugin.rag.bm25.Bm25SearchTool;
import com.google.aiplugin.rag.bm25.CodeAnalyzer;
import com.google.aiplugin.rag.internal.IndexableFilesCrawlerKt;
import com.google.aiplugin.rag.internal.RagIndexerFactory;
import com.google.aiplugin.rag.internal.RagIndexerUtilsKt;
import com.google.aiplugin.rag.internal.VirtualFileUtilsKt;
import com.google.aiplugin.rag.lucene.LuceneIndexWriterManagerService;
import com.google.aiplugin.rag.processing.FileProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharSequenceReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ClosedReceiveChannelException;
import org.HdrHistogram.Histogram;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB\u0011\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000fJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u00101\u001a\u00020#2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020\u001aH\u0016J\u0010\u00106\u001a\u00020#2\u0006\u00105\u001a\u00020\u001aH\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020#H\u0016J\b\u0010<\u001a\u00020#H\u0016J\n\u0010=\u001a\u0004\u0018\u00010>H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001a0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\u00020.8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006@"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25IndexerImpl;", "Lcom/google/aiplugin/rag/bm25/Bm25Indexer;", "Lcom/intellij/openapi/Disposable;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "indexDirectory", "Ljava/nio/file/Path;", "indexCommitInterval", "Lkotlin/time/Duration;", "searchTool", "Lcom/google/aiplugin/rag/bm25/Bm25SearchTool;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;Ljava/nio/file/Path;JLcom/google/aiplugin/rag/bm25/Bm25SearchTool;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "(Lkotlinx/coroutines/CoroutineScope;)V", "getIndexDirectory", "()Ljava/nio/file/Path;", "J", "getSearchTool", "()Lcom/google/aiplugin/rag/bm25/Bm25SearchTool;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "version", "", "getVersion", "()I", "createIndexWriterConfig", "Lorg/apache/lucene/index/IndexWriterConfig;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "releaseIndexWriter", "Lkotlin/Function0;", "", "indexingDurationInMillisHistogram", "Lorg/HdrHistogram/Histogram;", "histogramLock", "", "indexCommitter", "Lkotlinx/coroutines/Job;", "unindexCommitter", "unindexChannel", "Lkotlinx/coroutines/channels/Channel;", "hasUncommittedChanges", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getHasUncommittedChanges", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "index", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "unindex", "fileId", "deleteIndex", "isIndexed", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "requestIndexRebuild", "getStatus", "", "Companion", "aiplugin.rag.indexer"})
@SourceDebugExtension(value={"SMAP\nBm25Indexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bm25Indexer.kt\ncom/google/aiplugin/rag/bm25/Bm25IndexerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,347:1\n24#2:348\n29#3,3:349\n*S KotlinDebug\n*F\n+ 1 Bm25Indexer.kt\ncom/google/aiplugin/rag/bm25/Bm25IndexerImpl\n*L\n110#1:348\n205#1:349,3\n*E\n"})
public class Bm25IndexerImpl
implements Bm25Indexer,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final CoroutineDispatcher ioDispatcher;
    @NotNull
    private final Path indexDirectory;
    private final long indexCommitInterval;
    @NotNull
    private final Bm25SearchTool searchTool;
    @NotNull
    private final Logger logger;
    private final int version;
    @NotNull
    private final IndexWriter indexWriter;
    @NotNull
    private final Function0<Unit> releaseIndexWriter;
    @NotNull
    private final Histogram indexingDurationInMillisHistogram;
    @NotNull
    private final Object histogramLock;
    @NotNull
    private final Job indexCommitter;
    @NotNull
    private final Job unindexCommitter;
    @NotNull
    private final Channel<Integer> unindexChannel;
    @VisibleForTesting
    @NotNull
    private final AtomicBoolean hasUncommittedChanges;
    @NotNull
    private static final ConcurrentHashMap<Path, Throwable> creationTracesByPath = new ConcurrentHashMap();
    public static final int VERSION = 3;
    private static final long INDEX_COMMIT_INTERVAL = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);
    private static final long MAX_MEASURED_LATENCY_MS = 10000L;

    /*
     * WARNING - void declaration
     */
    private Bm25IndexerImpl(CoroutineScope scope2, CoroutineDispatcher ioDispatcher, Path indexDirectory, long indexCommitInterval, Bm25SearchTool searchTool) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)ioDispatcher, (String)"ioDispatcher");
        Intrinsics.checkNotNullParameter((Object)indexDirectory, (String)"indexDirectory");
        Intrinsics.checkNotNullParameter((Object)searchTool, (String)"searchTool");
        this.scope = scope2;
        this.ioDispatcher = ioDispatcher;
        this.indexDirectory = indexDirectory;
        this.indexCommitInterval = indexCommitInterval;
        this.searchTool = searchTool;
        Throwable newTrace = new Throwable("Previous Bm25Indexer created here");
        Throwable oldTrace = creationTracesByPath.putIfAbsent(this.getIndexDirectory(), newTrace);
        if (oldTrace != null) {
            throw new AssertionError("Bm25Indexer already created - cannot recreate", oldTrace);
        }
        Bm25IndexerImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Bm25IndexerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.version = 3;
        this.indexingDurationInMillisHistogram = new Histogram(10000L, 1);
        this.histogramLock = new Object();
        this.unindexChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.hasUncommittedChanges = new AtomicBoolean();
        if (StudioBotFlags.Companion.getInstance().useLucindexForRag()) {
            this.indexWriter = LuceneIndexWriterManagerService.Companion.getInstance().getIndexWriter(this.getIndexDirectory(), this.createIndexWriterConfig());
            this.releaseIndexWriter = () -> Bm25IndexerImpl._init_$lambda$1(this);
        } else {
            IndexWriter indexWriter;
            Bm25IndexerImpl bm25IndexerImpl;
            FSDirectory fsDir = FSDirectory.open((Path)this.getIndexDirectory());
            Bm25IndexerImpl bm25IndexerImpl2 = this;
            try {
                bm25IndexerImpl = bm25IndexerImpl2;
                indexWriter = new IndexWriter((Directory)fsDir, this.createIndexWriterConfig());
            }
            catch (LockObtainFailedException lockObtainFailedException) {
                void e;
                bm25IndexerImpl = bm25IndexerImpl2;
                this.getLogger().warn("Could not obtain lock on index directory: " + e.getMessage());
                Path path2 = this.getIndexDirectory().resolve("write.lock");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                boolean deleted = Files.deleteIfExists(path2);
                this.getLogger().info("Deleting write.lock, status: " + deleted);
                indexWriter = new IndexWriter((Directory)fsDir, this.createIndexWriterConfig());
            }
            bm25IndexerImpl.indexWriter = indexWriter;
            this.releaseIndexWriter = () -> Bm25IndexerImpl._init_$lambda$2(this, fsDir);
        }
        this.indexCommitter = BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)this.ioDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Bm25IndexerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            needsToCommit = Bm25IndexerImpl.access$getIndexWriter$p(this.this$0).hasUncommittedChanges();
                            this.this$0.getHasUncommittedChanges().set(needsToCommit != false);
                            if (needsToCommit) {
                                Bm25IndexerImpl.access$getIndexWriter$p(this.this$0).commit();
                            }
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)Bm25IndexerImpl.access$getIndexCommitInterval$p(this.this$0), (Continuation)((Continuation)this));
                            if (v0 != var4_2) continue;
                            return var4_2;
                        }
                        break;
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.unindexCommitter = BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)this.ioDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Bm25IndexerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                        // 2 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = Bm25IndexerImpl.access$getUnindexChannel$p(this.this$0).receive((Continuation)this);
                            ** if (v0 != var6_2) goto lbl14
lbl13:
                            // 1 sources

                            return var6_2;
lbl14:
                            // 1 sources

                            ** GOTO lbl22
                        }
                        ** GOTO lbl32
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 2 sources

                            var4_5 = ((Number)v0).intValue();
                        }
                        catch (ClosedReceiveChannelException e) {
                            this.this$0.getLogger().warn("Unindex channel closed", (Throwable)e);
                            ** GOTO lbl32
                        }
                        catch (CancellationException e) {
                            throw e;
                        }
                        fileIdToUnindex = var4_5;
                        Bm25IndexerImpl.access$deleteIndex(this.this$0, fileIdToUnindex);
                        ** GOTO lbl6
lbl32:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public /* synthetic */ Bm25IndexerImpl(CoroutineScope coroutineScope, CoroutineDispatcher coroutineDispatcher, Path path2, long l2, Bm25SearchTool bm25SearchTool, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bm25SearchTool = new Bm25SearchTool();
        }
        this(coroutineScope, coroutineDispatcher, path2, l2, bm25SearchTool, null);
    }

    @Override
    @NotNull
    public Path getIndexDirectory() {
        return this.indexDirectory;
    }

    @NotNull
    public Bm25SearchTool getSearchTool() {
        return this.searchTool;
    }

    private Bm25IndexerImpl(CoroutineScope scope2) {
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getIO();
        Path path2 = PathManager.getSystemDir();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getSystemDir(...)");
        Path path3 = path2;
        Path path4 = path3.resolve("caches");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        path3 = path4;
        Path path5 = path3.resolve("gemini");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        path3 = path5;
        Path path6 = path3.resolve("bm25");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        this(scope2, coroutineDispatcher, path6, INDEX_COMMIT_INTERVAL, null, 16, null);
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private final IndexWriterConfig createIndexWriterConfig() {
        IndexWriterConfig indexWriterConfig;
        IndexWriterConfig $this$createIndexWriterConfig_u24lambda_u240 = indexWriterConfig = new IndexWriterConfig((Analyzer)new CodeAnalyzer(null, 1, null));
        boolean bl = false;
        $this$createIndexWriterConfig_u24lambda_u240.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        $this$createIndexWriterConfig_u24lambda_u240.setSimilarity((Similarity)new BM25Similarity());
        return indexWriterConfig;
    }

    @NotNull
    public final AtomicBoolean getHasUncommittedChanges() {
        return this.hasUncommittedChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(@NotNull FileContent fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        VirtualFile virtualFile2 = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        Integer n = VirtualFileUtilsKt.id(virtualFile2);
        if (n == null) {
            return;
        }
        int fileId = n;
        VirtualFile virtualFile3 = fileContent.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getFile(...)");
        String filePath = RagIndexerUtilsKt.getFilePathToIndex(virtualFile3, fileContent.getProject());
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.deleteIndex(fileId);
        Sequence documents = SequencesKt.map(FileProcessor.Companion.getInstance().getIndexableTexts(fileContent), arg_0 -> Bm25IndexerImpl.index$lambda$5$lambda$4(fileId, filePath, arg_0));
        this.indexWriter.addDocuments(SequencesKt.asIterable((Sequence)documents));
        long millis = System.currentTimeMillis() - start$iv;
        if (!this.indexCommitter.isActive()) {
            this.getLogger().warn("The thread handling indexing is not active. We use pooled thread instead.");
            ApplicationManager.getApplication().executeOnPooledThread(() -> Bm25IndexerImpl.index$lambda$6(this));
            return;
        }
        Object object = this.histogramLock;
        synchronized (object) {
            boolean bl2 = false;
            this.indexingDurationInMillisHistogram.recordValue(Math.min(millis, 10000L));
            Unit unit = Unit.INSTANCE;
        }
        if (millis > 2000L) {
            this.getLogger().info("Took " + millis + " ms to index " + filePath);
        }
    }

    @Override
    public void unindex(int fileId) {
        if (!this.unindexCommitter.isActive()) {
            this.getLogger().warn("The thread handling unindexing is not active. We use pooled thread instead.");
            ApplicationManager.getApplication().executeOnPooledThread(() -> Bm25IndexerImpl.unindex$lambda$8(this, fileId));
            return;
        }
        this.unindexChannel.trySend-JP2dKIU((Object)fileId);
    }

    private final void deleteIndex(int fileId) {
        Query docIdQuery = IntField.newExactQuery((String)"vfile.id", (int)fileId);
        Query[] queryArray = new Query[]{docIdQuery};
        this.indexWriter.deleteDocuments(queryArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isIndexed(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Integer n = VirtualFileUtilsKt.id(file);
        if (n == null) {
            return false;
        }
        int fileId = n;
        Query query = IntPoint.newExactQuery((String)"vfile.id", (int)fileId);
        Closeable closeable = (Closeable)FSDirectory.open((Path)this.getIndexDirectory());
        Throwable throwable = null;
        try {
            int n2;
            IndexSearcher searcher;
            Throwable throwable2;
            Closeable closeable2;
            block18: {
                FSDirectory fsDir = (FSDirectory)closeable;
                boolean bl = false;
                closeable2 = (Closeable)DirectoryReader.open((Directory)((Directory)fsDir));
                throwable2 = null;
                DirectoryReader reader = (DirectoryReader)closeable2;
                boolean bl2 = false;
                searcher = new IndexSearcher((IndexReader)reader);
                TopDocs matchingDoc = searcher.search(query, 1);
                if (matchingDoc.totalHits.value != 1L) {
                    this.getLogger().warn("Searching for virtual file with id " + fileId + " from BM25 index returns " + matchingDoc.totalHits.value + " files");
                }
                Intrinsics.checkNotNullExpressionValue((Object)matchingDoc.scoreDocs, (String)"scoreDocs");
                ScoreDoc scoreDoc = (ScoreDoc)ArraysKt.firstOrNull((Object[])matchingDoc.scoreDocs);
                if (scoreDoc != null) {
                    n2 = scoreDoc.doc;
                    break block18;
                }
                boolean bl3 = false;
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                boolean bl4 = bl3;
                return bl4;
            }
            int docId = n2;
            boolean bl = Companion.getFileIdForDoc$aiplugin_rag_indexer(searcher, docId) == fileId;
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            boolean bl5 = bl;
            return bl5;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                                throw throwable4;
                            }
                        }
                        catch (IndexNotFoundException e) {
                            this.getLogger().warn("BM25 index is not found in " + this.getIndexDirectory() + ": " + e.getMessage());
                            boolean bl6 = false;
                            return bl6;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                }
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void dispose() {
        try {
            Job.DefaultImpls.cancel$default((Job)this.indexCommitter, null, (int)1, null);
            Job.DefaultImpls.cancel$default((Job)this.unindexCommitter, null, (int)1, null);
            if (this.indexWriter.hasUncommittedChanges()) {
                this.indexWriter.commit();
            }
            this.releaseIndexWriter.invoke();
            creationTracesByPath.remove(this.getIndexDirectory());
        }
        catch (IOException e) {
            this.getLogger().error("Error closing index writer", (Throwable)e);
        }
    }

    @Override
    public void requestIndexRebuild() {
        this.indexWriter.deleteAll();
        this.indexWriter.commit();
        ActionsKt.runInEdt$default(null, () -> Bm25IndexerImpl.requestIndexRebuild$lambda$11(this), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getStatus() {
        StringBuilder stringBuilder;
        StringBuilder $this$getStatus_u24lambda_u2414 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getStatus_u24lambda_u2414.append("<html><body>").append('\n');
        $this$getStatus_u24lambda_u2414.append("<p>Total # of docs: " + this.indexWriter.getDocStats().numDocs + "</p>").append('\n');
        Object object = this.histogramLock;
        synchronized (object) {
            boolean bl2 = false;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Closeable closeable = new PrintStream((OutputStream)outputStream, true, StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                PrintStream it = (PrintStream)closeable;
                boolean bl3 = false;
                this.indexingDurationInMillisHistogram.outputPercentileDistribution(it, Double.valueOf(1.0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$getStatus_u24lambda_u2414.append("<p>Indexing time histogram:</p>").append('\n');
            $this$getStatus_u24lambda_u2414.append("<pre>").append('\n');
            $this$getStatus_u24lambda_u2414.append(outputStream.toString(StandardCharsets.UTF_8)).append('\n');
            StringBuilder stringBuilder2 = $this$getStatus_u24lambda_u2414.append("</pre>").append('\n');
        }
        $this$getStatus_u24lambda_u2414.append("</body></html>").append('\n');
        return stringBuilder.toString();
    }

    private static final Unit _init_$lambda$1(Bm25IndexerImpl this$0) {
        LuceneIndexWriterManagerService.Companion.getInstance().releaseIndexWriter(this$0.getIndexDirectory(), this$0.indexWriter);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(Bm25IndexerImpl this$0, FSDirectory $fsDir) {
        this$0.indexWriter.close();
        $fsDir.close();
        return Unit.INSTANCE;
    }

    private static final Document index$lambda$5$lambda$4(int $fileId, String $filePath, CharSequence text2) {
        Document document2;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Document $this$index_u24lambda_u245_u24lambda_u244_u24lambda_u243 = document2 = new Document();
        boolean bl = false;
        $this$index_u24lambda_u245_u24lambda_u244_u24lambda_u243.add((IndexableField)new IntField("vfile.id", $fileId, Field.Store.YES));
        $this$index_u24lambda_u245_u24lambda_u244_u24lambda_u243.add((IndexableField)new TextField("vfile.path", $filePath, Field.Store.NO));
        $this$index_u24lambda_u245_u24lambda_u244_u24lambda_u243.add((IndexableField)new TextField("vfile.contents", (Reader)new CharSequenceReader(text2)));
        return document2;
    }

    private static final void index$lambda$6(Bm25IndexerImpl this$0) {
        this$0.indexWriter.commit();
    }

    private static final void unindex$lambda$8(Bm25IndexerImpl this$0, int $fileId) {
        this$0.deleteIndex($fileId);
    }

    private static final Unit requestIndexRebuild$lambda$11(Bm25IndexerImpl this$0) {
        try {
            FileBasedIndex.getInstance().requestRebuild(IndexableFilesCrawlerKt.getCRAWLER_NAME());
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException || e instanceof CancellationException) {
                throw e;
            }
            this$0.getLogger().warn("Index rebuild failed", (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ Bm25IndexerImpl(CoroutineScope scope2, CoroutineDispatcher ioDispatcher, Path indexDirectory, long indexCommitInterval, Bm25SearchTool searchTool, DefaultConstructorMarker $constructor_marker) {
        this(scope2, ioDispatcher, indexDirectory, indexCommitInterval, searchTool);
    }

    public /* synthetic */ Bm25IndexerImpl(CoroutineScope scope2, DefaultConstructorMarker $constructor_marker) {
        this(scope2);
    }

    public static final /* synthetic */ IndexWriter access$getIndexWriter$p(Bm25IndexerImpl $this) {
        return $this.indexWriter;
    }

    public static final /* synthetic */ long access$getIndexCommitInterval$p(Bm25IndexerImpl $this) {
        return $this.indexCommitInterval;
    }

    public static final /* synthetic */ Channel access$getUnindexChannel$p(Bm25IndexerImpl $this) {
        return $this.unindexChannel;
    }

    public static final /* synthetic */ void access$deleteIndex(Bm25IndexerImpl $this, int fileId) {
        $this.deleteIndex(fileId);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0019\u0010\u0013\u001a\u00020\r*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0016R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/google/aiplugin/rag/bm25/Bm25IndexerImpl$Companion;", "Lcom/google/aiplugin/rag/internal/RagIndexerFactory;", "<init>", "()V", "createIndexer", "Lcom/google/aiplugin/rag/bm25/Bm25IndexerImpl;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "creationTracesByPath", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "", "VERSION", "", "INDEX_COMMIT_INTERVAL", "Lkotlin/time/Duration;", "J", "MAX_MEASURED_LATENCY_MS", "", "getFileIdForDoc", "Lorg/apache/lucene/search/IndexSearcher;", "docId", "getFileIdForDoc$aiplugin_rag_indexer", "aiplugin.rag.indexer"})
    public static final class Companion
    implements RagIndexerFactory {
        private Companion() {
        }

        @Override
        @NotNull
        public Bm25IndexerImpl createIndexer(@NotNull CoroutineScope scope2) {
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            return new Bm25IndexerImpl(scope2, null);
        }

        public final int getFileIdForDoc$aiplugin_rag_indexer(@NotNull IndexSearcher $this$getFileIdForDoc, int docId) {
            Intrinsics.checkNotNullParameter((Object)$this$getFileIdForDoc, (String)"<this>");
            return $this$getFileIdForDoc.storedFields().document(docId).getField("vfile.id").numericValue().intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

