/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.search;

import com.android.tools.idea.studiobot.AiExcludeService;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.ToolHandler;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.search.FindFilesArgs;
import com.google.aiplugin.agents.tools.search.FindFilesHandler;
import com.google.gson.Gson;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindFilesHandler;", "Lcom/google/aiplugin/agents/ToolHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/agents/tools/search/FindFilesArgs;", "maxResults", "", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/agents/tools/search/FindFilesArgs;I)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/agents/tools/search/FindFilesArgs;", "getMaxResults", "()I", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toJson", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "FileNameCollector", "aiplugin.agents.agents-core"})
@SourceDebugExtension(value={"SMAP\nFindFilesTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindFilesTool.kt\ncom/google/aiplugin/agents/tools/search/FindFilesHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1563#2:130\n1634#2,3:131\n1374#2:134\n1460#2,5:135\n774#2:140\n865#2,2:141\n774#2:143\n865#2,2:144\n1056#2:146\n*S KotlinDebug\n*F\n+ 1 FindFilesTool.kt\ncom/google/aiplugin/agents/tools/search/FindFilesHandler\n*L\n126#1:130\n126#1:131,3\n113#1:134\n113#1:135,5\n114#1:140\n114#1:141,2\n115#1:143\n115#1:144,2\n116#1:146\n*E\n"})
public final class FindFilesHandler
implements ToolHandler {
    @NotNull
    private final ToolContext context;
    @NotNull
    private final FindFilesArgs args;
    private final int maxResults;

    public FindFilesHandler(@NotNull ToolContext context2, @NotNull FindFilesArgs args, int maxResults) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.context = context2;
        this.args = args;
        this.maxResults = maxResults;
    }

    @NotNull
    public final ToolContext getContext() {
        return this.context;
    }

    @NotNull
    public final FindFilesArgs getArgs() {
        return this.args;
    }

    public final int getMaxResults() {
        return this.maxResults;
    }

    @Override
    @Nullable
    public Object handle(@NotNull Continuation<? super Response> $completion) {
        String string = this.args.getQuery();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String pathQuery = string2;
        AiExcludeService aiExcludeService2 = AiExcludeService.Companion.getInstance(this.context.getProject());
        List files2 = (List)ActionsKt.runReadAction(() -> FindFilesHandler.handle$lambda$4(this, pathQuery, aiExcludeService2));
        return new Response(this.toJson(files2), null, null, null, null, 30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String toJson(List<? extends VirtualFile> files2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = files2;
        Gson gson = new Gson();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ$\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0015"}, d2={"com/google/aiplugin/agents/tools/search/FindFilesHandler$toJson$FilePath", "", "path", "", "isDirectory", "", "<init>", "(Ljava/lang/String;Ljava/lang/Boolean;)V", "getPath", "()Ljava/lang/String;", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Boolean;)Lcom/google/aiplugin/agents/tools/search/FindFilesHandler$toJson$FilePath;", "equals", "other", "hashCode", "", "toString", "aiplugin.agents.agents-core"})
            public final class FilePath {
                private final String path;
                private final Boolean isDirectory;

                public FilePath(String path2, Boolean isDirectory) {
                    Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                    this.path = path2;
                    this.isDirectory = isDirectory;
                }

                public final String getPath() {
                    return this.path;
                }

                public final Boolean isDirectory() {
                    return this.isDirectory;
                }

                public final String component1() {
                    return this.path;
                }

                public final Boolean component2() {
                    return this.isDirectory;
                }

                public final FilePath copy(String path2, Boolean isDirectory) {
                    Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                    return new FilePath(path2, isDirectory);
                }

                public static /* synthetic */ FilePath copy$default(FilePath filePath, String string, Boolean bl, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = filePath.path;
                    }
                    if ((n & 2) != 0) {
                        bl = filePath.isDirectory;
                    }
                    return filePath.copy(string, bl);
                }

                public String toString() {
                    return "FilePath(path=" + this.path + ", isDirectory=" + this.isDirectory + ")";
                }

                public int hashCode() {
                    int result2 = this.path.hashCode();
                    result2 = result2 * 31 + (this.isDirectory == null ? 0 : ((Object)this.isDirectory).hashCode());
                    return result2;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof FilePath)) {
                        return false;
                    }
                    FilePath filePath = (FilePath)other;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)filePath.path)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.isDirectory, (Object)filePath.isDirectory);
                }
            }
            collection.add(new FilePath(string, it.isDirectory() ? Boolean.valueOf(true) : null));
        }
        String string = gson.toJson((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List handle$lambda$4(FindFilesHandler this$0, String $pathQuery, AiExcludeService $aiExcludeService) {
        void $this$sortedBy$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this$0.context.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope scope2 = globalSearchScope;
        Path path2 = Paths.get($pathQuery, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        FileNameCollector fileNameCollector = new FileNameCollector(PathsKt.getName((Path)path2));
        FilenameIndex.processAllFileNames((Processor)fileNameCollector, (GlobalSearchScope)scope2, null);
        Iterable iterable = fileNameCollector.getFileNames();
        boolean $i$f$flatMap = false;
        void var7_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Collection collection = FilenameIndex.getVirtualFilesByName((String)it, (GlobalSearchScope)scope2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!StringsKt.contains((CharSequence)string, (CharSequence)$pathQuery, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(!$aiExcludeService.isFileExcluded((VirtualFile)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.take((Iterable)CollectionsKt.toSet((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VirtualFile it = (VirtualFile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPath());
                it = (VirtualFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
            }
        })), (int)this$0.maxResults);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/google/aiplugin/agents/tools/search/FindFilesHandler$FileNameCollector;", "Lcom/intellij/util/Processor;", "", "baseNamePart", "<init>", "(Ljava/lang/String;)V", "getBaseNamePart", "()Ljava/lang/String;", "fileNames", "", "getFileNames", "()Ljava/util/Set;", "process", "", "name", "aiplugin.agents.agents-core"})
    private static final class FileNameCollector
    implements Processor<String> {
        @NotNull
        private final String baseNamePart;
        @NotNull
        private final Set<String> fileNames;

        public FileNameCollector(@NotNull String baseNamePart) {
            Intrinsics.checkNotNullParameter((Object)baseNamePart, (String)"baseNamePart");
            this.baseNamePart = baseNamePart;
            this.fileNames = new LinkedHashSet();
        }

        @NotNull
        public final String getBaseNamePart() {
            return this.baseNamePart;
        }

        @NotNull
        public final Set<String> getFileNames() {
            return this.fileNames;
        }

        public boolean process(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (StringsKt.contains((CharSequence)name, (CharSequence)this.baseNamePart, (boolean)true)) {
                this.fileNames.add(name);
            }
            return true;
        }
    }
}

