/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.read;

import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.permissions.PermissionDecision;
import com.google.aiplugin.agents.tools.SettableApprovalProvider;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.UserApprovalProvider;
import com.google.aiplugin.agents.tools.read.ReadUrlArgs;
import com.google.aiplugin.agents.tools.read.ReadUrlHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/google/aiplugin/agents/tools/read/ReadUrlHandlerImpl;", "Lcom/google/aiplugin/agents/tools/read/ReadUrlHandler;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "args", "Lcom/google/aiplugin/agents/tools/read/ReadUrlArgs;", "<init>", "(Lcom/google/aiplugin/agents/tools/ToolContext;Lcom/google/aiplugin/agents/tools/read/ReadUrlArgs;)V", "getContext", "()Lcom/google/aiplugin/agents/tools/ToolContext;", "getArgs", "()Lcom/google/aiplugin/agents/tools/read/ReadUrlArgs;", "approvalProvider", "Lcom/google/aiplugin/agents/tools/SettableApprovalProvider;", "getApprovalProvider", "()Lcom/google/aiplugin/agents/tools/SettableApprovalProvider;", "handle", "Lcom/google/aiplugin/agents/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aiplugin.agents.agents-core"})
public final class ReadUrlHandlerImpl
implements ReadUrlHandler {
    @NotNull
    private final ToolContext context;
    @NotNull
    private final ReadUrlArgs args;
    @Nullable
    private final SettableApprovalProvider approvalProvider;

    public ReadUrlHandlerImpl(@NotNull ToolContext context2, @NotNull ReadUrlArgs args) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.context = context2;
        this.args = args;
        UserApprovalProvider userApprovalProvider = this.context.getUserApprovalProvider();
        this.approvalProvider = userApprovalProvider instanceof SettableApprovalProvider ? (SettableApprovalProvider)userApprovalProvider : null;
    }

    @NotNull
    public final ToolContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public ReadUrlArgs getArgs() {
        return this.args;
    }

    @Override
    @Nullable
    public SettableApprovalProvider getApprovalProvider() {
        return this.approvalProvider;
    }

    @Override
    @Nullable
    public Object handle(@NotNull Continuation<? super Response> $completion) {
        Object object;
        URI uRI;
        Object approval;
        Object object2 = this.context.getUserApprovalProvider();
        if (object2 == null || (object2 = object2.getApprovalStatus()) == null) {
            object2 = UserApprovalProvider.ApprovalStatus.AutoApproved.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)(approval = object2), (Object)UserApprovalProvider.ApprovalStatus.Rejected.INSTANCE)) {
            return new Response(null, "User did not approve reading that URL.", null, null, null, 29, null);
        }
        try {
            uRI = new URI(this.getArgs().getUrl());
        }
        catch (URISyntaxException e) {
            String string = e.getMessage();
            return new Response(null, "Error: Not a valid URL: " + (string != null ? StringsKt.removeSuffix((String)string, (CharSequence)": Not a valid URL") : null), null, null, null, 29, null);
        }
        URI uri = uRI;
        HttpClient client2 = HttpClient.newHttpClient();
        try {
            object = HttpRequest.newBuilder().uri(uri).GET().build();
        }
        catch (Exception e) {
            return new Response(null, "Error: Invalid request: " + e.getMessage(), null, null, null, 29, null);
        }
        HttpRequest request2 = object;
        try {
            HttpResponse<String> response2 = client2.send(request2, HttpResponse.BodyHandlers.ofString());
            if (response2.statusCode() == 200) {
                Response response3;
                String body = response2.body();
                if (body.length() > 30000) {
                    Intrinsics.checkNotNull((Object)body);
                    String truncated = StringsKt.take((String)body, (int)30000);
                    response3 = new Response(truncated + "\n <truncated>", null, null, null, null, 30, null);
                } else {
                    response3 = new Response(body, null, null, null, null, 30, null);
                }
                return response3;
            }
            object = new Response(null, "The URL request resulted in an error with status code " + response2.statusCode(), null, null, null, 29, null);
        }
        catch (Exception e) {
            object = new Response(null, "The URL request resulted in an error: " + e.getMessage(), null, null, null, 29, null);
        }
        return object;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PermissionDecision.values().length];
            try {
                nArray[PermissionDecision.APPROVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionDecision.DENIED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PermissionDecision.ASK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

