/*
 * Decompiled with CFR 0.152.
 */
package com.google.aiplugin.agents.tools.analyze;

import com.google.common.collect.ComparisonChain;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0012\u001a\u00020\u00032\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0011\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/google/aiplugin/agents/tools/analyze/Warning;", "", "description", "", "severity", "Lcom/google/aiplugin/agents/tools/analyze/Warning$Severity;", "startOffset", "", "endOffset", "<init>", "(Ljava/lang/String;Lcom/google/aiplugin/agents/tools/analyze/Warning$Severity;II)V", "getDescription", "()Ljava/lang/String;", "getSeverity", "()Lcom/google/aiplugin/agents/tools/analyze/Warning$Severity;", "getStartOffset", "()I", "getEndOffset", "describe", "fileText", "toString", "compareTo", "other", "Severity", "aiplugin.agents.agents-core"})
@SourceDebugExtension(value={"SMAP\nFileCritic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileCritic.kt\ncom/google/aiplugin/agents/tools/analyze/Warning\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,401:1\n1#2:402\n*E\n"})
public final class Warning
implements Comparable<Warning> {
    @NotNull
    private final String description;
    @NotNull
    private final Severity severity;
    private final int startOffset;
    private final int endOffset;

    public Warning(@NotNull String description, @NotNull Severity severity, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        this.description = description;
        this.severity = severity;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final Severity getSeverity() {
        return this.severity;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    @NotNull
    public final String describe(@Nullable String fileText2) {
        StringBuilder stringBuilder;
        Warning warning = this;
        StringBuilder $this$describe_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$describe_u24lambda_u241.append("* " + StringsKt.removeSuffix((String)warning.description, (CharSequence)"."));
        if (fileText2 != null) {
            int endOffset = Math.min(warning.endOffset, fileText2.length());
            int startOffset = Math.min(warning.startOffset, endOffset);
            int lineStart = StringsKt.lastIndexOf$default((CharSequence)fileText2, (char)'\n', (int)Math.max(0, startOffset - 1), (boolean)false, (int)4, null) + 1;
            int pos = StringsKt.indexOf$default((CharSequence)fileText2, (char)'\n', (int)lineStart, (boolean)false, (int)4, null);
            boolean bl2 = false;
            int lineEnd = pos == -1 ? fileText2.length() : pos;
            String string = fileText2.substring(lineStart, lineEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String lineText = string;
            String string2 = fileText2.substring(startOffset, endOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String rangeText = string2;
            if (endOffset == lineEnd) {
                v2 = $this$describe_u24lambda_u241.append(" at the end of the line `" + ((Object)StringsKt.trim((CharSequence)lineText)).toString() + "`");
            } else if (!StringsKt.isBlank((CharSequence)rangeText)) {
                v2 = $this$describe_u24lambda_u241.append(" for the text `" + rangeText + "` on the line `" + ((Object)StringsKt.trim((CharSequence)lineText)).toString());
            } else {
                String string3 = fileText2.substring(lineStart, startOffset);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                if (StringsKt.isBlank((CharSequence)string3)) {
                    v2 = $this$describe_u24lambda_u241.append(" on the line " + ((Object)StringsKt.trim((CharSequence)lineText)).toString());
                } else {
                    String string4 = fileText2.substring(startOffset, lineEnd);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    v2 = $this$describe_u24lambda_u241.append(" at `" + ((Object)StringsKt.trimEnd((CharSequence)string4)).toString() + "`");
                }
            }
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String describe$default(Warning warning, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return warning.describe(string);
    }

    @NotNull
    public String toString() {
        return this.describe(null);
    }

    @Override
    public int compareTo(@NotNull Warning other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ComparisonChain.start().compare((Comparable)((Object)this.severity), (Comparable)((Object)other.severity)).compare(this.startOffset, other.startOffset).compare(this.endOffset, other.endOffset).compare((Comparable)((Object)this.description), (Comparable)((Object)other.description)).result();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/aiplugin/agents/tools/analyze/Warning$Severity;", "", "<init>", "(Ljava/lang/String;I)V", "ERROR", "WARNING", "WEAK_WARNING", "aiplugin.agents.agents-core"})
    public static final class Severity
    extends Enum<Severity> {
        public static final /* enum */ Severity ERROR = new Severity();
        public static final /* enum */ Severity WARNING = new Severity();
        public static final /* enum */ Severity WEAK_WARNING = new Severity();
        private static final /* synthetic */ Severity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Severity[] values() {
            return (Severity[])$VALUES.clone();
        }

        public static Severity valueOf(String value) {
            return Enum.valueOf(Severity.class, value);
        }

        @NotNull
        public static EnumEntries<Severity> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = severityArray = new Severity[]{Severity.ERROR, Severity.WARNING, Severity.WEAK_WARNING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

