/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.templates.settings;

import com.android.studio.ml.templates.BuiltInPromptsProvider;
import com.android.studio.ml.templates.PromptTemplateImpl;
import com.android.studio.ml.templates.PromptTemplateMacros;
import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.ide.highlighter.custom.AbstractCustomLexer;
import com.intellij.ide.highlighter.custom.tokens.PrefixedTokenParser;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PromptTemplateHighlighter
extends SyntaxHighlighterBase {
    private final TextAttributesKey[] MACRO_ATTRIBUTES = PromptTemplateHighlighter.pack((TextAttributesKey)TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES);
    private final Lexer lexer;

    public static PromptTemplateHighlighter createNew(PromptTemplateImpl template) {
        BuiltInPromptsProvider group2 = template == null ? null : template.getGroup();
        List<String> macrosToHighlight = group2 != null ? group2.macros().stream().map(BuiltInPromptsProvider.Macro::getKey).toList() : PromptTemplateMacros.INSTANCE.allMacros();
        return new PromptTemplateHighlighter(macrosToHighlight);
    }

    private PromptTemplateHighlighter(Collection<String> macros) {
        this.lexer = new MacroLexer(macros);
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return this.lexer;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        if (tokenType == PromptTemplateTokenType.MACRO) {
            return this.MACRO_ATTRIBUTES;
        }
        return TextAttributesKey.EMPTY_ARRAY;
    }

    public static class MacroLexer
    extends AbstractCustomLexer {
        public MacroLexer(Collection<String> macros) {
            super(macros.stream().map(s -> new KeywordParser("$" + s, PromptTemplateTokenType.MACRO)).toList());
        }

        protected void handleTokenNotFound() {
            int end;
            for (end = this.myPosition + 1; end < this.myEndOffset && this.myBuffer.charAt(end) != '$'; ++end) {
            }
            this.myCurrentToken.updateData(this.myPosition, end, CustomHighlighterTokenType.CHARACTER);
        }
    }

    static interface PromptTemplateTokenType {
        public static final IElementType TEXT = new IElementType("TEXT", Language.ANY);
        public static final IElementType MACRO = new IElementType("MACRO", Language.ANY);
    }

    public static class KeywordParser
    extends PrefixedTokenParser {
        public KeywordParser(String keyword, IElementType tokenType) {
            super(keyword, tokenType);
        }

        protected int getTokenEnd(int position) {
            return position;
        }
    }
}

