/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.suggestion.controls.viewmodel;

import com.android.studio.ml.suggestion.AnchoredDiffChunk;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplayKt;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplayRow;
import com.android.studio.ml.suggestion.controls.viewmodel.CodeDisplaySnippet;
import com.android.studio.ml.suggestion.controls.viewmodel.ConstructedDocument;
import com.android.studio.ml.suggestion.controls.viewmodel.DiffStyle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a?\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\b\fH\u0001\u001a(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a \u0010 \u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0011H\u0001\u00a8\u0006\""}, d2={"buildDocumentFromChunks", "Lcom/android/studio/ml/suggestion/controls/viewmodel/ConstructedDocument;", "chunks", "", "Lcom/android/studio/ml/suggestion/AnchoredDiffChunk;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChunkContent", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "createCodeDisplayRow", "Lcom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplayRow;", "sourceChunk", "lineNumber", "", "constructedDocument", "diffStyle", "Lcom/android/studio/ml/suggestion/controls/viewmodel/DiffStyle;", "createHighlightedRowsForChunk", "chunk", "createHighlightedRowsOriginalLines", "createHighlightedSnippetsForSingleLineChunk", "Lcom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplaySnippet;", "getHighlightedSnippets", "content", "textRange", "Lcom/intellij/openapi/util/TextRange;", "highlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "getSubRangeForLine", "lineNumberInTextRange", "aiplugin.core.aicore"})
@SourceDebugExtension(value={"SMAP\nCodeDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeDisplay.kt\ncom/android/studio/ml/suggestion/controls/viewmodel/CodeDisplayKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
public final class CodeDisplayKt {
    @NotNull
    public static final List<CodeDisplayRow> createHighlightedRowsForChunk(@NotNull AnchoredDiffChunk chunk, @NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        int index;
        List list;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        List chunks = CollectionsKt.listOf((Object)chunk);
        ConstructedDocument originalConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedRowsForChunk.originalConstructedDocument.1.INSTANCE));
        ConstructedDocument newConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedRowsForChunk.newConstructedDocument.1.INSTANCE));
        List $this$createHighlightedRowsForChunk_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = ((Collection)chunk.getOriginalContentLines()).size();
        for (index = 0; index < n; ++index) {
            $this$createHighlightedRowsForChunk_u24lambda_u240.add(CodeDisplayKt.createCodeDisplayRow(chunk, index, originalConstructedDocument2, DiffStyle.Original));
        }
        n = ((Collection)chunk.getNewContentLines()).size();
        for (index = 0; index < n; ++index) {
            $this$createHighlightedRowsForChunk_u24lambda_u240.add(CodeDisplayKt.createCodeDisplayRow(chunk, index, newConstructedDocument2, DiffStyle.New));
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public static final List<CodeDisplayRow> createHighlightedRowsOriginalLines(@NotNull AnchoredDiffChunk chunk, @NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        List chunks = CollectionsKt.listOf((Object)chunk);
        ConstructedDocument originalConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedRowsOriginalLines.originalConstructedDocument.1.INSTANCE));
        List $this$createHighlightedRowsOriginalLines_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = ((Collection)chunk.getOriginalContentLines()).size();
        for (int index = 0; index < n; ++index) {
            $this$createHighlightedRowsOriginalLines_u24lambda_u241.add(CodeDisplayKt.createCodeDisplayRow(chunk, index, originalConstructedDocument2, DiffStyle.Original));
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public static final List<CodeDisplaySnippet> createHighlightedSnippetsForSingleLineChunk(@NotNull AnchoredDiffChunk chunk, @NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        List chunks = CollectionsKt.listOf((Object)chunk);
        ConstructedDocument originalConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedSnippetsForSingleLineChunk.originalConstructedDocument.1.INSTANCE));
        ConstructedDocument newConstructedDocument2 = CodeDisplayKt.buildDocumentFromChunks(chunks, project2, virtualFile2, (Function1<? super AnchoredDiffChunk, String>)((Function1)createHighlightedSnippetsForSingleLineChunk.newConstructedDocument.1.INSTANCE));
        TextRange textRange = originalConstructedDocument2.getChunkToRange().get(chunk);
        if (textRange == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        TextRange textRange2 = newConstructedDocument2.getChunkToRange().get(chunk);
        if (textRange2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.plus((Collection)CodeDisplayKt.getHighlightedSnippets(originalConstructedDocument2.getContent(), textRange, originalConstructedDocument2.getHighlighter(), DiffStyle.Original), (Iterable)CodeDisplayKt.getHighlightedSnippets(newConstructedDocument2.getContent(), textRange2, newConstructedDocument2.getHighlighter(), DiffStyle.New));
    }

    private static final CodeDisplayRow createCodeDisplayRow(AnchoredDiffChunk sourceChunk, int lineNumber, ConstructedDocument constructedDocument, DiffStyle diffStyle) {
        TextRange textRange = constructedDocument.getChunkToRange().get(sourceChunk);
        if (textRange == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return new CodeDisplayRow(CodeDisplayKt.getHighlightedSnippets(constructedDocument.getContent(), CodeDisplayKt.getSubRangeForLine(constructedDocument.getContent(), textRange, lineNumber), constructedDocument.getHighlighter(), diffStyle));
    }

    @VisibleForTesting
    @NotNull
    public static final ConstructedDocument buildDocumentFromChunks(@NotNull List<? extends AnchoredDiffChunk> chunks, @NotNull Project project2, @NotNull VirtualFile virtualFile2, @NotNull Function1<? super AnchoredDiffChunk, String> getChunkContent) {
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(getChunkContent, (String)"getChunkContent");
        Document document2 = ((AnchoredDiffChunk)CollectionsKt.first(chunks)).getRangeMarker().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        String string = document3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String documentText = string;
        int startOffsetInDocument = 0;
        StringBuilder contentBuilder = new StringBuilder();
        Map chunkToRange = new LinkedHashMap();
        for (AnchoredDiffChunk anchoredDiffChunk : chunks) {
            TextRange chunkTextRangeInDocument;
            Intrinsics.checkNotNullExpressionValue((Object)anchoredDiffChunk.getRangeMarker().getTextRange(), (String)"getTextRange(...)");
            int chunkStartOffsetInDocument = chunkTextRangeInDocument.getStartOffset();
            if (chunkStartOffsetInDocument > startOffsetInDocument) {
                String string2 = documentText.substring(startOffsetInDocument, chunkStartOffsetInDocument);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                contentBuilder.append(string2);
            }
            String chunkContent = (String)getChunkContent.invoke((Object)anchoredDiffChunk);
            chunkToRange.put(anchoredDiffChunk, new TextRange(contentBuilder.length(), contentBuilder.length() + chunkContent.length()));
            contentBuilder.append(chunkContent);
            startOffsetInDocument = chunkTextRangeInDocument.getEndOffset();
        }
        if (startOffsetInDocument < documentText.length()) {
            String string3 = documentText.substring(startOffsetInDocument);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            contentBuilder.append(string3);
        }
        String string4 = contentBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String content2 = string4;
        EditorHighlighter editorHighlighter2 = (EditorHighlighter)ActionsKt.runReadAction((Function0)((Function0)new Function0<EditorHighlighter>(project2, virtualFile2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$project = $project;
                this.$virtualFile = $virtualFile;
                super(0);
            }

            public final EditorHighlighter invoke() {
                return EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(this.$project, this.$virtualFile);
            }
        }));
        editorHighlighter2.setText((CharSequence)content2);
        return new ConstructedDocument(content2, MapsKt.toMap((Map)chunkToRange), editorHighlighter2);
    }

    @VisibleForTesting
    @NotNull
    public static final TextRange getSubRangeForLine(@NotNull String content2, @NotNull TextRange textRange, int lineNumberInTextRange) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        String string = content2;
        int n = textRange.getStartOffset();
        int n2 = textRange.getEndOffset();
        String string2 = string.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String textRangeContent = string2;
        int startOffset = 0;
        for (n = 0; n < lineNumberInTextRange; ++n) {
            int it = n;
            boolean bl = false;
            if (!((startOffset = StringsKt.indexOf$default((CharSequence)textRangeContent, (char)'\n', (int)startOffset, (boolean)false, (int)4, null)) != -1)) {
                String string3 = "Failed requirement.";
                throw new IllegalArgumentException(string3.toString());
            }
            ++startOffset;
        }
        Object object = StringsKt.indexOf$default((CharSequence)textRangeContent, (char)'\n', (int)startOffset, (boolean)false, (int)4, null);
        int it = ((Number)object).intValue();
        boolean bl = false;
        Object object2 = it != -1 ? object : null;
        int endOffset = object2 != null ? ((Integer)object2).intValue() : textRangeContent.length();
        if (!(endOffset >= startOffset)) {
            object = "Failed requirement.";
            throw new IllegalArgumentException(object.toString());
        }
        return new TextRange(startOffset + textRange.getStartOffset(), endOffset + textRange.getStartOffset());
    }

    private static final List<CodeDisplaySnippet> getHighlightedSnippets(String content2, TextRange textRange, EditorHighlighter highlighter2, DiffStyle diffStyle) {
        List list;
        if (textRange.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        HighlighterIterator highlighterIterator = highlighter2.createIterator(textRange.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        List $this$getHighlightedSnippets_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (!iterator.atEnd() && iterator.getStart() < textRange.getEndOffset()) {
            String text2;
            int startOffsetInContent = RangesKt.coerceAtLeast((int)iterator.getStart(), (int)textRange.getStartOffset());
            int endOffsetInContent = RangesKt.coerceAtMost((int)iterator.getEnd(), (int)textRange.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)content2.substring(startOffsetInContent, endOffsetInContent), (String)"substring(...)");
            TextAttributes baseAttributes = iterator.getTextAttributes();
            $this$getHighlightedSnippets_u24lambda_u244.add(new CodeDisplaySnippet(text2, diffStyle, baseAttributes));
            iterator.advance();
        }
        return CollectionsKt.build((List)list);
    }
}

