/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.npa.tools;

import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.android.studio.ml.npa.tools.MemoryTools;
import com.android.studio.ml.npa.tools.PlanStep;
import com.android.studio.ml.npa.tools.ProjectPlan;
import com.android.studio.ml.npa.tools.TaskStatus;
import com.google.aiplugin.agents.Response;
import com.google.aiplugin.agents.tools.DeclarativeToolSet;
import com.google.aiplugin.agents.tools.ToolContext;
import com.google.aiplugin.agents.tools.ToolFunction;
import com.google.gson.Gson;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 62\u00020\u0001:\u00016B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u001eJ\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u0019\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010$\u001a\u00020\u0005H\u0001\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u0017\u0010(\u001a\u0004\u0018\u00010\"2\u0006\u0010)\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010&J\u0012\u0010*\u001a\u0004\u0018\u00010\t2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\tH\u0002J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010/\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0005H\u0007J(\u00101\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00052\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0005H\u0007J\u0006\u00105\u001a\u00020\u0005R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u00067"}, d2={"Lcom/android/studio/ml/npa/tools/PlanTools;", "Lcom/google/aiplugin/agents/tools/DeclarativeToolSet;", "globalMemory", "Lcom/android/studio/ml/npa/tools/MemoryTools;", "prefix", "", "<init>", "(Lcom/android/studio/ml/npa/tools/MemoryTools;Ljava/lang/String;)V", "currentPlan", "Lcom/android/studio/ml/npa/tools/ProjectPlan;", "getCurrentPlan", "()Lcom/android/studio/ml/npa/tools/ProjectPlan;", "setCurrentPlan", "(Lcom/android/studio/ml/npa/tools/ProjectPlan;)V", "handlePlanChange", "Lcom/intellij/openapi/vfs/VirtualFile;", "context", "Lcom/google/aiplugin/agents/tools/ToolContext;", "saveProjectDescription", "", "projectDescription", "saveProjectBrief", "projectBrief", "savePlanSteps", "Lcom/google/aiplugin/agents/Response;", "steps", "", "findPlanDirectory", "getOrCreatePlanDirectory", "updatePlanFile", "updatePlanFile$aiplugin_android", "reloadPlan", "formatDuration", "millis", "", "parseDuration", "durationStr", "parseDuration$aiplugin_android", "(Ljava/lang/String;)Ljava/lang/Long;", "formatTimestamp", "parseTimestamp", "timestampStr", "parsePlanFromMarkdown", "content", "generateMarkdown", "plan", "getNextTask", "getTaskDetails", "task_id", "updateTask", "status", "Lcom/android/studio/ml/npa/tools/TaskStatus;", "detailed_updates", "getPlanSummary", "Companion", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPlanTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanTools.kt\ncom/android/studio/ml/npa/tools/PlanTools\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,626:1\n1563#2:627\n1634#2,2:628\n1636#2:631\n1208#2,2:632\n1236#2,4:634\n1869#2,2:638\n1869#2:646\n1869#2,2:647\n1870#2:649\n295#2,2:650\n967#2,7:652\n774#2:659\n865#2,2:660\n360#2,7:662\n360#2,7:669\n1563#2:676\n1634#2,3:677\n1617#2,9:680\n1869#2:689\n1870#2:691\n1626#2:692\n222#3:630\n24#4:640\n24#4:641\n24#4:642\n24#4:643\n24#4:644\n24#4:693\n1#5:645\n1#5:690\n*S KotlinDebug\n*F\n+ 1 PlanTools.kt\ncom/android/studio/ml/npa/tools/PlanTools\n*L\n152#1:627\n152#1:628,2\n152#1:631\n162#1:632,2\n162#1:634,4\n163#1:638,2\n431#1:646\n439#1:647,2\n431#1:649\n474#1:650,2\n486#1:652,7\n486#1:659\n486#1:660,2\n489#1:662,7\n490#1:669,7\n363#1:676\n363#1:677,3\n384#1:680,9\n384#1:689\n384#1:691\n384#1:692\n152#1:630\n175#1:640\n212#1:641\n233#1:642\n265#1:643\n412#1:644\n403#1:693\n384#1:690\n*E\n"})
public final class PlanTools
extends DeclarativeToolSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final MemoryTools globalMemory;
    @NotNull
    private final String prefix;
    @Nullable
    private ProjectPlan currentPlan;
    public static final int $stable = 8;
    @NotNull
    private static final String AGENT_DIR_NAME = ".agent";
    @NotNull
    private static final String PLAN_FILE_NAME = "plan.md";

    public PlanTools(@Nullable MemoryTools globalMemory, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        super(prefix);
        this.globalMemory = globalMemory;
        this.prefix = prefix;
    }

    public /* synthetic */ PlanTools(MemoryTools memoryTools, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            memoryTools = null;
        }
        if ((n & 2) != 0) {
            string = "planner";
        }
        this(memoryTools, string);
    }

    @Nullable
    public final ProjectPlan getCurrentPlan() {
        return this.currentPlan;
    }

    public final void setCurrentPlan(@Nullable ProjectPlan projectPlan) {
        this.currentPlan = projectPlan;
    }

    @Nullable
    public final VirtualFile handlePlanChange(@NotNull ToolContext context2) {
        VirtualFile planFile;
        block2: {
            String planSummary;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (this.globalMemory != null && (planSummary = this.getPlanSummary()) != null) {
                MemoryTools memoryTools = this.globalMemory;
                if (memoryTools != null) {
                    memoryTools.noteDown(context2, "Project plan", planSummary, true, this.prefix);
                }
            }
            VirtualFile virtualFile2 = planFile = this.updatePlanFile$aiplugin_android(context2);
            if (virtualFile2 == null) break block2;
            VirtualFile file = virtualFile2;
            boolean bl = false;
            ApplicationManager.getApplication().invokeLater(() -> PlanTools.handlePlanChange$lambda$1$lambda$0(context2, file));
        }
        return planFile;
    }

    public final void saveProjectDescription(@NotNull String projectDescription) {
        Intrinsics.checkNotNullParameter((Object)projectDescription, (String)"projectDescription");
        if (this.currentPlan == null) {
            this.currentPlan = new ProjectPlan(projectDescription, "", CollectionsKt.emptyList());
        } else {
            ProjectPlan projectPlan = this.currentPlan;
            Intrinsics.checkNotNull((Object)projectPlan);
            projectPlan.setProjectDescription(projectDescription);
        }
    }

    public final void saveProjectBrief(@NotNull String projectBrief) {
        Intrinsics.checkNotNullParameter((Object)projectBrief, (String)"projectBrief");
        CharSequence charSequence = projectBrief;
        Regex regex = new Regex("\\s*\\n\\s*(\\**):");
        String string = "$1:";
        String sanitizedBrief = regex.replace(charSequence, string);
        if (this.currentPlan == null) {
            this.currentPlan = new ProjectPlan("", sanitizedBrief, CollectionsKt.emptyList());
        } else {
            ProjectPlan projectPlan = this.currentPlan;
            Intrinsics.checkNotNull((Object)projectPlan);
            projectPlan.setProjectBrief(sanitizedBrief);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ToolFunction(name="save_plan_steps", description="\n          Saves the steps for a project plan. Also returns next pending task from current plan.\n\n          Args:\n            steps: A list of strings, where each string is a JSON object representing a single plan step.\n                   Each JSON object must conform to the PlanStep structure:\n                   - id: (String) A unique identifier for the step.\n                   - description: (String) A detailed description of the task.\n                   - status: (String, optional) The current status of the task. Defaults to PENDING.\n                             Possible values: PENDING, IN_PROGRESS, COMPLETED, BLOCKED.\n                   - detailedUpdates: (String, optional) Any detailed updates or notes for the task.\n                   - acceptanceCriteria: (List<String>, optional) A list of conditions that must be met for the step to be considered complete.\n\n                   Example of a single step string:\n                   '{\"id\":\"1\",\"description\":\"Set up the project repository\",\"status\":\"PENDING\",\"acceptanceCriteria\":[\"Repo is created on GitHub\",\"README.md is present\"]}'\n          ", displayText="Saving the project plan steps.")
    @NotNull
    public final Response savePlanSteps(@NotNull ToolContext context2, @NotNull List<String> steps) {
        Response nextTask;
        PlanStep this_$iv;
        Object object;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        try {
            void $this$mapTo$iv$iv;
            $this$map$iv = steps;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Iterator it;
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Json json = (Json)Json.Default;
                void string$iv = it;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                object.add((PlanStep)this_$iv.decodeFromString((DeserializationStrategy)PlanStep.Companion.serializer(), (String)string$iv));
            }
            $this$map$iv = (List)destination$iv$iv;
        }
        catch (SerializationException e) {
            return new Response("Failed to parse steps from JSON: " + e.getMessage(), null, null, null, null, 30, null);
        }
        catch (Exception e) {
            return new Response("Failed to parse plan steps: " + e + ": " + e.getMessage(), null, null, null, null, 30, null);
        }
        Iterable newPlanSteps = $this$map$iv;
        if (this.currentPlan == null) {
            this.currentPlan = new ProjectPlan("", "", (List<PlanStep>)newPlanSteps);
        } else {
            void $this$associateByTo$iv$iv;
            ProjectPlan projectPlan = this.currentPlan;
            Intrinsics.checkNotNull((Object)projectPlan);
            Iterable $this$associateBy$iv = projectPlan.getSteps();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable $i$f$mapTo = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                this_$iv = (PlanStep)element$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.put(it.getId(), element$iv$iv);
            }
            Map oldStepsById = destination$iv$iv;
            Iterable $this$forEach$iv = newPlanSteps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PlanStep newStep = (PlanStep)element$iv;
                boolean bl = false;
                PlanStep oldStep = (PlanStep)oldStepsById.get(newStep.getId());
                if (oldStep == null || newStep.getDurationMillis() != null) continue;
                newStep.setDurationMillis(oldStep.getDurationMillis());
            }
            ProjectPlan projectPlan2 = this.currentPlan;
            Intrinsics.checkNotNull((Object)projectPlan2);
            projectPlan2.setSteps((List<PlanStep>)newPlanSteps);
        }
        VirtualFile planFile = this.handlePlanChange(context2);
        Object responseStr = "Plan saved successfully.";
        if (planFile == null) {
            PlanTools $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PlanTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((String)responseStr + "\n plan.md file was not created/updated.");
        }
        responseStr = (nextTask = this.getNextTask(context2)).getError() == null ? (String)responseStr + "\n Here is the next task " + nextTask.getStatus() : (String)responseStr + "\n Could not fetch next task - error:  " + nextTask.getError();
        return new Response((String)responseStr, null, null, null, null, 30, null);
    }

    private final VirtualFile findPlanDirectory(ToolContext context2) {
        VirtualFile projectBaseDir;
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)context2.getProject()).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        VirtualFile virtualFile2 = projectBaseDir = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
        return virtualFile2 != null ? virtualFile2.findChild(AGENT_DIR_NAME) : null;
    }

    private final VirtualFile getOrCreatePlanDirectory(ToolContext context2) {
        VirtualFile virtualFile2;
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)context2.getProject()).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        VirtualFile virtualFile3 = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile projectBaseDir = virtualFile3;
        try {
            virtualFile2 = (VirtualFile)WriteAction.computeAndWait(() -> PlanTools.getOrCreatePlanDirectory$lambda$5(projectBaseDir, this));
        }
        catch (IOException e) {
            PlanTools $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PlanTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to create or find .agent directory", (Throwable)e);
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    @VisibleForTesting
    @Nullable
    public final VirtualFile updatePlanFile$aiplugin_android(@NotNull ToolContext context2) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.currentPlan == null) {
            return null;
        }
        VirtualFile virtualFile3 = this.getOrCreatePlanDirectory(context2);
        if (virtualFile3 == null) {
            return null;
        }
        VirtualFile planDir = virtualFile3;
        ProjectPlan projectPlan = this.currentPlan;
        Intrinsics.checkNotNull((Object)projectPlan);
        String markdownContent = this.generateMarkdown(projectPlan);
        try {
            virtualFile2 = (VirtualFile)WriteAction.computeAndWait(() -> PlanTools.updatePlanFile$lambda$6(planDir, this, markdownContent));
        }
        catch (IOException e) {
            PlanTools $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PlanTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to write plan.md file", (Throwable)e);
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    @ToolFunction(name="reload_plan", description="\n      Reloads a previously persisted project plan from disk, overwriting the current in-memory plan.\n      ", displayText="Reloading plan from disk.")
    @NotNull
    public final Response reloadPlan(@NotNull ToolContext context2) {
        VirtualFile markdownFile;
        VirtualFile planDir;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        VirtualFile virtualFile2 = planDir = this.findPlanDirectory(context2);
        Object object = markdownFile = virtualFile2 != null ? virtualFile2.findChild(PLAN_FILE_NAME) : null;
        if (markdownFile == null || !markdownFile.exists()) {
            return new Response(null, "No plan saved yet.", null, null, null, 29, null);
        }
        try {
            Response response2;
            String string = VfsUtil.loadText((VirtualFile)markdownFile);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
            String content2 = string;
            ProjectPlan parsedPlan = this.parsePlanFromMarkdown(content2);
            if (parsedPlan != null) {
                this.currentPlan = parsedPlan;
                this.handlePlanChange(context2);
                response2 = new Response("Successfully reloaded and synced the plan.", null, null, null, null, 30, null);
            } else {
                response2 = new Response(null, "Failed to load plan.", null, null, null, 29, null);
            }
            return response2;
        }
        catch (IOException e) {
            PlanTools $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PlanTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to read plan.md file: " + e.getMessage());
            return new Response(null, "Failed to load plan.", null, null, null, 29, null);
        }
    }

    private final String formatDuration(long millis) {
        StringBuilder stringBuilder;
        if (millis < 0L) {
            return "N/A";
        }
        long totalSeconds = millis / (long)1000;
        if (totalSeconds < 1L) {
            return "0s";
        }
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) % (long)60;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) % (long)60;
        StringBuilder $this$formatDuration_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (hours > 0L) {
            $this$formatDuration_u24lambda_u247.append(hours + "h ");
        }
        if (minutes > 0L) {
            $this$formatDuration_u24lambda_u247.append(minutes + "m ");
        }
        if (seconds > 0L || ((CharSequence)$this$formatDuration_u24lambda_u247).length() == 0) {
            $this$formatDuration_u24lambda_u247.append(seconds + "s");
        }
        return ((Object)StringsKt.trim((CharSequence)stringBuilder.toString())).toString();
    }

    @VisibleForTesting
    @Nullable
    public final Long parseDuration$aiplugin_android(@NotNull String durationStr) {
        Intrinsics.checkNotNullParameter((Object)durationStr, (String)"durationStr");
        Regex hRegex = new Regex("(\\d+)\\s*h");
        Regex mRegex = new Regex("(\\d+)\\s*m");
        Regex sRegex = new Regex("(\\d+)\\s*s");
        if (!(hRegex.containsMatchIn((CharSequence)durationStr) || mRegex.containsMatchIn((CharSequence)durationStr) || sRegex.containsMatchIn((CharSequence)durationStr))) {
            return null;
        }
        try {
            Object object = Regex.find$default((Regex)hRegex, (CharSequence)durationStr, (int)0, (int)2, null);
            long hours = object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null ? Long.parseLong((String)object) : 0L;
            Object object2 = Regex.find$default((Regex)mRegex, (CharSequence)durationStr, (int)0, (int)2, null);
            long minutes = object2 != null && (object2 = object2.getGroupValues()) != null && (object2 = (String)object2.get(1)) != null ? Long.parseLong((String)object2) : 0L;
            Object object3 = Regex.find$default((Regex)sRegex, (CharSequence)durationStr, (int)0, (int)2, null);
            long seconds = object3 != null && (object3 = object3.getGroupValues()) != null && (object3 = (String)object3.get(1)) != null ? Long.parseLong((String)object3) : 0L;
            return (hours * (long)3600 + minutes * (long)60 + seconds) * (long)1000;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private final String formatTimestamp(long millis) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss z", Locale.US).withZone(ZoneId.systemDefault());
        String string = formatter.format(Instant.ofEpochMilli(millis));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final Long parseTimestamp(String timestampStr) {
        Long l2;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss z", Locale.US);
        try {
            l2 = formatter.parse((CharSequence)timestampStr, Instant::from).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            l2 = StringsKt.toLongOrNull((String)timestampStr);
        }
        return l2;
    }

    private final ProjectPlan parsePlanFromMarkdown(String content2) {
        try {
            Regex mainPattern = new Regex("#\\s*Project Plan:\\s*(.*?)\\s*##\\s*Project Brief\\s*(.*?)\\s*##\\s*Implementation Steps\\s*(.*)", SetsKt.setOf((Object)RegexOption.DOT_MATCHES_ALL));
            MatchResult matchResult = Regex.find$default((Regex)mainPattern, (CharSequence)((Object)StringsKt.trim((CharSequence)content2)).toString(), (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult mainMatch = matchResult;
            MatchResult.Destructured destructured = mainMatch.getDestructured();
            String projectDescription = (String)destructured.getMatch().getGroupValues().get(1);
            String projectBrief = (String)destructured.getMatch().getGroupValues().get(2);
            String stepsContent = (String)destructured.getMatch().getGroupValues().get(3);
            Regex stepPattern = new Regex("###\\s*(.*?)\\n(.*?)(?=\\n###|$)", SetsKt.setOf((Object)RegexOption.DOT_MATCHES_ALL));
            Sequence stepMatches = Regex.findAll$default((Regex)stepPattern, (CharSequence)stepsContent, (int)0, (int)2, null);
            List steps = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)stepMatches, arg_0 -> PlanTools.parsePlanFromMarkdown$lambda$13(this, arg_0)));
            return new ProjectPlan(((Object)StringsKt.trim((CharSequence)projectDescription)).toString(), ((Object)StringsKt.trim((CharSequence)projectBrief)).toString(), steps);
        }
        catch (Exception e) {
            PlanTools $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PlanTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to parse markdown content into a ProjectPlan", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String generateMarkdown(ProjectPlan plan) {
        StringBuilder builder = new StringBuilder();
        builder.append("# Project Plan: " + plan.getProjectDescription()).append('\n');
        builder.append('\n');
        builder.append("## Project Brief").append('\n');
        builder.append('\n');
        builder.append(plan.getProjectBrief()).append('\n');
        builder.append('\n');
        builder.append("## Implementation Steps").append('\n');
        Iterable iterable = plan.getSteps();
        long l2 = 0L;
        for (Object t : iterable) {
            void it;
            PlanStep planStep = (PlanStep)t;
            long l3 = l2;
            boolean bl = false;
            Long l4 = it.getDurationMillis();
            long l5 = l4 != null ? l4 : 0L;
            l2 = l3 + l5;
        }
        long totalDurationMillis = l2;
        if (totalDurationMillis > 0L) {
            builder.append("**Total Duration:** " + this.formatDuration(totalDurationMillis)).append('\n');
        }
        builder.append('\n');
        Iterable $this$forEach$iv = plan.getSteps();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it;
            PlanStep step2 = (PlanStep)element$iv;
            boolean bl = false;
            builder.append("### " + step2.getId() + ": " + step2.getDescription()).append('\n');
            builder.append("- **Status:** " + step2.getStatus()).append('\n');
            if (step2.getDetailedUpdates() != null) {
                builder.append("- **Updates:** " + step2.getDetailedUpdates()).append('\n');
            }
            if (!((Collection)step2.getAcceptanceCriteria()).isEmpty()) {
                builder.append("- **Acceptance Criteria:**").append('\n');
                Iterable $this$forEach$iv2 = step2.getAcceptanceCriteria();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String criteria = (String)element$iv2;
                    boolean bl2 = false;
                    builder.append("  - " + criteria).append('\n');
                }
            }
            Long l6 = step2.getDurationMillis();
            if (l6 != null) {
                it = ((Number)l6).longValue();
                boolean bl3 = false;
                builder.append("- **Duration:** " + this.formatDuration(it)).append('\n');
            }
            if (step2.getStatus() == TaskStatus.IN_PROGRESS) {
                Long l7 = step2.getStartTimeMillis();
                if (l7 != null) {
                    it = ((Number)l7).longValue();
                    boolean bl4 = false;
                    builder.append("- **StartTime:** " + this.formatTimestamp(it)).append('\n');
                }
            }
            builder.append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @ToolFunction(name="pick_next_task", description="\n      Fetch details of the next pending task from the current plan.\n      Marks the task status as IN_PROGRESS and starts a timer for its duration.\n      Returns errors if pan or steps are empty.\n      Returns errors if current task is not complete.\n    ", displayText="Fetching the next task from the plan.")
    @NotNull
    public final Response getNextTask(@NotNull ToolContext context2) {
        int n;
        int pendingIdx;
        List blockedBefore;
        PlanStep firstCandidate;
        List<PlanStep> steps;
        block16: {
            int n2;
            block15: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object v2;
                block14: {
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    ProjectPlan projectPlan = this.currentPlan;
                    if (projectPlan == null) {
                        return new Response(null, "No plan saved. Please create and save a plan.", null, null, null, 29, null);
                    }
                    ProjectPlan plan = projectPlan;
                    List<PlanStep> list = plan.getSteps();
                    if (list == null) {
                        return new Response(null, "No steps inside the plan. Save a plan with steps", null, null, null, 29, null);
                    }
                    steps = list;
                    if (steps.isEmpty()) {
                        return new Response(null, "No steps inside the plan.", null, null, null, 29, null);
                    }
                    Iterable $this$firstOrNull$iv = steps;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PlanStep it = (PlanStep)element$iv;
                        boolean bl = false;
                        if (!(it.getStatus() == TaskStatus.PENDING || it.getStatus() == TaskStatus.IN_PROGRESS)) continue;
                        v2 = element$iv;
                        break block14;
                    }
                    v2 = null;
                }
                PlanStep planStep = v2;
                if (planStep == null) {
                    return new Response("All tasks are complete!", null, null, null, null, 30, null);
                }
                firstCandidate = planStep;
                if (firstCandidate.getStatus() == TaskStatus.PENDING) {
                    firstCandidate.setStatus(TaskStatus.IN_PROGRESS);
                    firstCandidate.setStartTimeMillis(System.currentTimeMillis());
                    this.handlePlanChange(context2);
                }
                Iterable $this$takeWhile$iv = steps;
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    PlanStep it = (PlanStep)item$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)firstCandidate))) break;
                    list$iv.add(item$iv);
                }
                $this$takeWhile$iv = list$iv;
                boolean $i$f$filter = false;
                list$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo22 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PlanStep it = (PlanStep)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getStatus() == TaskStatus.BLOCKED)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                blockedBefore = (List)destination$iv$iv;
                List<PlanStep> $this$indexOfFirst$iv = steps;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<PlanStep> $i$f$filterTo22 = $this$indexOfFirst$iv.iterator();
                while ($i$f$filterTo22.hasNext()) {
                    PlanStep item$iv;
                    PlanStep it = item$iv = $i$f$filterTo22.next();
                    boolean bl = false;
                    if (it.getStatus() == TaskStatus.PENDING) {
                        n2 = index$iv;
                        break block15;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            pendingIdx = n2;
            List<PlanStep> $this$indexOfFirst$iv = steps;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<PlanStep> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                PlanStep item$iv;
                PlanStep it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getStatus() == TaskStatus.IN_PROGRESS) {
                    n = index$iv;
                    break block16;
                }
                ++index$iv;
            }
            n = -1;
        }
        int inProgressIdx = n;
        List extraInProgress = pendingIdx != -1 && inProgressIdx > pendingIdx && !Intrinsics.areEqual((Object)steps.get(inProgressIdx), (Object)firstCandidate) ? CollectionsKt.listOf((Object)steps.get(inProgressIdx)) : CollectionsKt.emptyList();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"nextTask", (Object)firstCandidate)};
        Map result2 = MapsKt.mutableMapOf((Pair[])pairArray);
        if (!((Collection)extraInProgress).isEmpty()) {
            result2.put("alsoInProgress", extraInProgress);
        }
        if (!((Collection)blockedBefore).isEmpty()) {
            result2.put("blockedBefore", blockedBefore);
        }
        return new Response(new Gson().toJson((Object)result2), null, null, null, null, 30, null);
    }

    @ToolFunction(name="get_task_details", description="\n      Fetch details of a specific task from the current plan.\n\n      Args:\n        task_id: The ID of the task to retrieve.\n      ", displayText="Fetching task details for task {task_id}.")
    @NotNull
    public final Response getTaskDetails(@NotNull ToolContext context2, @NotNull String task_id) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)task_id, (String)"task_id");
            ProjectPlan projectPlan = this.currentPlan;
            if (projectPlan == null) {
                return new Response(null, "No plan saved. Please create and save a plan.", null, null, null, 29, null);
            }
            ProjectPlan plan = projectPlan;
            Iterable iterable = plan.getSteps();
            for (Object t : iterable) {
                PlanStep it = (PlanStep)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)task_id)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        PlanStep planStep = v1;
        if (planStep == null) {
            return new Response(null, "Task with ID '" + task_id + "' not found.", null, null, null, 29, null);
        }
        PlanStep task = planStep;
        return new Response(new Gson().toJson((Object)task), null, null, null, null, 30, null);
    }

    @ToolFunction(name="update_task", description="\n      Updates the task with details and status. Also returns next task to execute from current plan.\n      If the task is completed or blocked, its execution duration is calculated and saved.\n      Args:\n        task_id: The ID of the task to update.\n        status: The new status of the task.\n        detailed_updates: Any detailed updates or notes for the task.\n      ", displayText="Updating task {task_id}.")
    @NotNull
    public final Response updateTask(@NotNull ToolContext context2, @NotNull String task_id, @NotNull TaskStatus status2, @NotNull String detailed_updates) {
        Object v1;
        block6: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)task_id, (String)"task_id");
            Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
            Intrinsics.checkNotNullParameter((Object)detailed_updates, (String)"detailed_updates");
            ProjectPlan projectPlan = this.currentPlan;
            if (projectPlan == null) {
                return new Response(null, "No plan saved. Please create and save a plan.", null, null, null, 29, null);
            }
            ProjectPlan plan = projectPlan;
            Iterable iterable = plan.getSteps();
            for (Object t : iterable) {
                PlanStep it = (PlanStep)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)task_id)) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        PlanStep planStep = v1;
        if (planStep == null) {
            return new Response(null, "Task with ID '" + task_id + "' not found.", null, null, null, 29, null);
        }
        PlanStep task = planStep;
        if ((status2 == TaskStatus.COMPLETED || status2 == TaskStatus.BLOCKED) && task.getStatus() == TaskStatus.IN_PROGRESS) {
            Long l2 = task.getStartTimeMillis();
            if (l2 != null) {
                long startTime = ((Number)l2).longValue();
                boolean bl = false;
                long elapsed = System.currentTimeMillis() - startTime;
                Long l3 = task.getDurationMillis();
                task.setDurationMillis((l3 != null ? l3 : 0L) + elapsed);
                task.setStartTimeMillis(null);
            }
        }
        task.setStatus(status2);
        task.setDetailedUpdates(detailed_updates);
        Response nextTask = this.getNextTask(context2);
        String responseStr = "Task " + task_id + " updated successfully.";
        if (status2 == TaskStatus.COMPLETED) {
            responseStr = nextTask.getError() == null ? responseStr + "\n Here is the next task " + nextTask.getStatus() : responseStr + "\n Could not fetch next task - error:  " + nextTask.getError();
        }
        this.handlePlanChange(context2);
        return new Response(responseStr, null, null, null, null, 30, null);
    }

    @NotNull
    public final String getPlanSummary() {
        StringBuilder stringBuilder;
        ProjectPlan projectPlan = this.currentPlan;
        if (projectPlan == null) {
            return "No plan saved.";
        }
        ProjectPlan plan = projectPlan;
        List<PlanStep> steps = plan.getSteps();
        if (steps.isEmpty()) {
            return "Plan has no steps.";
        }
        int totalSteps = steps.size();
        int shown = 0;
        PlanStep currentTask = null;
        String lastCompletedId = null;
        StringBuilder $this$getPlanSummary_u24lambda_u2430 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getPlanSummary_u24lambda_u2430.append("\ud83d\udccb Project Summary").append('\n');
        $this$getPlanSummary_u24lambda_u2430.append("Project: " + plan.getProjectDescription()).append('\n');
        $this$getPlanSummary_u24lambda_u2430.append("Requirements: " + plan.getProjectBrief()).append('\n');
        $this$getPlanSummary_u24lambda_u2430.append('\n');
        $this$getPlanSummary_u24lambda_u2430.append("Progress so far:").append('\n');
        for (PlanStep step2 : steps) {
            if (step2.getStatus() == TaskStatus.PENDING) break;
            ++shown;
            $this$getPlanSummary_u24lambda_u2430.append(step2.getId() + " [" + step2.getStatus() + "]").append('\n');
            $this$getPlanSummary_u24lambda_u2430.append(" - Description: " + step2.getDescription()).append('\n');
            $this$getPlanSummary_u24lambda_u2430.append(" - Detailed updates: " + step2.getDetailedUpdates()).append('\n');
            $this$getPlanSummary_u24lambda_u2430.append(" - Acceptance criteria: " + step2.getAcceptanceCriteria()).append('\n');
            if (step2.getStatus() == TaskStatus.IN_PROGRESS) {
                currentTask = step2;
                continue;
            }
            if (step2.getStatus() != TaskStatus.COMPLETED) continue;
            lastCompletedId = step2.getId();
        }
        $this$getPlanSummary_u24lambda_u2430.append('\n');
        $this$getPlanSummary_u24lambda_u2430.append(totalSteps - shown + " steps remaining.").append('\n');
        String string = lastCompletedId;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$getPlanSummary_u24lambda_u2430.append("Last completed task: " + it).append('\n');
        }
        PlanStep planStep = currentTask;
        if (planStep != null) {
            PlanStep current2 = planStep;
            boolean bl3 = false;
            $this$getPlanSummary_u24lambda_u2430.append("Current in progress: " + current2.getId() + " \u2192 " + current2.getDescription()).append('\n');
            String string2 = current2.getDetailedUpdates();
            if (string2 != null) {
                String it = string2;
                boolean bl4 = false;
                $this$getPlanSummary_u24lambda_u2430.append("Detailed updates: " + it).append('\n');
            }
            if (!((Collection)current2.getAcceptanceCriteria()).isEmpty()) {
                $this$getPlanSummary_u24lambda_u2430.append("Acceptance criteria: " + current2.getAcceptanceCriteria()).append('\n');
            }
        }
        String summary = stringBuilder.toString();
        return ((Object)StringsKt.trimEnd((CharSequence)summary)).toString();
    }

    private static final void handlePlanChange$lambda$1$lambda$0(ToolContext $context, VirtualFile $file) {
        FileEditorManager.getInstance((Project)$context.getProject()).openFile($file, true);
    }

    private static final VirtualFile getOrCreatePlanDirectory$lambda$5(VirtualFile $projectBaseDir, PlanTools this$0) {
        VirtualFile virtualFile2 = $projectBaseDir.findChild(AGENT_DIR_NAME);
        if (virtualFile2 == null) {
            VirtualFile virtualFile3 = $projectBaseDir.createChildDirectory((Object)this$0, AGENT_DIR_NAME);
            virtualFile2 = virtualFile3;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"createChildDirectory(...)");
        }
        return virtualFile2;
    }

    private static final VirtualFile updatePlanFile$lambda$6(VirtualFile $planDir, PlanTools this$0, String $markdownContent) {
        VirtualFile virtualFile2 = $planDir.findOrCreateChildData((Object)this$0, PLAN_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"findOrCreateChildData(...)");
        VirtualFile planFile = virtualFile2;
        VfsUtil.saveText((VirtualFile)planFile, (String)$markdownContent);
        VirtualFile virtualFile3 = $planDir.findOrCreateChildData((Object)this$0, ".aiexclude");
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"findOrCreateChildData(...)");
        VirtualFile excludeFile = virtualFile3;
        VfsUtil.saveText((VirtualFile)excludeFile, (String)PLAN_FILE_NAME);
        return planFile;
    }

    /*
     * WARNING - void declaration
     */
    private static final PlanStep parsePlanFromMarkdown$lambda$13(PlanTools this$0, MatchResult stepMatch) {
        PlanStep planStep;
        Long startTimeMillis;
        Long l2;
        List list;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)stepMatch, (String)"stepMatch");
        String header = ((Object)StringsKt.trim((CharSequence)((String)stepMatch.getGroupValues().get(1)))).toString();
        String details = ((Object)StringsKt.trim((CharSequence)((String)stepMatch.getGroupValues().get(2)))).toString();
        String[] stringArray = new String[]{":"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)header, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        List headerParts = (List)destination$iv$iv;
        if (headerParts.size() < 2) {
            return null;
        }
        String id = (String)headerParts.get(0);
        String description = (String)headerParts.get(1);
        Regex statusRegex = new Regex("-\\s*\\*\\*Status:\\*\\*\\s*(.*)");
        Regex updatesRegex = new Regex("-\\s*\\*\\*Updates:\\*\\*\\s*(.*)");
        Regex durationRegex = new Regex("-\\s*\\*\\*Duration:\\*\\*\\s*(.*)");
        Regex startTimeRegex = new Regex("-\\s*\\*\\*StartTime:\\*\\*\\s*(.*)");
        Regex acceptanceCriteriaRegex = new Regex("-\\s*\\*\\*Acceptance Criteria:\\*\\*\\s*\\n((?:[ \\t]+-(?![ \\t]*\\*\\*(?:Duration|Status|Updates|StartTime):).*\\n?)*)");
        Object object = Regex.find$default((Regex)statusRegex, (CharSequence)details, (int)0, (int)2, null);
        String statusStr = object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
        Object object2 = Regex.find$default((Regex)updatesRegex, (CharSequence)details, (int)0, (int)2, null);
        String updates = object2 != null && (object2 = object2.getGroupValues()) != null && (object2 = (String)object2.get(1)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString() : null;
        Object object3 = Regex.find$default((Regex)durationRegex, (CharSequence)details, (int)0, (int)2, null);
        String durationStr = object3 != null && (object3 = object3.getGroupValues()) != null && (object3 = (String)object3.get(1)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString() : null;
        Object object4 = Regex.find$default((Regex)startTimeRegex, (CharSequence)details, (int)0, (int)2, null);
        String startTimeStr = object4 != null && (object4 = object4.getGroupValues()) != null && (object4 = (String)object4.get(1)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object4))).toString() : null;
        Object object5 = Regex.find$default((Regex)acceptanceCriteriaRegex, (CharSequence)details, (int)0, (int)2, null);
        Object acceptanceCriteriaBlock = object5 != null && (object5 = object5.getGroupValues()) != null && (object5 = (String)object5.get(1)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object5))).toString() : null;
        List list2 = acceptanceCriteriaBlock;
        if (list2 != null && (list2 = StringsKt.lines((CharSequence)((CharSequence)((Object)list2)))) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                CharSequence charSequence;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (CharSequence)"-"))).toString();
                if (charSequence2.length() == 0) {
                    boolean bl3 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                if ((String)charSequence == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        List acceptanceCriteria = list;
        String string = durationStr;
        if (string != null) {
            String it = string;
            boolean bl = false;
            l2 = this$0.parseDuration$aiplugin_android(it);
        } else {
            l2 = null;
        }
        Long durationMillis = l2;
        String string2 = startTimeStr;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            v11 = this$0.parseTimestamp(it);
        } else {
            v11 = startTimeMillis = null;
        }
        if (statusStr != null) {
            TaskStatus status2 = TaskStatus.valueOf(statusStr);
            planStep = new PlanStep(id, description, status2, updates, acceptanceCriteria, startTimeMillis, durationMillis);
        } else {
            PlanTools $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PlanTools.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to parse step, missing fields. Details: ID: " + id + ", Header: " + header);
            planStep = null;
        }
        return planStep;
    }

    public PlanTools() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/studio/ml/npa/tools/PlanTools$Companion;", "", "<init>", "()V", "AGENT_DIR_NAME", "", "PLAN_FILE_NAME", "aiplugin.android"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

