/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.npa.logs;

import androidx.compose.runtime.internal.StabilityInferred;
import andromeda.AgentLog;
import com.android.studio.ml.npa.logs.LlmAgentLoggerUtilityKt;
import com.android.tools.idea.studiobot.TokenUsageMetadata;
import com.android.tools.idea.studiobot.prompts.Prompt;
import com.google.aiplugin.agents.logs.AgentLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.protobuf.Timestamp;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016J*\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0016JD\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u000e\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J.\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010(0'H\u0016J2\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00032\b\u0010+\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` H\u0016J \u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/studio/ml/npa/logs/AgentLoggerImpl;", "Lcom/google/aiplugin/agents/logs/AgentLogger;", "sessionId", "", "agentName", "executor", "Ljava/util/concurrent/ExecutorService;", "baseLogPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/concurrent/ExecutorService;Ljava/nio/file/Path;)V", "startTimes", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/google/protobuf/Timestamp;", "logStream", "Ljava/io/FileOutputStream;", "getCurrentTimestamp", "write", "", "entry", "Landromeda/AgentLog$LogEntry;", "close", "logModelCallStart", "project", "Lcom/intellij/openapi/project/Project;", "invocationId", "currentPrompt", "Lcom/android/tools/idea/studiobot/prompts/Prompt;", "previousPrompt", "logModelCallEnd", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "usageMetadata", "Lcom/android/tools/idea/studiobot/TokenUsageMetadata;", "logToolCallStart", "id", "toolName", "params", "", "", "logToolCallEnd", "toolCallId", "result", "logError", "msg", "errorType", "errorMessage", "debug", "details", "aiplugin.android"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAgentLoggerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentLoggerImpl.kt\ncom/android/studio/ml/npa/logs/AgentLoggerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,282:1\n24#2:283\n24#2:284\n24#2:285\n*S KotlinDebug\n*F\n+ 1 AgentLoggerImpl.kt\ncom/android/studio/ml/npa/logs/AgentLoggerImpl\n*L\n89#1:283\n103#1:284\n84#1:285\n*E\n"})
public final class AgentLoggerImpl
implements AgentLogger {
    @NotNull
    private final String sessionId;
    @NotNull
    private final String agentName;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final Path baseLogPath;
    @NotNull
    private final ConcurrentHashMap<String, Timestamp> startTimes;
    @NotNull
    private final FileOutputStream logStream;
    public static final int $stable = 8;

    public AgentLoggerImpl(@NotNull String sessionId, @NotNull String agentName, @NotNull ExecutorService executor, @NotNull Path baseLogPath) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)baseLogPath, (String)"baseLogPath");
        this.sessionId = sessionId;
        this.agentName = agentName;
        this.executor = executor;
        this.baseLogPath = baseLogPath;
        this.startTimes = new ConcurrentHashMap();
        Path logPath = this.baseLogPath.resolve("AgentLogs").resolve(this.sessionId);
        Files.createDirectories(logPath, new FileAttribute[0]);
        File logFile = logPath.resolve(this.agentName + "_trace.ldp").toFile();
        this.logStream = new FileOutputStream(logFile, true);
    }

    public /* synthetic */ AgentLoggerImpl(String string, String string2, ExecutorService executorService, Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Path path3 = Paths.get(PathManager.getLogPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            path2 = path3;
        }
        this(string, string2, executorService, path2);
    }

    private final Timestamp getCurrentTimestamp() {
        Instant instant = Instant.now();
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
        Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"build(...)");
        return timestamp;
    }

    private final void write(AgentLog.LogEntry entry) {
        try {
            this.executor.submit(() -> AgentLoggerImpl.write$lambda$1(this, entry));
        }
        catch (RejectedExecutionException e) {
            AgentLoggerImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AgentLoggerImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Agent log write rejected, logger is likely shutting down.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            FileOutputStream fileOutputStream = this.logStream;
            synchronized (fileOutputStream) {
                boolean $i$a$-synchronized-AgentLoggerImpl$close$22 = false;
                this.logStream.flush();
                this.logStream.getFD().sync();
                this.logStream.close();
                Unit $i$a$-synchronized-AgentLoggerImpl$close$22 = Unit.INSTANCE;
            }
        }
        catch (Throwable t) {
            AgentLoggerImpl $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AgentLoggerImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error closing agent log file: " + t, t);
        }
    }

    @Override
    public void logModelCallStart(@NotNull Project project2, @NotNull String invocationId, @NotNull Prompt currentPrompt, @Nullable Prompt previousPrompt) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)invocationId, (String)"invocationId");
        Intrinsics.checkNotNullParameter((Object)currentPrompt, (String)"currentPrompt");
        Timestamp timestamp = this.getCurrentTimestamp();
        ((Map)this.startTimes).put(invocationId, timestamp);
        AgentLog.ModelCallStartDetails details = AgentLog.ModelCallStartDetails.newBuilder().setModelCallId(invocationId).setPromptJson(LlmAgentLoggerUtilityKt.generateLogMessageForModelCallStart(project2, previousPrompt, currentPrompt)).build();
        AgentLog.LogEntry entry = AgentLog.LogEntry.newBuilder().setSessionId(this.sessionId).setTimestamp(timestamp).setEventType(AgentLog.LogEntry.EventType.MODEL_CALL_START).setLoggerName(this.agentName).setMessage("Invoking Gemini.").setDetail(AgentLog.Detail.newBuilder().setModelCallStart(details)).build();
        Intrinsics.checkNotNull((Object)entry);
        this.write(entry);
    }

    @Override
    public void logModelCallEnd(@NotNull Project project2, @NotNull String invocationId, @NotNull Prompt currentPrompt, @Nullable Prompt previousPrompt, @Nullable Exception error, @Nullable TokenUsageMetadata usageMetadata) {
        AgentLog.ErrorDetails errorDetails;
        Long l2;
        Object it;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)invocationId, (String)"invocationId");
        Intrinsics.checkNotNullParameter((Object)currentPrompt, (String)"currentPrompt");
        String response2 = LlmAgentLoggerUtilityKt.generateLogMessageForModelCallEnd(project2, previousPrompt, currentPrompt);
        Timestamp timestamp = this.getCurrentTimestamp();
        Timestamp timestamp2 = this.startTimes.remove(invocationId);
        if (timestamp2 != null) {
            it = timestamp2;
            boolean bl = false;
            l2 = timestamp.getSeconds() * (long)1000 + (long)(timestamp.getNanos() / 1000000) - (it.getSeconds() * (long)1000 + (long)(it.getNanos() / 1000000));
        } else {
            l2 = null;
        }
        Long durationMs = l2;
        Exception exception = error;
        if (exception != null) {
            it = exception;
            boolean bl = false;
            AgentLog.ErrorDetails.Builder builder = AgentLog.ErrorDetails.newBuilder().setErrorType(it.getClass().getSimpleName());
            String string = ((Throwable)it).getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            errorDetails = builder.setErrorMessage(string).build();
        } else {
            errorDetails = null;
        }
        AgentLog.ErrorDetails errorDetails2 = errorDetails;
        Object $this$logModelCallEnd_u24lambda_u245 = it = AgentLog.ModelCallEndDetails.newBuilder().setModelCallId(invocationId);
        boolean bl = false;
        $this$logModelCallEnd_u24lambda_u245.setResponseJson(response2);
        if (durationMs != null) {
            $this$logModelCallEnd_u24lambda_u245.setDurationMs(durationMs.longValue());
        }
        if (errorDetails2 != null) {
            $this$logModelCallEnd_u24lambda_u245.setError(errorDetails2);
        }
        if (usageMetadata != null) {
            $this$logModelCallEnd_u24lambda_u245.setInputTokenCount(usageMetadata.getInputTokenCount());
            $this$logModelCallEnd_u24lambda_u245.setOutputTokenCount(usageMetadata.getOutputTokenCount());
        }
        AgentLog.ModelCallEndDetails details = it.build();
        AgentLog.LogEntry entry = AgentLog.LogEntry.newBuilder().setSessionId(this.sessionId).setTimestamp(timestamp).setEventType(AgentLog.LogEntry.EventType.MODEL_CALL_END).setLoggerName(this.agentName).setMessage("Finished invoking Gemini.").setDetail(AgentLog.Detail.newBuilder().setModelCallEnd(details)).build();
        Intrinsics.checkNotNull((Object)entry);
        this.write(entry);
    }

    @Override
    public void logToolCallStart(@NotNull String id, @NotNull String toolName, @NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Timestamp timestamp = this.getCurrentTimestamp();
        ((Map)this.startTimes).put(id, timestamp);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        AgentLog.ToolCallStartDetails details = AgentLog.ToolCallStartDetails.newBuilder().setToolCallId(id).setToolName(toolName).setParamsJson(gson.toJson(params)).build();
        AgentLog.LogEntry entry = AgentLog.LogEntry.newBuilder().setSessionId(this.sessionId).setTimestamp(timestamp).setEventType(AgentLog.LogEntry.EventType.TOOL_CALL_START).setLoggerName(this.agentName).setMessage("Calling tool: " + toolName).setDetail(AgentLog.Detail.newBuilder().setToolCallStart(details)).build();
        Intrinsics.checkNotNull((Object)entry);
        this.write(entry);
    }

    @Override
    public void logToolCallEnd(@NotNull String toolCallId, @NotNull String toolName, @Nullable String result2, @Nullable Exception error) {
        AgentLog.ErrorDetails errorDetails;
        Long l2;
        Object it;
        Intrinsics.checkNotNullParameter((Object)toolCallId, (String)"toolCallId");
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Timestamp timestamp = this.getCurrentTimestamp();
        Timestamp timestamp2 = this.startTimes.remove(toolCallId);
        if (timestamp2 != null) {
            it = timestamp2;
            boolean bl = false;
            l2 = timestamp.getSeconds() * (long)1000 + (long)(timestamp.getNanos() / 1000000) - (it.getSeconds() * (long)1000 + (long)(it.getNanos() / 1000000));
        } else {
            l2 = null;
        }
        Long durationMs = l2;
        Exception exception = error;
        if (exception != null) {
            it = exception;
            boolean bl = false;
            AgentLog.ErrorDetails.Builder builder = AgentLog.ErrorDetails.newBuilder().setErrorType(it.getClass().getSimpleName());
            String string = ((Throwable)it).getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            errorDetails = builder.setErrorMessage(string).build();
        } else {
            errorDetails = null;
        }
        AgentLog.ErrorDetails errorDetails2 = errorDetails;
        Object $this$logToolCallEnd_u24lambda_u248 = it = AgentLog.ToolCallEndDetails.newBuilder().setToolCallId(toolCallId).setToolName(toolName);
        boolean bl = false;
        if (result2 != null) {
            $this$logToolCallEnd_u24lambda_u248.setToolResultJson(result2);
        }
        if (durationMs != null) {
            $this$logToolCallEnd_u24lambda_u248.setDurationMs(durationMs.longValue());
        }
        if (errorDetails2 != null) {
            $this$logToolCallEnd_u24lambda_u248.setError(errorDetails2);
        }
        AgentLog.ToolCallEndDetails details = it.build();
        AgentLog.LogEntry entry = AgentLog.LogEntry.newBuilder().setSessionId(this.sessionId).setTimestamp(timestamp).setEventType(AgentLog.LogEntry.EventType.TOOL_CALL_END).setLoggerName(this.agentName).setMessage("Tool call finished.").setDetail(AgentLog.Detail.newBuilder().setToolCallEnd(details)).build();
        Intrinsics.checkNotNull((Object)entry);
        this.write(entry);
    }

    @Override
    public void logError(@NotNull String msg, @NotNull String errorType, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)errorType, (String)"errorType");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        AgentLog.ErrorDetails details = AgentLog.ErrorDetails.newBuilder().setErrorType(errorType).setErrorMessage(errorMessage).build();
        AgentLog.LogEntry entry = AgentLog.LogEntry.newBuilder().setSessionId(this.sessionId).setTimestamp(this.getCurrentTimestamp()).setEventType(AgentLog.LogEntry.EventType.GENERIC_ERROR).setLoggerName(this.agentName).setMessage(msg).setDetail(AgentLog.Detail.newBuilder().setGenericError(details)).build();
        Intrinsics.checkNotNull((Object)entry);
        this.write(entry);
    }

    @Override
    public void debug(@NotNull String msg, @NotNull String details) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        AgentLog.GenericDetails genericDetails = AgentLog.GenericDetails.newBuilder().setDetails(details).build();
        AgentLog.LogEntry entry = AgentLog.LogEntry.newBuilder().setSessionId(this.sessionId).setTimestamp(this.getCurrentTimestamp()).setEventType(AgentLog.LogEntry.EventType.EVENT_TYPE_UNSPECIFIED).setLoggerName(this.agentName).setMessage(msg).setDetail(AgentLog.Detail.newBuilder().setGenericDetails(genericDetails)).build();
        Intrinsics.checkNotNull((Object)entry);
        this.write(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void write$lambda$1(AgentLoggerImpl this$0, AgentLog.LogEntry $entry) {
        try {
            FileOutputStream fileOutputStream = this$0.logStream;
            synchronized (fileOutputStream) {
                boolean $i$a$-synchronized-AgentLoggerImpl$write$1$22 = false;
                $entry.writeDelimitedTo((OutputStream)this$0.logStream);
                this$0.logStream.flush();
                Unit $i$a$-synchronized-AgentLoggerImpl$write$1$22 = Unit.INSTANCE;
            }
        }
        catch (Throwable t) {
            AgentLoggerImpl $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(AgentLoggerImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error writing agent log entry: " + t);
        }
    }
}

