/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys.metrics;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/android/studio/ml/journeys/metrics/JourneyEngineErrorParser;", "", "<init>", "()V", "Companion", "aiplugin.android.journeys"})
@StabilityInferred(parameters=1)
public final class JourneyEngineErrorParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String ENGINE_EXECUTION_EXCEPTION_NAME = "JourneyExecutionException";
    @NotNull
    private static final String ENGINE_ASSERTION_EXCEPTION_NAME = "JourneysAssertionError";

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/studio/ml/journeys/metrics/JourneyEngineErrorParser$Companion;", "", "<init>", "()V", "ENGINE_EXECUTION_EXCEPTION_NAME", "", "ENGINE_ASSERTION_EXCEPTION_NAME", "isEngineExecutionException", "", "stackTrace", "isEngineAssertionException", "tryToParseReasonFromEngineException", "aiplugin.android.journeys"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEngineExecutionException(@NotNull String stackTrace) {
            Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
            return StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)JourneyEngineErrorParser.ENGINE_EXECUTION_EXCEPTION_NAME, (boolean)false, (int)2, null);
        }

        public final boolean isEngineAssertionException(@NotNull String stackTrace) {
            Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
            return StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)JourneyEngineErrorParser.ENGINE_ASSERTION_EXCEPTION_NAME, (boolean)false, (int)2, null);
        }

        @Nullable
        public final String tryToParseReasonFromEngineException(@NotNull String stackTrace) {
            Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
            if (!this.isEngineExecutionException(stackTrace)) {
                return null;
            }
            Regex regex = new Regex("\\[Reason=([A-Z0-9_]+)]");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)stackTrace, (int)0, (int)2, null);
            MatchResult matchResult2 = matchResult;
            return matchResult2 != null && (matchResult2 = matchResult2.getGroups()) != null && (matchResult2 = matchResult2.get(1)) != null ? matchResult2.getValue() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

