/*
 * Decompiled with CFR 0.152.
 */
package com.android.studio.ml.journeys;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class JourneysBundle {
    private static final String BUNDLE_NAME = "messages.JourneysBundle";
    private static Reference<ResourceBundle> ourBundle;

    private static ResourceBundle getBundle() {
        ResourceBundle bundle;
        ResourceBundle resourceBundle = bundle = ourBundle != null ? ourBundle.get() : null;
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    private JourneysBundle() {
    }

    public static String message(String key, Object ... params) {
        return JourneysBundle.readFromBundleAndFormat(JourneysBundle.getBundle(), key, params);
    }

    private static String readFromBundleAndFormat(ResourceBundle bundle, String key, Object ... params) {
        String rawValue = bundle.getString(key);
        Locale locale = bundle.getLocale();
        MessageFormat format = new MessageFormat(rawValue, locale);
        return format.format(params);
    }
}

